/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import javax.cache.processor.MutableEntry;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.util.ReflectionUtil;

public final class MutableJCacheEntry<K, V>
implements MutableEntry<K, V> {
    private final BasicCache<K, V> cache;
    private final BasicCache<K, V> cacheWithoutStats;
    private final K key;
    private final V oldValue;
    private V value;
    private Operation operation;

    public MutableJCacheEntry(BasicCache<K, V> cache, BasicCache<K, V> cacheWithoutStats, K key, V value) {
        this.cache = cache;
        this.cacheWithoutStats = cacheWithoutStats;
        this.key = key;
        this.oldValue = value;
        this.operation = Operation.NONE;
    }

    public boolean exists() {
        if (this.value != null) {
            return true;
        }
        if (!this.operation.isRemoved()) {
            return this.cacheWithoutStats.containsKey(this.key);
        }
        return false;
    }

    public void remove() {
        this.operation = this.value != null ? Operation.NONE : Operation.REMOVE;
        this.value = null;
    }

    public void setValue(V value) {
        this.value = value;
        this.operation = Operation.UPDATE;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (!this.operation.isRemoved()) {
            if (this.oldValue != null) {
                this.operation = Operation.ACCESS;
                return this.oldValue;
            }
            return (V)this.cache.get(this.key);
        }
        return null;
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)ReflectionUtil.unwrap((Object)this, clazz);
    }

    public V getNewValue() {
        return this.value;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public static enum Operation {
        NONE,
        ACCESS,
        REMOVE,
        UPDATE;


        boolean isRemoved() {
            return this == REMOVE;
        }
    }
}

