/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.ParseTemplate;
import com.github.drapostolos.typeparser.TypeParser;
import com.github.drapostolos.typeparser.TypeParserUtility;
import java.lang.reflect.Type;

class TargetTypeChecker
extends ParseTemplate<Boolean> {
    private final TypeParser parser;

    public TargetTypeChecker(TypeParser parser, Type targetType) {
        super(parser.parsers, targetType);
        this.parser = parser;
    }

    @Override
    Boolean actionWhenTargetTypeHasNormalTypeParser() {
        return true;
    }

    @Override
    Boolean actionWhenTargetTypeIsArrayClass() {
        Class<?> type = TypeParserUtility.getComponentClass(this.targetType);
        return this.parser.isTargetTypeParsable(type);
    }

    @Override
    Boolean actionWhenTargetTypeHasStaticFactoryMethod() {
        return true;
    }

    @Override
    Boolean actionWhenTargetTypeIsGenericArrayType() {
        Class<?> type = TypeParserUtility.getComponentClass(this.targetType);
        return this.parser.isTargetTypeParsable(type);
    }

    @Override
    Boolean lastAction() {
        return false;
    }

    @Override
    Boolean actionWhenTaretTypeIsGeneric(Class<?> cls) {
        for (Class type : TypeParserUtility.getParameterizedTypeArguments(this.targetType)) {
            if (this.parser.isTargetTypeParsable(type)) continue;
            return false;
        }
        return true;
    }

    @Override
    Boolean actionWhenTargetTypeIsAssignalbleTo(Class<?> superClass) {
        return true;
    }
}

