/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.logging;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingConnection;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingResultSet;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingUtil;
import org.slf4j.Logger;

public class LoggingStatement
implements Statement {
    private final Statement statement;
    protected final String statementID;
    protected final Logger logger;

    public LoggingStatement(Statement statement, Logger logger) {
        this.statement = statement;
        this.logger = logger;
        this.statementID = LoggingUtil.getID(statement);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public String getStatementID() {
        return this.statementID;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        LoggingResultSet rs = new LoggingResultSet(this.statement.executeQuery(sql), this.logger);
        this.logger.trace("{}.executeQuery({}) = {}", new Object[]{this.statementID, sql, rs.getResultSetID()});
        return rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        int i = this.statement.executeUpdate(sql);
        this.logger.trace("{}.executeUpdate({}) = {}", new Object[]{this.statementID, sql, i});
        return i;
    }

    @Override
    public void close() throws SQLException {
        this.logger.trace("{}.close()", (Object)this.statementID);
        this.statement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        int i = this.statement.getMaxFieldSize();
        this.logger.trace("{}.getMaxFieldSize() = {}", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.logger.trace("{}.setMaxFieldSize({})", (Object)this.statementID, (Object)max);
        this.statement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        int i = this.statement.getMaxRows();
        this.logger.trace("{}.getMaxRows() = {}", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.logger.trace("{}.setMaxRows()", (Object)this.statementID);
        this.statement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.logger.trace("{}.setEscapeProcessing({})", (Object)this.statementID, (Object)enable);
        this.statement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        int i = this.statement.getQueryTimeout();
        this.logger.trace("{}.getQueryTimeout() = {}", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.logger.trace("{}.setQueryTimeout({})", (Object)this.statementID, (Object)seconds);
        this.statement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.logger.trace("{}.cancel()", (Object)this.statementID);
        this.statement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.logger.trace("{}.getWarnings()", (Object)this.statementID);
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.logger.trace("{}.clearWarnings()", (Object)this.statementID);
        this.statement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.logger.trace("{}.setCursorName({})", (Object)this.statementID, (Object)name);
        this.statement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean b = this.statement.execute(sql);
        this.logger.trace("{}.execute({}) = {}", new Object[]{this.statementID, sql, b});
        return b;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        LoggingResultSet rs = new LoggingResultSet(this.statement.getResultSet(), this.logger);
        this.logger.trace("{}.executeQuery() = {}", (Object)this.statementID, (Object)rs.getResultSetID());
        return rs;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int i = this.statement.getUpdateCount();
        this.logger.trace("{}.getUpdateCount() = {}", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        boolean b = this.statement.getMoreResults();
        this.logger.trace("{}.getMoreResults() = {}", (Object)this.statementID, (Object)b);
        return b;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.logger.trace("{}.setFetchDirection()", (Object)this.statementID);
        this.statement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        int i = this.statement.getFetchDirection();
        this.logger.trace("{}.getFetchDirection() = {}", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.logger.trace("{}.setFetchSize({})", (Object)this.statementID, (Object)rows);
        this.statement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        int i = this.statement.getFetchSize();
        this.logger.trace("{}.getFetchSize() = {}", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        int i = this.statement.getResultSetConcurrency();
        this.logger.trace("{}.getResultSetConcurrency() = {}", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public int getResultSetType() throws SQLException {
        int i = this.statement.getResultSetType();
        this.logger.trace("{}.getResultSetType() = {}", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.logger.trace("{}.addBatch({}, {})", (Object)this.statementID);
        this.statement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.logger.trace("{}.clearBatch()", (Object)this.statementID);
        this.statement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] i = this.statement.executeBatch();
        this.logger.trace("{}.executeBatch() = {}", (Object)this.statementID, (Object)Arrays.toString(i));
        return i;
    }

    @Override
    public Connection getConnection() throws SQLException {
        LoggingConnection connection = new LoggingConnection(this.statement.getConnection(), this.logger);
        this.logger.trace("{}.getConnection() = {}", (Object)this.statementID, (Object)connection.getConnectionID());
        return connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        boolean b = this.statement.getMoreResults(current);
        this.logger.trace("{}.getMoreResults({}) = {}", new Object[]{this.statementID, current, b});
        return b;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        LoggingResultSet rs = new LoggingResultSet(this.statement.getGeneratedKeys(), this.logger);
        this.logger.trace("{}.getGeneratedKeys() = {}", (Object)this.statementID, (Object)rs.getResultSetID());
        return rs;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int i = this.statement.executeUpdate(sql, autoGeneratedKeys);
        this.logger.trace("{}.executeUpdate({}, {}) = {}", new Object[]{this.statementID, sql, autoGeneratedKeys, i});
        return i;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int i = this.statement.executeUpdate(sql, columnIndexes);
        this.logger.trace("{}.executeUpdate({}, {}) = {}", new Object[]{this.statementID, sql, Arrays.toString(columnIndexes), i});
        return i;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int i = this.statement.executeUpdate(sql, columnNames);
        this.logger.trace("{}.executeUpdate({}, {}) = {}", new Object[]{this.statementID, sql, Arrays.toString(columnNames), i});
        return i;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean b = this.statement.execute(sql, autoGeneratedKeys);
        this.logger.trace("{}.execute({}, {}) = {}", new Object[]{this.statementID, sql, autoGeneratedKeys, b});
        return b;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean b = this.statement.execute(sql, columnIndexes);
        this.logger.trace("{}.execute({}, {}) = {}", new Object[]{this.statementID, sql, Arrays.toString(columnIndexes), b});
        return b;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean b = this.statement.execute(sql, columnNames);
        this.logger.trace("{}.execute({}, {}) = {}", new Object[]{this.statementID, sql, Arrays.toString(columnNames), b});
        return b;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        int i = this.statement.getResultSetHoldability();
        this.logger.trace("{}.getResultSetHoldability() = {}", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean b = this.statement.isClosed();
        this.logger.trace("{}.isClosed() = {}", (Object)this.statementID, (Object)b);
        return b;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.logger.trace("{}.setPoolable({})", (Object)this.statementID, (Object)poolable);
        this.statement.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        boolean b = this.statement.isPoolable();
        this.logger.trace("{}.isPoolable() = {}", (Object)this.statementID, (Object)b);
        return b;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.logger.trace("{}.closeOnCompletion()", (Object)this.statementID);
        this.statement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        boolean b = this.statement.isCloseOnCompletion();
        this.logger.trace("{}.isCloseOnCompletion() = {}", (Object)this.statementID, (Object)b);
        return b;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        long x = this.statement.getLargeUpdateCount();
        this.logger.trace("{}.getLargeUpdateCount() = {}", (Object)this.statementID, (Object)x);
        return x;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.logger.trace("{}.setLargeMaxRows({})", (Object)this.statementID, (Object)max);
        this.statement.setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        long x = this.statement.getLargeMaxRows();
        this.logger.trace("{}.getLargeMaxRows() = {}", (Object)this.statementID, (Object)x);
        return x;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        long[] x = this.statement.executeLargeBatch();
        this.logger.trace("{}.executeLargeBatch() = {}", (Object)this.statementID, (Object)x);
        return x;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        long x = this.statement.executeLargeUpdate(sql);
        this.logger.trace("{}.executeLargeUpdate({}) = {}", new Object[]{this.statementID, sql, x});
        return x;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        long x = this.statement.executeLargeUpdate(sql, autoGeneratedKeys);
        this.logger.trace("{}.executeLargeUpdate() = {}", new Object[]{this.statementID, sql, autoGeneratedKeys, x});
        return x;
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        long x = this.statement.executeLargeUpdate(sql, columnIndexes);
        this.logger.trace("{}.executeLargeUpdate({}, {}) = {}", new Object[]{this.statementID, sql, Arrays.toString(columnIndexes), x});
        return x;
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        long x = this.statement.executeLargeUpdate(sql, columnNames);
        this.logger.trace("{}.executeLargeUpdate({}, {}) = {}", new Object[]{this.statementID, sql, Arrays.toString(columnNames), x});
        return x;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        T x = this.statement.unwrap(iface);
        this.logger.trace("{}.unwrap({}) = {}", new Object[]{this.statementID, iface, x});
        return x;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        boolean b = this.statement.isWrapperFor(iface);
        this.logger.trace("{}.isWrapperFor({}) = {}", new Object[]{this.statementID, iface, b});
        return b;
    }
}

