/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import java.util.ArrayList;
import java.util.Arrays;

public final class FaultException
extends RuntimeException {
    private final int signal;

    FaultException(int signal2, long[] ip, long[] procname, long[] libname) {
        super(String.format("Received signal %d", signal2));
        this.setStackTrace(FaultException.createStackTrace(ip, procname, libname, this.fillInStackTrace().getStackTrace()));
        this.signal = signal2;
    }

    private static StackTraceElement[] createStackTrace(long[] ip, long[] procname, long[] libname, StackTraceElement[] existingTrace) {
        ArrayList<StackTraceElement> trace2 = new ArrayList<StackTraceElement>();
        for (int i = 0; i < ip.length; ++i) {
            String procName = new String(Foreign.getZeroTerminatedByteArray(procname[i]));
            String libName = new String(Foreign.getZeroTerminatedByteArray(libname[i]));
            trace2.add(new StackTraceElement("native", procName, libName, -1));
        }
        trace2.addAll(Arrays.asList(existingTrace));
        return trace2.toArray(new StackTraceElement[trace2.size()]);
    }

    public int getSignal() {
        return this.signal;
    }
}

