/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.MySQLSqlAstTranslator;
import org.hibernate.dialect.TiDBDialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcOperationQueryInsertImpl;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;

public class TiDBSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private final TiDBDialect dialect = (TiDBDialect)super.getDialect();

    public TiDBSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        if (this.isIntegerDivisionEmulationRequired(arithmeticExpression)) {
            this.appendSql('(');
            this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
            this.appendSql(" div ");
            this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
            this.appendSql(')');
        } else {
            super.visitBinaryArithmeticExpression(arithmeticExpression);
        }
    }

    @Override
    protected void visitInsertSource(InsertSelectStatement statement) {
        if (statement.getSourceSelectStatement() != null) {
            if (statement.getConflictClause() != null) {
                List<ColumnReference> targetColumnReferences = statement.getTargetColumns();
                ArrayList<String> columnNames = new ArrayList<String>(targetColumnReferences.size());
                for (ColumnReference targetColumnReference : targetColumnReferences) {
                    columnNames.add(targetColumnReference.getColumnExpression());
                }
                this.appendSql("select * from ");
                this.emulateQueryPartTableReferenceColumnAliasing(new QueryPartTableReference(new SelectStatement(statement.getSourceSelectStatement()), "excluded", columnNames, false, this.getSessionFactory()));
            } else {
                statement.getSourceSelectStatement().accept(this);
            }
        } else {
            this.visitValuesList(statement.getValuesList());
        }
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        Statement currentStatement;
        if ("excluded".equals(columnReference.getQualifier()) && (currentStatement = this.getStatementStack().getCurrent()) instanceof InsertSelectStatement && ((InsertSelectStatement)currentStatement).getSourceSelectStatement() == null) {
            this.appendSql("values(");
            columnReference.appendReadExpression(this, null);
            this.append(')');
        } else {
            super.visitColumnReference(columnReference);
        }
    }

    @Override
    protected void renderDeleteClause(DeleteStatement statement) {
        this.appendSql("delete");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.DELETE);
            this.renderTableReferenceIdentificationVariable(statement.getTargetTable());
            if (statement.getFromClause().getRoots().isEmpty()) {
                this.appendSql(" from ");
                this.renderDmlTargetTableExpression(statement.getTargetTable());
            } else {
                this.visitFromClause(statement.getFromClause());
            }
        }
        finally {
            clauseStack.pop();
        }
    }

    @Override
    protected void renderUpdateClause(UpdateStatement updateStatement) {
        if (updateStatement.getFromClause().getRoots().isEmpty()) {
            super.renderUpdateClause(updateStatement);
        } else {
            this.appendSql("update ");
            this.renderFromClauseSpaces(updateStatement.getFromClause());
        }
    }

    @Override
    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable(tableReference);
        }
    }

    @Override
    protected boolean supportsJoinsInDelete() {
        return true;
    }

    @Override
    protected JdbcOperationQueryInsert translateInsert(InsertSelectStatement sqlAst) {
        this.visitInsertStatement(sqlAst);
        return new JdbcOperationQueryInsertImpl(this.getSql(), this.getParameterBinders(), this.getAffectedTableNames(), this.getUniqueConstraintNameThatMayFail(sqlAst));
    }

    @Override
    protected void visitConflictClause(ConflictClause conflictClause) {
        this.visitOnDuplicateKeyConflictClause(conflictClause);
    }

    @Override
    protected String determineColumnReferenceQualifier(ColumnReference columnReference) {
        String dmlAlias;
        MutationStatement currentDmlStatement;
        DmlTargetColumnQualifierSupport qualifierSupport = this.getDialect().getDmlTargetColumnQualifierSupport();
        if (this.getClauseStack().getCurrent() != Clause.SET || !((currentDmlStatement = this.getCurrentDmlStatement()) instanceof InsertSelectStatement) || (dmlAlias = currentDmlStatement.getTargetTable().getIdentificationVariable()) == null || !dmlAlias.equals(columnReference.getQualifier())) {
            return columnReference.getQualifier();
        }
        if (qualifierSupport != DmlTargetColumnQualifierSupport.NONE || !this.getQueryPartStack().isEmpty()) {
            return this.getCurrentDmlStatement().getTargetTable().getTableExpression();
        }
        return null;
    }

    @Override
    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept(this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && this.dialect.supportsWindowFunctions() && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.emulateValuesTableReferenceColumnAliasing(tableReference);
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderCombinedLimitClause(queryPart);
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonDistinctOperator(lhs, operator, rhs);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0'");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(" with ");
            this.appendSql(summarization.getKind().sqlText());
        } else {
            expression.accept(this);
        }
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        if (likePredicate.isCaseSensitive()) {
            likePredicate.getMatchExpression().accept(this);
            if (likePredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" like ");
            this.renderBackslashEscapedLikePattern(likePredicate.getPattern(), likePredicate.getEscapeCharacter(), this.dialect.isNoBackslashEscapesEnabled());
        } else {
            this.appendSql(this.dialect.getLowercaseFunction());
            this.appendSql('(');
            likePredicate.getMatchExpression().accept(this);
            this.appendSql(')');
            if (likePredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" like ");
            this.appendSql(this.dialect.getLowercaseFunction());
            this.appendSql('(');
            this.renderBackslashEscapedLikePattern(likePredicate.getPattern(), likePredicate.getEscapeCharacter(), this.dialect.isNoBackslashEscapesEnabled());
            this.appendSql(')');
        }
        if (likePredicate.getEscapeCharacter() != null) {
            this.appendSql(" escape ");
            likePredicate.getEscapeCharacter().accept(this);
        }
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInSet() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInInList() {
        return this.dialect.getVersion().isSameOrAfter(5, 7);
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected String getForShare(int timeoutMillis) {
        if (timeoutMillis == 0) {
            return this.getForUpdate();
        }
        return " lock in share mode";
    }

    @Override
    public TiDBDialect getDialect() {
        return this.dialect;
    }

    @Override
    public void visitCastTarget(CastTarget castTarget) {
        String sqlType = MySQLSqlAstTranslator.getSqlType(castTarget, this.getSessionFactory());
        if (sqlType != null) {
            this.appendSql(sqlType);
        } else {
            super.visitCastTarget(castTarget);
        }
    }

    @Override
    protected void renderStringContainsExactlyPredicate(Expression haystack, Expression needle) {
        haystack.accept(this);
        this.appendSql(" like concat('%',replace(replace(replace(");
        needle.accept(this);
        this.appendSql(",'~','~~'),'?','~?'),'%','~%'),'%') escape '~'");
    }
}

