/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

@MBean(description="Clears a given set of flags from up or down messages")
public class CLEAR_FLAGS
extends Protocol {
    protected final Set<Message.Flag> down_flags = new ConcurrentSkipListSet<Message.Flag>();
    protected final Set<Message.Flag> up_flags = new ConcurrentSkipListSet<Message.Flag>();

    @ManagedAttribute(description="Shows up and down flags")
    public String flags() {
        return String.format("down flags: %s\nup_flags: %s", this.downFlags(), this.upFlags());
    }

    @ManagedOperation(description="Adds a flag to the up or down set")
    public CLEAR_FLAGS addFlag(boolean down2, String flag) {
        Message.Flag fl = Message.Flag.valueOf(flag);
        return fl != null ? this.addFlag(down2, fl) : this;
    }

    public CLEAR_FLAGS addFlag(boolean down2, Message.Flag flag) {
        Set<Message.Flag> s = down2 ? this.down_flags : this.up_flags;
        s.add(flag);
        return this;
    }

    @ManagedOperation(description="Removes a flag from the up or down set")
    public CLEAR_FLAGS removeFlag(boolean down2, String flag) {
        Message.Flag fl = Message.Flag.valueOf(flag);
        return fl != null ? this.removeFlag(down2, fl) : this;
    }

    public CLEAR_FLAGS removeFlag(boolean down2, Message.Flag flag) {
        Set<Message.Flag> s = down2 ? this.down_flags : this.up_flags;
        s.remove((Object)flag);
        return this;
    }

    @ManagedOperation(description="Removes all up or down flags")
    public CLEAR_FLAGS removeAllFlags() {
        this.down_flags.clear();
        this.up_flags.clear();
        return this;
    }

    @Override
    public Object down(Message msg) {
        if (!this.down_flags.isEmpty()) {
            for (Message.Flag flag : this.down_flags) {
                msg.clearFlag(flag);
            }
        }
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Message msg) {
        if (!this.up_flags.isEmpty()) {
            for (Message.Flag fl : this.up_flags) {
                msg.clearFlag(fl);
            }
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        if (!this.up_flags.isEmpty()) {
            for (Message.Flag fl : this.up_flags) {
                for (Message msg : batch) {
                    msg.clearFlag(fl);
                }
            }
        }
        this.up_prot.up(batch);
    }

    public String downFlags() {
        return this.down_flags.stream().map(Enum::toString).collect(Collectors.joining(", "));
    }

    public String upFlags() {
        return this.up_flags.stream().map(Enum::toString).collect(Collectors.joining(", "));
    }
}

