/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.persistence.sifs.NonBlockingSoftIndexFileStore;
import org.infinispan.persistence.sifs.configuration.DataConfiguration;
import org.infinispan.persistence.sifs.configuration.IndexConfiguration;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;

@BuiltBy(value=SoftIndexFileStoreConfigurationBuilder.class)
@ConfigurationFor(value=NonBlockingSoftIndexFileStore.class)
public class SoftIndexFileStoreConfiguration
extends AbstractStoreConfiguration {
    public static final AttributeDefinition<Integer> OPEN_FILES_LIMIT = AttributeDefinition.builder((Enum)Attribute.OPEN_FILES_LIMIT, (Object)1000).immutable().build();
    public static final AttributeDefinition<Double> COMPACTION_THRESHOLD = AttributeDefinition.builder((Enum)Attribute.COMPACTION_THRESHOLD, (Object)0.5).immutable().build();
    private final IndexConfiguration index;
    private final DataConfiguration data;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SoftIndexFileStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{OPEN_FILES_LIMIT, COMPACTION_THRESHOLD});
    }

    public SoftIndexFileStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, IndexConfiguration indexConfiguration, DataConfiguration dataConfiguration) {
        super(attributes, async);
        this.index = indexConfiguration;
        this.data = dataConfiguration;
    }

    public String dataLocation() {
        return this.data.dataLocation();
    }

    public String indexLocation() {
        return this.index.indexLocation();
    }

    @Deprecated(since="15.0", forRemoval=true)
    public int indexSegments() {
        return this.index.indexSegments();
    }

    public int maxFileSize() {
        return this.data.maxFileSize();
    }

    public int minNodeSize() {
        return this.index.minNodeSize();
    }

    public int maxNodeSize() {
        return this.index.maxNodeSize();
    }

    public int indexQueueLength() {
        return this.index.indexQueueLength();
    }

    public boolean syncWrites() {
        return this.data.syncWrites();
    }

    public int openFilesLimit() {
        return (Integer)this.attributes.attribute(OPEN_FILES_LIMIT).get();
    }

    public double compactionThreshold() {
        return (Double)this.attributes.attribute(COMPACTION_THRESHOLD).get();
    }

    public IndexConfiguration index() {
        return this.index;
    }

    public DataConfiguration data() {
        return this.data;
    }

    @Override
    public String toString() {
        return "SoftIndexFileStore [attributes=" + String.valueOf(this.attributes) + "]";
    }
}

