/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.criteria.JoinType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.ComponentDescription;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.entities.RelationType;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.AuditAssociationQuery;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.impl.AuditQueryImplementor;
import org.hibernate.envers.query.order.AuditOrder;
import org.hibernate.envers.query.projection.AuditProjection;

@Incubating
public abstract class AbstractAuditAssociationQuery<Q extends AuditQueryImplementor>
implements AuditAssociationQuery<Q>,
AuditQueryImplementor {
    protected final EnversService enversService;
    protected final AuditReaderImplementor auditReader;
    protected final Q parent;
    protected final QueryBuilder queryBuilder;
    protected final JoinType joinType;
    protected final String entityName;
    protected final RelationDescription relationDescription;
    protected final ComponentDescription componentDescription;
    protected final String ownerAlias;
    protected final String ownerEntityName;
    protected final String alias;
    protected final Map<String, String> aliasToEntityNameMap;
    protected final Map<String, String> aliasToComponentPropertyNameMap;
    protected final List<AuditCriterion> criterions = new ArrayList<AuditCriterion>();
    protected final AuditCriterion onClauseCriterion;
    protected final Parameters parameters;
    protected final List<AbstractAuditAssociationQuery<Q>> associationQueries = new ArrayList<AbstractAuditAssociationQuery<Q>>();
    protected final Map<String, AbstractAuditAssociationQuery<AbstractAuditAssociationQuery<Q>>> associationQueryMap = new HashMap<String, AbstractAuditAssociationQuery<AbstractAuditAssociationQuery<Q>>>();

    public AbstractAuditAssociationQuery(EnversService enversService, AuditReaderImplementor auditReader, Q parent, QueryBuilder queryBuilder, String propertyName, JoinType joinType, Map<String, String> aliasToEntityNameMap, Map<String, String> aliasToComponentPropertyNameMap, String ownerAlias, String userSuppliedAlias, AuditCriterion onClauseCriterion) {
        this.enversService = enversService;
        this.auditReader = auditReader;
        this.parent = parent;
        this.queryBuilder = queryBuilder;
        this.joinType = joinType;
        this.ownerEntityName = aliasToEntityNameMap.get(ownerAlias);
        this.ownerAlias = ownerAlias;
        this.alias = userSuppliedAlias == null ? queryBuilder.generateAlias() : userSuppliedAlias;
        String componentPrefix = CriteriaTools.determineComponentPropertyPrefix(enversService, aliasToEntityNameMap, aliasToComponentPropertyNameMap, ownerAlias);
        String prefixedPropertyName = componentPrefix.concat(propertyName);
        this.relationDescription = CriteriaTools.getRelatedEntity(enversService, this.ownerEntityName, prefixedPropertyName);
        this.componentDescription = CriteriaTools.getComponent(enversService, this.ownerEntityName, prefixedPropertyName);
        if (this.relationDescription == null && this.componentDescription == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Property %s of entity %s is not a valid association for queries", propertyName, this.ownerEntityName));
        }
        if (this.relationDescription != null) {
            this.entityName = this.relationDescription.getToEntityName();
        } else {
            aliasToComponentPropertyNameMap.put(this.alias, this.componentDescription.getPropertyName());
            this.entityName = this.ownerEntityName;
        }
        aliasToEntityNameMap.put(this.alias, this.entityName);
        this.aliasToEntityNameMap = aliasToEntityNameMap;
        this.aliasToComponentPropertyNameMap = aliasToComponentPropertyNameMap;
        this.parameters = queryBuilder.addParameters(this.alias);
        this.onClauseCriterion = onClauseCriterion;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public List getResultList() throws AuditException {
        return this.parent.getResultList();
    }

    @Override
    public Object getSingleResult() throws AuditException, NonUniqueResultException, NoResultException {
        return this.parent.getSingleResult();
    }

    @Override
    public AbstractAuditAssociationQuery<AbstractAuditAssociationQuery<Q>> traverseRelation(String associationName, JoinType joinType) {
        return this.traverseRelation(associationName, joinType, null);
    }

    @Override
    public AbstractAuditAssociationQuery<AbstractAuditAssociationQuery<Q>> traverseRelation(String associationName, JoinType joinType, String alias) {
        return this.traverseRelation(associationName, joinType, alias, null);
    }

    public AbstractAuditAssociationQuery<AbstractAuditAssociationQuery<Q>> traverseRelation(String associationName, JoinType joinType, String alias, AuditCriterion onClause) {
        AbstractAuditAssociationQuery<AbstractAuditAssociationQuery<Q>> query = this.associationQueryMap.get(associationName);
        if (query == null) {
            query = this.createAssociationQuery(associationName, joinType, alias, onClause);
            this.associationQueries.add(query);
            this.associationQueryMap.put(associationName, query);
        }
        return query;
    }

    protected abstract AbstractAuditAssociationQuery<AbstractAuditAssociationQuery<Q>> createAssociationQuery(String var1, JoinType var2, String var3, AuditCriterion var4);

    @Override
    public AbstractAuditAssociationQuery<Q> add(AuditCriterion criterion) {
        this.criterions.add(criterion);
        return this;
    }

    @Override
    public AbstractAuditAssociationQuery<Q> addProjection(AuditProjection projection) {
        String projectionEntityAlias = projection.getAlias(this.alias);
        String projectionEntityName = this.aliasToEntityNameMap.get(projectionEntityAlias);
        this.registerProjection(projectionEntityName, projection);
        projection.addProjectionToQuery(this.enversService, this.auditReader, this.aliasToEntityNameMap, this.aliasToComponentPropertyNameMap, this.alias, this.queryBuilder);
        return this;
    }

    @Override
    public AbstractAuditAssociationQuery<Q> addOrder(AuditOrder order) {
        AuditOrder.OrderData orderData = order.getData(this.enversService.getConfig());
        String orderEntityAlias = orderData.getAlias(this.alias);
        String orderEntityName = this.aliasToEntityNameMap.get(orderEntityAlias);
        String propertyName = CriteriaTools.determinePropertyName(this.enversService, this.auditReader, orderEntityName, orderData.getPropertyName());
        String componentPrefix = CriteriaTools.determineComponentPropertyPrefix(this.enversService, this.aliasToEntityNameMap, this.aliasToComponentPropertyNameMap, orderEntityAlias);
        this.queryBuilder.addOrder(orderEntityAlias, componentPrefix.concat(propertyName), orderData.isAscending(), orderData.getNullPrecedence());
        return this;
    }

    @Override
    public AbstractAuditAssociationQuery<Q> setMaxResults(int maxResults) {
        this.parent.setMaxResults(maxResults);
        return this;
    }

    @Override
    public AbstractAuditAssociationQuery<Q> setFirstResult(int firstResult) {
        this.parent.setFirstResult(firstResult);
        return this;
    }

    @Override
    public AbstractAuditAssociationQuery<Q> setCacheable(boolean cacheable) {
        this.parent.setCacheable(cacheable);
        return this;
    }

    @Override
    public AbstractAuditAssociationQuery<Q> setCacheRegion(String cacheRegion) {
        this.parent.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public AbstractAuditAssociationQuery<Q> setComment(String comment) {
        this.parent.setComment(comment);
        return this;
    }

    @Override
    public AbstractAuditAssociationQuery<Q> setFlushMode(FlushMode flushMode) {
        this.parent.setFlushMode(flushMode);
        return this;
    }

    @Override
    public AbstractAuditAssociationQuery<Q> setCacheMode(CacheMode cacheMode) {
        this.parent.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public AbstractAuditAssociationQuery<Q> setTimeout(int timeout) {
        this.parent.setTimeout(timeout);
        return this;
    }

    @Override
    public AbstractAuditAssociationQuery<Q> setLockMode(LockMode lockMode) {
        this.parent.setLockMode(lockMode);
        return this;
    }

    @Override
    public Q up() {
        return this.parent;
    }

    protected void addCriterionToQuery(AuditReaderImplementor versionsReader) {
        Parameters onClauseParameters = this.relationDescription != null ? this.createEntityJoin(this.enversService.getConfig()) : this.createComponentJoin(this.enversService.getConfig());
        if (this.onClauseCriterion != null) {
            this.onClauseCriterion.addToQuery(this.enversService, versionsReader, this.aliasToEntityNameMap, this.aliasToComponentPropertyNameMap, this.alias, this.queryBuilder, onClauseParameters);
        }
        for (AuditCriterion auditCriterion : this.criterions) {
            auditCriterion.addToQuery(this.enversService, versionsReader, this.aliasToEntityNameMap, this.aliasToComponentPropertyNameMap, this.alias, this.queryBuilder, this.parameters);
        }
        for (AbstractAuditAssociationQuery abstractAuditAssociationQuery : this.associationQueries) {
            abstractAuditAssociationQuery.addCriterionToQuery(versionsReader);
        }
    }

    protected Parameters createEntityJoin(Configuration configuration) {
        Parameters onClauseParameters;
        boolean targetIsAudited = this.enversService.getEntitiesConfigurations().isVersioned(this.entityName);
        String targetEntityName = this.entityName;
        if (targetIsAudited) {
            targetEntityName = configuration.getAuditEntityName(this.entityName);
        }
        String originalIdPropertyName = configuration.getOriginalIdPropertyName();
        String revisionPropertyPath = configuration.getRevisionNumberPath();
        if (this.relationDescription.getRelationType() == RelationType.TO_ONE) {
            String prefix;
            IdMapper idMapperTarget;
            Parameters joinConditionParameters;
            onClauseParameters = joinConditionParameters = this.queryBuilder.addJoin(this.joinType, targetEntityName, this.alias, false);
            if (targetIsAudited) {
                idMapperTarget = this.enversService.getEntitiesConfigurations().get(this.entityName).getIdMapper();
                prefix = this.alias.concat(".").concat(originalIdPropertyName);
            } else {
                idMapperTarget = this.enversService.getEntitiesConfigurations().getNotVersionEntityConfiguration(this.entityName).getIdMapper();
                prefix = this.alias;
            }
            this.relationDescription.getIdMapper().addIdsEqualToQuery(joinConditionParameters, this.ownerAlias, idMapperTarget, prefix);
        } else if (this.relationDescription.getRelationType() == RelationType.TO_MANY_NOT_OWNING) {
            Parameters joinConditionParameters;
            if (!targetIsAudited) {
                throw new AuditException(String.format(Locale.ENGLISH, "Cannot build queries for relation type %s to non audited target entities", new Object[]{this.relationDescription.getRelationType()}));
            }
            onClauseParameters = joinConditionParameters = this.queryBuilder.addJoin(this.joinType, targetEntityName, this.alias, false);
            IdMapper idMapperOwner = this.enversService.getEntitiesConfigurations().get(this.ownerEntityName).getIdMapper();
            String prefix = this.ownerAlias.concat(".").concat(originalIdPropertyName);
            this.relationDescription.getIdMapper().addIdsEqualToQuery(joinConditionParameters, this.alias, idMapperOwner, prefix);
        } else if (this.relationDescription.getRelationType() == RelationType.TO_MANY_MIDDLE || this.relationDescription.getRelationType() == RelationType.TO_MANY_MIDDLE_NOT_OWNING) {
            Parameters joinConditionParametersTarget;
            if (!targetIsAudited && this.relationDescription.getRelationType() == RelationType.TO_MANY_MIDDLE_NOT_OWNING) {
                throw new AuditException(String.format(Locale.ENGLISH, "Cannot build queries for relation type %s to non audited target entities", new Object[]{this.relationDescription.getRelationType()}));
            }
            String middleEntityAlias = this.queryBuilder.generateAlias();
            Parameters joinConditionParametersMiddle = this.queryBuilder.addJoin(this.joinType, this.relationDescription.getAuditMiddleEntityName(), middleEntityAlias, false);
            onClauseParameters = joinConditionParametersTarget = this.queryBuilder.addJoin(this.joinType, targetEntityName, this.alias, false);
            Parameters middleParameters = this.queryBuilder.addParameters(middleEntityAlias);
            String middleOriginalIdPropertyPath = middleEntityAlias + "." + originalIdPropertyName;
            String ownerPrefix = this.ownerAlias + "." + originalIdPropertyName;
            MiddleIdData referencingIdData = this.relationDescription.getReferencingIdData();
            referencingIdData.getPrefixedMapper().addIdsEqualToQuery(joinConditionParametersMiddle, middleOriginalIdPropertyPath, referencingIdData.getOriginalMapper(), ownerPrefix);
            Object targetPrefix = this.alias;
            if (targetIsAudited) {
                targetPrefix = this.alias + "." + originalIdPropertyName;
            }
            MiddleIdData referencedIdData = this.relationDescription.getReferencedIdData();
            referencedIdData.getPrefixedMapper().addIdsEqualToQuery(joinConditionParametersTarget, middleOriginalIdPropertyPath, referencedIdData.getOriginalMapper(), (String)targetPrefix);
            Parameters middleParametersToUse = middleParameters;
            if (this.joinType == JoinType.LEFT) {
                middleParametersToUse = middleParameters.addSubParameters("or");
                middleParametersToUse.addNullRestriction(revisionPropertyPath, true);
                middleParametersToUse = middleParametersToUse.addSubParameters("and");
            }
            this.enversService.getAuditStrategy().addAssociationAtRevisionRestriction(this.queryBuilder, middleParametersToUse, revisionPropertyPath, configuration.getRevisionEndFieldName(), true, referencingIdData, this.relationDescription.getAuditMiddleEntityName(), middleOriginalIdPropertyPath, revisionPropertyPath, originalIdPropertyName, middleEntityAlias, true, new MiddleComponentData[0]);
            if (this.joinType == JoinType.LEFT) {
                middleParametersToUse = middleParameters.addSubParameters("or");
                middleParametersToUse.addNullRestriction(configuration.getRevisionTypePropertyName(), true);
            }
            middleParametersToUse.addWhereWithParam(configuration.getRevisionTypePropertyName(), true, "!=", (Object)RevisionType.DEL);
        } else {
            throw new AuditException(String.format(Locale.ENGLISH, "Cannot build queries for relation type %s", new Object[]{this.relationDescription.getRelationType()}));
        }
        return onClauseParameters;
    }

    protected Parameters createComponentJoin(Configuration configuration) {
        Parameters onClauseParameters;
        String originalIdPropertyName = configuration.getOriginalIdPropertyName();
        String revisionPropertyPath = configuration.getRevisionNumberPath();
        if (this.componentDescription.getType() == ComponentDescription.ComponentType.MANY) {
            Parameters middleParameters;
            Parameters joinConditionParameters;
            onClauseParameters = joinConditionParameters = this.queryBuilder.addJoin(this.joinType, this.componentDescription.getAuditMiddleEntityName(), this.alias, false);
            String middleOriginalIdPropertyPath = this.alias + "." + originalIdPropertyName;
            String ownerPrefix = this.ownerAlias + "." + originalIdPropertyName;
            MiddleIdData middleIdData = this.componentDescription.getMiddleIdData();
            middleIdData.getPrefixedMapper().addIdsEqualToQuery(joinConditionParameters, middleOriginalIdPropertyPath, middleIdData.getOriginalMapper(), ownerPrefix);
            Parameters middleParametersToUse = middleParameters = this.queryBuilder.addParameters(this.alias);
            if (this.joinType == JoinType.LEFT) {
                middleParametersToUse = middleParameters.addSubParameters("or");
                middleParametersToUse.addNullRestriction(revisionPropertyPath, true);
                middleParametersToUse = middleParametersToUse.addSubParameters("and");
            }
            configuration.getAuditStrategy().addAssociationAtRevisionRestriction(this.queryBuilder, middleParametersToUse, revisionPropertyPath, configuration.getRevisionEndFieldName(), true, middleIdData, this.componentDescription.getAuditMiddleEntityName(), middleOriginalIdPropertyPath, revisionPropertyPath, originalIdPropertyName, this.alias, true, new MiddleComponentData[0]);
            String middleRevTypePropertyPath = middleOriginalIdPropertyPath + "." + configuration.getRevisionTypePropertyName();
            if (this.joinType == JoinType.LEFT) {
                middleParametersToUse = middleParameters.addSubParameters("or");
                middleParametersToUse.addNullRestriction(middleRevTypePropertyPath, false);
            }
            middleParametersToUse.addWhereWithParam(middleRevTypePropertyPath, false, "!=", (Object)RevisionType.DEL);
        } else {
            Parameters joinConditionParameters;
            String targetEntityName = configuration.getAuditEntityName(this.entityName);
            onClauseParameters = joinConditionParameters = this.queryBuilder.addJoin(this.joinType, targetEntityName, this.alias, false);
            String ownerPrefix = this.ownerAlias + "." + originalIdPropertyName;
            String middleOriginalIdPropertyPath = this.alias + "." + originalIdPropertyName;
            IdMapper idMapper = this.enversService.getEntitiesConfigurations().get(this.entityName).getIdMapper();
            idMapper.addIdsEqualToQuery(joinConditionParameters, ownerPrefix, middleOriginalIdPropertyPath);
            joinConditionParameters.addWhere(this.ownerAlias, revisionPropertyPath, "=", this.alias, revisionPropertyPath);
        }
        return onClauseParameters;
    }

    @Override
    public void registerProjection(String entityName, AuditProjection projection) {
        this.parent.registerProjection(entityName, projection);
    }
}

