/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.defaultanswers;

import java.io.Serializable;
import org.mockito.Mockito;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.debugging.LocationFactory;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.stubbing.defaultanswers.RetrieveGenericsForDefaultAnswers;
import org.mockito.internal.stubbing.defaultanswers.ReturnsMoreEmptyValues;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.invocation.Location;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;

public class ReturnsSmartNulls
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = 7618312406617949441L;
    private final Answer<Object> delegate = new ReturnsMoreEmptyValues();

    @Override
    public Object answer(final InvocationOnMock invocation) throws Throwable {
        Object defaultReturnValue = this.delegate.answer(invocation);
        if (defaultReturnValue != null) {
            return defaultReturnValue;
        }
        return RetrieveGenericsForDefaultAnswers.returnTypeForMockWithCorrectGenerics(invocation, new RetrieveGenericsForDefaultAnswers.AnswerCallback(){

            @Override
            public Object apply(Class<?> type) {
                if (type == null) {
                    return null;
                }
                MockCreationSettings mockSettings = MockUtil.getMockSettings(invocation.getMock());
                ThrowsSmartNullPointer defaultAnswer = new ThrowsSmartNullPointer(invocation, LocationFactory.create());
                return Mockito.mock(type, new MockSettingsImpl().defaultAnswer(defaultAnswer).mockMaker(mockSettings.getMockMaker()));
            }
        });
    }

    private static class ThrowsSmartNullPointer
    implements Answer {
        private final InvocationOnMock unstubbedInvocation;
        private final Location location;

        ThrowsSmartNullPointer(InvocationOnMock unstubbedInvocation, Location location) {
            this.unstubbedInvocation = unstubbedInvocation;
            this.location = location;
        }

        public Object answer(InvocationOnMock currentInvocation) throws Throwable {
            if (ObjectMethodsGuru.isToStringMethod(currentInvocation.getMethod())) {
                return "SmartNull returned by this unstubbed method call on a mock:\n" + this.unstubbedInvocation;
            }
            throw Reporter.smartNullPointerException(this.unstubbedInvocation.toString(), this.location);
        }
    }
}

