/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.Arrays;
import java.util.Objects;

public interface SearchPathLocator {
    public Locations getLocations(String var1, String var2, String var3);

    public static class Locations {
        private final String application;
        private final String profile;
        private final String label;
        private final String[] locations;
        private final String version;

        public Locations(String application, String profile, String label, String version, String[] locations) {
            this.application = application;
            this.profile = profile;
            this.label = label;
            this.locations = locations;
            this.version = version;
        }

        public String[] getLocations() {
            return this.locations;
        }

        public String getVersion() {
            return this.version;
        }

        public String getApplication() {
            return this.application;
        }

        public String getProfile() {
            return this.profile;
        }

        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return "Locations [application=" + this.application + ", profile=" + this.profile + ", label=" + this.label + ", locations=" + Arrays.toString(this.locations) + ", version=" + this.version + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Locations locations1 = (Locations)o;
            return this.getApplication().equals(locations1.getApplication()) && this.getProfile().equals(locations1.getProfile()) && Objects.equals(this.getLabel(), locations1.getLabel()) && Arrays.equals(this.getLocations(), locations1.getLocations()) && Objects.equals(this.getVersion(), locations1.getVersion());
        }

        public int hashCode() {
            int result = Objects.hash(this.getApplication(), this.getProfile(), this.getLabel(), this.getVersion());
            result = 31 * result + Arrays.hashCode(this.getLocations());
            return result;
        }
    }
}

