/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.concurrent;

import java.security.AccessController;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class ContextualThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_COUNTER = new AtomicInteger(0);
    private final AtomicInteger threadCounter = new AtomicInteger(0);
    private final String prefix;

    ContextualThreadFactory(String prefix) {
        this.prefix = String.format("%s-%d-thread", prefix, POOL_COUNTER.incrementAndGet());
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r, String.format("%s-%d", this.prefix, this.threadCounter.incrementAndGet()));
        if (System.getSecurityManager() == null) {
            thread.setDaemon(true);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
        return AccessController.doPrivileged(() -> {
            thread.setDaemon(true);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        });
    }
}

