/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;

public class QueueConfigurationUtils {
    public static void applyDynamicQueueDefaults(QueueConfiguration config, AddressSettings as) {
        config.setMaxConsumers(config.getMaxConsumers() == null ? as.getDefaultMaxConsumers() : config.getMaxConsumers());
        config.setExclusive(config.isExclusive() == null ? as.isDefaultExclusiveQueue() : config.isExclusive());
        config.setGroupRebalance(Boolean.valueOf(config.isGroupRebalance() == null ? as.isDefaultGroupRebalance() : config.isGroupRebalance().booleanValue()));
        config.setGroupRebalancePauseDispatch(Boolean.valueOf(config.isGroupRebalancePauseDispatch() == null ? as.isDefaultGroupRebalancePauseDispatch() : config.isGroupRebalancePauseDispatch().booleanValue()));
        config.setGroupBuckets(Integer.valueOf(config.getGroupBuckets() == null ? as.getDefaultGroupBuckets() : config.getGroupBuckets().intValue()));
        config.setGroupFirstKey(config.getGroupFirstKey() == null ? as.getDefaultGroupFirstKey() : config.getGroupFirstKey());
        config.setLastValue(Boolean.valueOf(config.isLastValue() == null ? as.isDefaultLastValueQueue() : config.isLastValue().booleanValue()));
        config.setLastValueKey(config.getLastValueKey() == null ? as.getDefaultLastValueKey() : config.getLastValueKey());
        config.setNonDestructive(Boolean.valueOf(config.isNonDestructive() == null ? as.isDefaultNonDestructive() : config.isNonDestructive().booleanValue()));
        config.setConsumersBeforeDispatch(config.getConsumersBeforeDispatch() == null ? as.getDefaultConsumersBeforeDispatch() : config.getConsumersBeforeDispatch());
        config.setDelayBeforeDispatch(config.getDelayBeforeDispatch() == null ? as.getDefaultDelayBeforeDispatch() : config.getDelayBeforeDispatch());
        config.setRingSize(Long.valueOf(config.getRingSize() == null ? as.getDefaultRingSize() : config.getRingSize().longValue()));
        config.setRoutingType(config.getRoutingType() == null ? as.getDefaultQueueRoutingType() : config.getRoutingType());
        config.setPurgeOnNoConsumers(config.isPurgeOnNoConsumers() == null ? as.isDefaultPurgeOnNoConsumers() : config.isPurgeOnNoConsumers());
        config.setAutoCreateAddress(config.isAutoCreateAddress() == null ? as.isAutoCreateAddresses() : config.isAutoCreateAddress());
        config.setAutoDelete(Boolean.valueOf(config.isAutoDelete() == null ? !config.isConfigurationManaged().booleanValue() && (config.isAutoCreated().booleanValue() && as.isAutoDeleteQueues().booleanValue() || !config.isAutoCreated().booleanValue() && as.isAutoDeleteCreatedQueues().booleanValue()) : config.isAutoDelete()));
        config.setAutoDeleteDelay(Long.valueOf(config.getAutoDeleteDelay() == null ? as.getAutoDeleteQueuesDelay() : config.getAutoDeleteDelay().longValue()));
        config.setAutoDeleteMessageCount(Long.valueOf(config.getAutoDeleteMessageCount() == null ? as.getAutoDeleteQueuesMessageCount() : config.getAutoDeleteMessageCount().longValue()));
        config.setEnabled(Boolean.valueOf(config.isEnabled() == null ? ActiveMQDefaultConfiguration.getDefaultEnabled() : config.isEnabled()));
    }
}

