/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.util.ArrayList;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public abstract class AbstractServerWebExchangeMatcherRegistry<T> {
    AbstractServerWebExchangeMatcherRegistry() {
    }

    public T anyExchange() {
        return this.matcher(ServerWebExchangeMatchers.anyExchange());
    }

    public T pathMatchers(HttpMethod method) {
        return this.pathMatchers(method, "/**");
    }

    public T pathMatchers(HttpMethod method, String ... antPatterns) {
        List<PathPattern> pathPatterns = this.parsePatterns(antPatterns);
        return this.matcher(ServerWebExchangeMatchers.pathMatchers((HttpMethod)method, (PathPattern[])pathPatterns.toArray(new PathPattern[0])));
    }

    public T pathMatchers(String ... antPatterns) {
        List<PathPattern> pathPatterns = this.parsePatterns(antPatterns);
        return this.matcher(ServerWebExchangeMatchers.pathMatchers((PathPattern[])pathPatterns.toArray(new PathPattern[0])));
    }

    private List<PathPattern> parsePatterns(String[] antPatterns) {
        PathPatternParser parser = this.getPathPatternParser();
        ArrayList<PathPattern> pathPatterns = new ArrayList<PathPattern>(antPatterns.length);
        for (String pattern : antPatterns) {
            pattern = parser.initFullPathPattern(pattern);
            PathPattern pathPattern = parser.parse(pattern);
            pathPatterns.add(pathPattern);
        }
        return pathPatterns;
    }

    public T matchers(ServerWebExchangeMatcher ... matchers) {
        return this.registerMatcher((ServerWebExchangeMatcher)new OrServerWebExchangeMatcher(matchers));
    }

    protected abstract T registerMatcher(ServerWebExchangeMatcher var1);

    protected PathPatternParser getPathPatternParser() {
        return PathPatternParser.defaultInstance;
    }

    private T matcher(ServerWebExchangeMatcher matcher) {
        return this.registerMatcher(matcher);
    }
}

