/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.DefaultSplitStrategy;
import com.github.drapostolos.typeparser.InputPreprocessor;
import com.github.drapostolos.typeparser.KeyValueSplitStrategy;
import com.github.drapostolos.typeparser.NullInputPreprocessor;
import com.github.drapostolos.typeparser.SplitStrategy;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

final class TypeParserUtility {
    static final String STATIC_FACTORY_METHOD_NAME = "valueOf";
    private static final SplitStrategy DEFAULT_SPLIT_STRATEGY = new DefaultSplitStrategy();
    private static final SplitStrategy DEFAULT_KEY_VALUE_SPLIT_STRATEGY = new KeyValueSplitStrategy();
    private static final InputPreprocessor DEFAULT_INPUT_PREPROCESSOR = new NullInputPreprocessor();

    private TypeParserUtility() {
        throw new AssertionError((Object)"Not meant for instantiation");
    }

    static InputPreprocessor defaultInputPreprocessor() {
        return DEFAULT_INPUT_PREPROCESSOR;
    }

    static SplitStrategy defaultSplitStrategy() {
        return DEFAULT_SPLIT_STRATEGY;
    }

    static SplitStrategy defaultKeyValueSplitStrategy() {
        return DEFAULT_KEY_VALUE_SPLIT_STRATEGY;
    }

    static String makeNullArgumentErrorMsg(String argName) {
        return String.format("Argument named '%s' is illegally set to null!", argName);
    }

    static String makeParseErrorMsg(String input, Type targetType, String message) {
        return String.format("Can not parse \"%s\" to type \"%s\" [instance of: %s] due to: %s", input, targetType, targetType.getClass().getName(), message);
    }

    static boolean containsStaticFactoryMethodNamedValueOf(Class<?> type) {
        Method method = TypeParserUtility.getMethodNamedValueOf(type);
        if (method == null) {
            return false;
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        return method.getReturnType().equals(type);
    }

    static Method getMethodNamedValueOf(Class<?> targetType) {
        try {
            return targetType.getDeclaredMethod(STATIC_FACTORY_METHOD_NAME, String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    static <T> List<Class<T>> getParameterizedTypeArguments(Type targetType) {
        if (!(targetType instanceof ParameterizedType)) {
            String message = "TargetType: '%s' [%s] must be a parameterized type.";
            throw new IllegalStateException(String.format(message, targetType, targetType.getClass()));
        }
        ParameterizedType pt = (ParameterizedType)targetType;
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (Type typeArgument : pt.getActualTypeArguments()) {
            Type rawType;
            if (typeArgument instanceof Class) {
                Class cls = (Class)typeArgument;
                result.add(cls);
                continue;
            }
            if (typeArgument instanceof ParameterizedType && (rawType = ((ParameterizedType)typeArgument).getRawType()) instanceof Class) {
                Class cls = (Class)rawType;
                result.add(cls);
                continue;
            }
            String message = "TargetType: '%s' [%s] contains the following illegal type argument: '%s' [%s]";
            message = String.format(message, targetType, targetType.getClass(), typeArgument, typeArgument.getClass());
            throw new IllegalStateException(message);
        }
        return result;
    }

    static Class<?> getComponentClass(Type targetType) {
        Type t;
        if (targetType instanceof Class && (t = (Class)targetType).isArray()) {
            return t.getComponentType();
        }
        if (targetType instanceof GenericArrayType && (t = ((GenericArrayType)targetType).getGenericComponentType()) instanceof Class) {
            return t;
        }
        String message = "TargetType: '%s' [%s] is either not an array or the componet type is generic.";
        message = String.format(message, targetType, targetType.getClass());
        throw new IllegalStateException(message);
    }
}

