/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.formattedsql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Labels;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.EmptyChange;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.parser.ChangeLogParser;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.precondition.core.SqlPrecondition;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class FormattedSqlChangeLogParser
implements ChangeLogParser {
    private static final String FIRST_LINE_REGEX = "\\-\\-\\s*liquibase formatted.*";
    private static final Pattern FIRST_LINE_PATTERN = Pattern.compile("\\-\\-\\s*liquibase formatted.*", 2);
    private static final String PROPERTY_REGEX = "\\s*\\-\\-[\\s]*property\\s+(.*:.*)\\s+(.*:.*).*";
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\s*\\-\\-[\\s]*property\\s+(.*:.*)\\s+(.*:.*).*", 2);
    private static final String ALT_PROPERTY_ONE_DASH_REGEX = "\\s*?[-]+\\s*property\\s.*";
    private static final Pattern ALT_PROPERTY_ONE_DASH_PATTERN = Pattern.compile("\\s*?[-]+\\s*property\\s.*", 2);
    private static final String CHANGE_SET_REGEX = "\\s*\\-\\-[\\s]*changeset\\s+(\"[^\"]+\"|[^:]+):\\s*(\"[^\"]+\"|\\S+).*";
    private static final Pattern CHANGE_SET_PATTERN = Pattern.compile("\\s*\\-\\-[\\s]*changeset\\s+(\"[^\"]+\"|[^:]+):\\s*(\"[^\"]+\"|\\S+).*", 2);
    private static final String ALT_CHANGE_SET_ONE_DASH_REGEX = "\\-[\\s]*changeset\\s.*";
    private static final Pattern ALT_CHANGE_SET_ONE_DASH_PATTERN = Pattern.compile("\\-[\\s]*changeset\\s.*", 2);
    private static final String ALT_CHANGE_SET_NO_OTHER_INFO_REGEX = "\\s*\\-\\-[\\s]*changeset[\\s]*.*$";
    private static final Pattern ALT_CHANGE_SET_NO_OTHER_INFO_PATTERN = Pattern.compile("\\s*\\-\\-[\\s]*changeset[\\s]*.*$", 2);
    private static final String ROLLBACK_REGEX = "\\s*\\-\\-[\\s]*rollback (.*)";
    private static final Pattern ROLLBACK_PATTERN = Pattern.compile("\\s*\\-\\-[\\s]*rollback (.*)", 2);
    private static final String ALT_ROLLBACK_ONE_DASH_REGEX = "\\s*\\-[\\s]*rollback\\s.*";
    private static final Pattern ALT_ROLLBACK_ONE_DASH_PATTERN = Pattern.compile("\\s*\\-[\\s]*rollback\\s.*", 2);
    private static final String PRECONDITIONS_REGEX = "\\s*\\-\\-[\\s]*preconditions(.*)";
    private static final Pattern PRECONDITIONS_PATTERN = Pattern.compile("\\s*\\-\\-[\\s]*preconditions(.*)", 2);
    private static final String ALT_PRECONDITIONS_ONE_DASH_REGEX = "\\s*\\-[\\s]*preconditions\\s.*";
    private static final Pattern ALT_PRECONDITIONS_ONE_DASH_PATTERN = Pattern.compile("\\s*\\-[\\s]*preconditions\\s.*", 2);
    private static final String PRECONDITION_REGEX = "\\s*\\-\\-[\\s]*precondition\\-([a-zA-Z0-9-]+) (.*)";
    private static final Pattern PRECONDITION_PATTERN = Pattern.compile("\\s*\\-\\-[\\s]*precondition\\-([a-zA-Z0-9-]+) (.*)", 2);
    private static final String ALT_PRECONDITION_ONE_DASH_REGEX = "\\s*\\-[\\s]*precondition(.*)";
    private static final Pattern ALT_PRECONDITION_ONE_DASH_PATTERN = Pattern.compile("\\s*\\-[\\s]*precondition(.*)", 2);
    private static final String STRIP_COMMENTS_REGEX = ".*stripComments:(\\w+).*";
    private static final Pattern STRIP_COMMENTS_PATTERN = Pattern.compile(".*stripComments:(\\w+).*", 2);
    private static final String SPLIT_STATEMENTS_REGEX = ".*splitStatements:(\\w+).*";
    private static final Pattern SPLIT_STATEMENTS_PATTERN = Pattern.compile(".*splitStatements:(\\w+).*", 2);
    private static final String ROLLBACK_SPLIT_STATEMENTS_REGEX = ".*rollbackSplitStatements:(\\w+).*";
    private static final Pattern ROLLBACK_SPLIT_STATEMENTS_PATTERN = Pattern.compile(".*rollbackSplitStatements:(\\w+).*", 2);
    private static final String END_DELIMITER_REGEX = ".*endDelimiter:(\\S*).*";
    private static final Pattern END_DELIMITER_PATTERN = Pattern.compile(".*endDelimiter:(\\S*).*", 2);
    private static final String ROLLBACK_END_DELIMITER_REGEX = ".*rollbackEndDelimiter:(\\S*).*";
    private static final Pattern ROLLBACK_END_DELIMITER_PATTERN = Pattern.compile(".*rollbackEndDelimiter:(\\S*).*", 2);
    private static final String COMMENT_REGEX = "\\-\\-[\\s]*comment:? (.*)";
    private static final Pattern COMMENT_PATTERN = Pattern.compile("\\-\\-[\\s]*comment:? (.*)", 2);
    private static final String ALT_COMMENT_PLURAL_REGEX = "\\-\\-[\\s]*comments:? (.*)";
    private static final Pattern ALT_COMMENT_PLURAL_PATTERN = Pattern.compile("\\-\\-[\\s]*comments:? (.*)", 2);
    private static final String ALT_COMMENT_ONE_DASH_REGEX = "\\-[\\s]*comment:? (.*)";
    private static final Pattern ALT_COMMENT_ONE_DASH_PATTERN = Pattern.compile("\\-[\\s]*comment:? (.*)", 2);
    private static final String VALID_CHECK_SUM_REGEX = "\\-\\-[\\s]*validCheckSum:? (.*)";
    private static final Pattern VALID_CHECK_SUM_PATTERN = Pattern.compile("\\-\\-[\\s]*validCheckSum:? (.*)", 2);
    private static final String ALT_VALID_CHECK_SUM_ONE_DASH_REGEX = "^\\-[\\s]*validCheckSum(.*)$";
    private static final Pattern ALT_VALID_CHECK_SUM_ONE_DASH_PATTERN = Pattern.compile("^\\-[\\s]*validCheckSum(.*)$", 2);
    private static final String IGNORE_LINES_REGEX = "\\-\\-[\\s]*ignoreLines:(\\w+)";
    private static final Pattern IGNORE_LINES_PATTERN = Pattern.compile("\\-\\-[\\s]*ignoreLines:(\\w+)", 2);
    private static final String ALT_IGNORE_LINES_ONE_DASH_REGEX = "\\-[\\s]*?ignoreLines:(\\w+).*$";
    private static final Pattern ALT_IGNORE_LINES_ONE_DASH_PATTERN = Pattern.compile("\\-[\\s]*?ignoreLines:(\\w+).*$", 2);
    private static final String ALT_IGNORE_REGEX = "\\-\\-[\\s]*ignore:(\\w+)";
    private static final Pattern ALT_IGNORE_PATTERN = Pattern.compile("\\-\\-[\\s]*ignore:(\\w+)", 2);
    private static final String RUN_WITH_REGEX = ".*runWith:([\\w\\$\\{\\}]+).*";
    private static final Pattern RUN_WITH_PATTERN = Pattern.compile(".*runWith:([\\w\\$\\{\\}]+).*", 2);
    private static final String RUN_WITH_SPOOL_FILE_REGEX = ".*runWithSpoolFile:(.*).*";
    private static final Pattern RUN_WITH_SPOOL_FILE_PATTERN = Pattern.compile(".*runWithSpoolFile:(.*).*", 2);
    private static final String RUN_ON_CHANGE_REGEX = ".*runOnChange:(\\w+).*";
    private static final Pattern RUN_ON_CHANGE_PATTERN = Pattern.compile(".*runOnChange:(\\w+).*", 2);
    private static final String RUN_ALWAYS_REGEX = ".*runAlways:(\\w+).*";
    private static final Pattern RUN_ALWAYS_PATTERN = Pattern.compile(".*runAlways:(\\w+).*", 2);
    private static final String CONTEXT_REGEX = ".*context:(\".*\"|\\S*).*";
    private static final Pattern CONTEXT_PATTERN = Pattern.compile(".*context:(\".*\"|\\S*).*", 2);
    private static final String CONTEXT_FILTER_REGEX = ".*contextFilter:(\".*\"|\\S*).*";
    private static final Pattern CONTEXT_FILTER_PATTERN = Pattern.compile(".*contextFilter:(\".*\"|\\S*).*", 2);
    private static final String LOGICAL_FILE_PATH_REGEX = ".*logicalFilePath:(\\S*).*";
    private static final Pattern LOGICAL_FILE_PATH_PATTERN = Pattern.compile(".*logicalFilePath:(\\S*).*", 2);
    private static final String CHANGE_LOG_ID_REGEX = ".*changeLogId:(\\S*).*";
    private static final Pattern CHANGE_LOG_ID_PATTERN = Pattern.compile(".*changeLogId:(\\S*).*", 2);
    private static final String LABELS_REGEX = ".*labels:(\\S*).*";
    private static final Pattern LABELS_PATTERN = Pattern.compile(".*labels:(\\S*).*", 2);
    private static final String RUN_IN_TRANSACTION_REGEX = ".*runInTransaction:(\\w+).*";
    private static final Pattern RUN_IN_TRANSACTION_PATTERN = Pattern.compile(".*runInTransaction:(\\w+).*", 2);
    private static final String DBMS_REGEX = ".*dbms:([^,][\\w!,]+).*";
    private static final Pattern DBMS_PATTERN = Pattern.compile(".*dbms:([^,][\\w!,]+).*", 2);
    private static final String IGNORE_REGEX = ".*ignore:(\\w*).*";
    private static final Pattern IGNORE_PATTERN = Pattern.compile(".*ignore:(\\w*).*", 2);
    private static final String FAIL_ON_ERROR_REGEX = ".*failOnError:(\\w+).*";
    private static final Pattern FAIL_ON_ERROR_PATTERN = Pattern.compile(".*failOnError:(\\w+).*", 2);
    private static final String ON_FAIL_REGEX = ".*onFail:(\\w+).*";
    private static final Pattern ON_FAIL_PATTERN = Pattern.compile(".*onFail:(\\w+).*", 2);
    private static final String ON_ERROR_REGEX = ".*onError:(\\w+).*";
    private static final Pattern ON_ERROR_PATTERN = Pattern.compile(".*onError:(\\w+).*", 2);
    private static final String ON_UPDATE_SQL_REGEX = ".*onUpdateSQL:(\\w+).*";
    private static final Pattern ON_UPDATE_SQL_PATTERN = Pattern.compile(".*onUpdateSQL:(\\w+).*", 2);
    private static final String ON_SQL_OUTPUT_REGEX = ".*onSqlOutput:(\\w+).*";
    private static final Pattern ON_SQL_OUTPUT_PATTERN = Pattern.compile(".*onSqlOutput:(\\w+).*", 2);
    private static final String ROLLBACK_CHANGE_SET_ID_REGEX = ".*changeSetId:(\\S+).*";
    private static final Pattern ROLLBACK_CHANGE_SET_ID_PATTERN = Pattern.compile(".*changeSetId:(\\S+).*", 2);
    private static final String ROLLBACK_CHANGE_SET_AUTHOR_REGEX = ".*changesetAuthor:(\\S+).*";
    private static final Pattern ROLLBACK_CHANGE_SET_AUTHOR_PATTERN = Pattern.compile(".*changesetAuthor:(\\S+).*", 2);
    private static final String ROLLBACK_CHANGE_SET_PATH_REGEX = ".*changesetPath:(\\S+).*";
    private static final Pattern ROLLBACK_CHANGE_SET_PATH_PATTERN = Pattern.compile(".*changesetPath:(\\S+).*", 2);
    private static final String ROLLBACK_MULTI_LINE_START_REGEX = "\\s*\\/\\*\\s*liquibase\\s*rollback\\s*$";
    private static final Pattern ROLLBACK_MULTI_LINE_START_PATTERN = Pattern.compile("\\s*\\/\\*\\s*liquibase\\s*rollback\\s*$", 2);
    private static final String WORD_RESULT_REGEX = "^(?:expectedResult:)?(\\w+) (.*)";
    private static final String SINGLE_QUOTE_RESULT_REGEX = "^(?:expectedResult:)?'([^']+)' (.*)";
    private static final String DOUBLE_QUOTE_RESULT_REGEX = "^(?:expectedResult:)?\"([^\"]+)\" (.*)";
    private static final Pattern[] WORD_AND_QUOTING_PATTERNS = new Pattern[]{Pattern.compile("^(?:expectedResult:)?(\\w+) (.*)", 2), Pattern.compile("^(?:expectedResult:)?'([^']+)' (.*)", 2), Pattern.compile("^(?:expectedResult:)?\"([^\"]+)\" (.*)", 2)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        BufferedReader reader = null;
        try {
            if (this.supportsExtension(changeLogFile)) {
                InputStream fileStream = this.openChangeLogFile(changeLogFile, resourceAccessor);
                if (fileStream == null) {
                    boolean bl = false;
                    return bl;
                }
                reader = new BufferedReader(StreamUtil.readStreamWithReader(fileStream, null));
                String firstLine = reader.readLine();
                while (firstLine.trim().isEmpty() && reader.ready()) {
                    firstLine = reader.readLine();
                }
                boolean e = firstLine != null && FIRST_LINE_PATTERN.matcher(firstLine).matches();
                return e;
            }
            boolean fileStream = false;
            return fileStream;
        }
        catch (IOException e) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Exception reading " + changeLogFile, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Scope.getCurrentScope().getLog(this.getClass()).fine("Exception closing " + changeLogFile, e);
                }
            }
        }
    }

    @Override
    public int getPriority() {
        return 6;
    }

    @Override
    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        DatabaseChangeLog changeLog = new DatabaseChangeLog();
        changeLog.setChangeLogParameters(changeLogParameters);
        changeLog.setPhysicalFilePath(physicalChangeLogLocation);
        try (BufferedReader reader = new BufferedReader(StreamUtil.readStreamWithReader(this.openChangeLogFile(physicalChangeLogLocation, resourceAccessor), null));){
            String line;
            StringBuilder currentSql = new StringBuilder();
            StringBuilder currentRollbackSql = new StringBuilder();
            ChangeSet changeSet = null;
            AbstractSQLChange change = null;
            Matcher rollbackSplitStatementsPatternMatcher = null;
            boolean rollbackSplitStatements = true;
            String rollbackEndDelimiter = null;
            int count = 0;
            block13: while ((line = reader.readLine()) != null) {
                String message;
                ++count;
                Matcher commentMatcher = COMMENT_PATTERN.matcher(line);
                Matcher propertyPatternMatcher = PROPERTY_PATTERN.matcher(line);
                Matcher altPropertyPatternMatcher = ALT_PROPERTY_ONE_DASH_PATTERN.matcher(line);
                if (propertyPatternMatcher.matches()) {
                    this.handleProperty(changeLogParameters, changeLog, propertyPatternMatcher);
                    continue;
                }
                if (altPropertyPatternMatcher.matches()) {
                    String message2 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--property name=<property name> value=<property value>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                    throw new ChangeLogParseException("\n" + message2);
                }
                Matcher changeLogPatterMatcher = FIRST_LINE_PATTERN.matcher(line);
                if (changeLogPatterMatcher.matches()) {
                    Matcher logicalFilePathMatcher = LOGICAL_FILE_PATH_PATTERN.matcher(line);
                    changeLog.setLogicalFilePath(this.parseString(logicalFilePathMatcher));
                    Matcher changeLogIdMatcher = CHANGE_LOG_ID_PATTERN.matcher(line);
                    changeLog.setChangeLogId(this.parseString(changeLogIdMatcher));
                }
                Matcher ignoreLinesMatcher = IGNORE_LINES_PATTERN.matcher(line);
                Matcher altIgnoreMatcher = ALT_IGNORE_PATTERN.matcher(line);
                Matcher altIgnoreLinesOneDashMatcher = ALT_IGNORE_LINES_ONE_DASH_PATTERN.matcher(line);
                if (ignoreLinesMatcher.matches()) {
                    if ("start".equals(ignoreLinesMatcher.group(1))) {
                        while ((line = reader.readLine()) != null) {
                            altIgnoreLinesOneDashMatcher = ALT_IGNORE_LINES_ONE_DASH_PATTERN.matcher(line);
                            ++count;
                            ignoreLinesMatcher = IGNORE_LINES_PATTERN.matcher(line);
                            if (ignoreLinesMatcher.matches()) {
                                if (!"end".equals(ignoreLinesMatcher.group(1))) continue;
                                continue block13;
                            }
                            if (!altIgnoreLinesOneDashMatcher.matches()) continue;
                            String message3 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--ignoreLines:end' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                            throw new ChangeLogParseException("\n" + message3);
                        }
                        continue;
                    }
                    try {
                        long ignoreCount = Long.parseLong(ignoreLinesMatcher.group(1));
                        while (ignoreCount > 0L && (line = reader.readLine()) != null) {
                            --ignoreCount;
                            ++count;
                        }
                        continue;
                    }
                    catch (NullPointerException | NumberFormatException nfe) {
                        throw new ChangeLogParseException("Unknown ignoreLines syntax");
                    }
                }
                if (altIgnoreLinesOneDashMatcher.matches() || altIgnoreMatcher.matches()) {
                    String message4 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--ignoreLines:<count|start>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                    throw new ChangeLogParseException("\n" + message4);
                }
                Matcher changeSetPatternMatcher = CHANGE_SET_PATTERN.matcher(line);
                if (changeSetPatternMatcher.matches()) {
                    String ignore;
                    String dbms;
                    String logicalFilePath;
                    String labels;
                    String runWithSpoolFile;
                    String finalCurrentSql = changeLogParameters.expandExpressions(StringUtil.trimToNull(currentSql.toString()), changeLog);
                    if (changeSet != null) {
                        if (finalCurrentSql == null) {
                            throw new ChangeLogParseException("No SQL for changeset " + changeSet.toString(false));
                        }
                        change.setSql(finalCurrentSql);
                        String currentRollBackSqlAsString = currentRollbackSql.toString();
                        if (StringUtil.trimToNull(currentRollBackSqlAsString) != null) {
                            if (currentRollBackSqlAsString.trim().toLowerCase().matches("^not required.*")) {
                                changeSet.addRollbackChange(new EmptyChange());
                            } else if (currentRollBackSqlAsString.trim().toLowerCase().contains("changesetid")) {
                                String rollbackString = currentRollBackSqlAsString.replace("\n", "").replace("\r", "");
                                Matcher authorMatcher = ROLLBACK_CHANGE_SET_AUTHOR_PATTERN.matcher(rollbackString);
                                Matcher idMatcher = ROLLBACK_CHANGE_SET_ID_PATTERN.matcher(rollbackString);
                                Matcher pathMatcher = ROLLBACK_CHANGE_SET_PATH_PATTERN.matcher(rollbackString);
                                String changeSetAuthor = StringUtil.trimToNull(this.parseString(authorMatcher));
                                String changeSetId = StringUtil.trimToNull(this.parseString(idMatcher));
                                String changeSetPath = StringUtil.trimToNull(this.parseString(pathMatcher));
                                if (changeSetId == null) {
                                    throw new ChangeLogParseException("'changesetId' not set in rollback block '" + rollbackString + "'");
                                }
                                if (changeSetAuthor == null) {
                                    throw new ChangeLogParseException("'changesetAuthor' not set in rollback block '" + rollbackString + "'");
                                }
                                if (changeSetPath == null) {
                                    changeSetPath = physicalChangeLogLocation;
                                }
                                ChangeSet rollbackChangeSet = changeLog.getChangeSet(changeSetPath, changeSetAuthor, changeSetId);
                                DatabaseChangeLog parent = changeLog;
                                while (rollbackChangeSet == null && parent != null) {
                                    if ((parent = parent.getParentChangeLog()) == null) continue;
                                    rollbackChangeSet = parent.getChangeSet(changeSetPath, changeSetAuthor, changeSetId);
                                }
                                if (rollbackChangeSet == null) {
                                    throw new ChangeLogParseException("Change set " + new ChangeSet(changeSetId, changeSetAuthor, false, false, changeSetPath, null, null, null).toString(false) + " does not exist");
                                }
                                for (Change rollbackChange : rollbackChangeSet.getChanges()) {
                                    changeSet.addRollbackChange(rollbackChange);
                                }
                            } else {
                                Change rollbackChange = new RawSQLChange();
                                ((AbstractSQLChange)rollbackChange).setSql(changeLogParameters.expandExpressions(currentRollbackSql.toString(), changeSet.getChangeLog()));
                                if (rollbackSplitStatementsPatternMatcher.matches()) {
                                    ((AbstractSQLChange)rollbackChange).setSplitStatements(rollbackSplitStatements);
                                }
                                if (rollbackEndDelimiter != null) {
                                    ((AbstractSQLChange)rollbackChange).setEndDelimiter(rollbackEndDelimiter);
                                }
                                changeSet.addRollbackChange(rollbackChange);
                            }
                        }
                    }
                    Matcher stripCommentsPatternMatcher = STRIP_COMMENTS_PATTERN.matcher(line);
                    Matcher splitStatementsPatternMatcher = SPLIT_STATEMENTS_PATTERN.matcher(line);
                    Matcher runWithMatcher = RUN_WITH_PATTERN.matcher(line);
                    Matcher runWithSpoolFileMatcher = RUN_WITH_SPOOL_FILE_PATTERN.matcher(line);
                    rollbackSplitStatementsPatternMatcher = ROLLBACK_SPLIT_STATEMENTS_PATTERN.matcher(line);
                    Matcher endDelimiterPatternMatcher = END_DELIMITER_PATTERN.matcher(line);
                    Matcher rollbackEndDelimiterPatternMatcher = ROLLBACK_END_DELIMITER_PATTERN.matcher(line);
                    Matcher logicalFilePathMatcher = LOGICAL_FILE_PATH_PATTERN.matcher(line);
                    Matcher runOnChangePatternMatcher = RUN_ON_CHANGE_PATTERN.matcher(line);
                    Matcher runAlwaysPatternMatcher = RUN_ALWAYS_PATTERN.matcher(line);
                    Matcher contextPatternMatcher = CONTEXT_PATTERN.matcher(line);
                    Matcher contextFilterPatternMatcher = CONTEXT_FILTER_PATTERN.matcher(line);
                    Matcher labelsPatternMatcher = LABELS_PATTERN.matcher(line);
                    Matcher runInTransactionPatternMatcher = RUN_IN_TRANSACTION_PATTERN.matcher(line);
                    Matcher dbmsPatternMatcher = DBMS_PATTERN.matcher(line);
                    Matcher ignorePatternMatcher = IGNORE_PATTERN.matcher(line);
                    Matcher failOnErrorPatternMatcher = FAIL_ON_ERROR_PATTERN.matcher(line);
                    boolean stripComments = this.parseBoolean(stripCommentsPatternMatcher, changeSet, true);
                    boolean splitStatements = this.parseBoolean(splitStatementsPatternMatcher, changeSet, true);
                    rollbackSplitStatements = this.parseBoolean(rollbackSplitStatementsPatternMatcher, changeSet, true);
                    boolean runOnChange = this.parseBoolean(runOnChangePatternMatcher, changeSet, false);
                    boolean runAlways = this.parseBoolean(runAlwaysPatternMatcher, changeSet, false);
                    boolean runInTransaction = this.parseBoolean(runInTransactionPatternMatcher, changeSet, true);
                    boolean failOnError = this.parseBoolean(failOnErrorPatternMatcher, changeSet, true);
                    String runWith = this.parseString(runWithMatcher);
                    if (runWith != null) {
                        runWith = changeLogParameters.expandExpressions(runWith, changeLog);
                    }
                    if ((runWithSpoolFile = this.parseString(runWithSpoolFileMatcher)) != null) {
                        runWithSpoolFile = changeLogParameters.expandExpressions(runWithSpoolFile, changeLog);
                    }
                    String endDelimiter = this.parseString(endDelimiterPatternMatcher);
                    rollbackEndDelimiter = this.parseString(rollbackEndDelimiterPatternMatcher);
                    String context = StringUtil.trimToNull(StringUtil.trimToEmpty(this.parseString(contextFilterPatternMatcher)).replaceFirst("^\"", "").replaceFirst("\"$", ""));
                    if (context == null) {
                        context = StringUtil.trimToNull(StringUtil.trimToEmpty(this.parseString(contextPatternMatcher)).replaceFirst("^\"", "").replaceFirst("\"$", ""));
                    }
                    if (context != null) {
                        context = changeLogParameters.expandExpressions(context, changeLog);
                    }
                    if ((labels = this.parseString(labelsPatternMatcher)) != null) {
                        labels = changeLogParameters.expandExpressions(labels, changeLog);
                    }
                    if ((logicalFilePath = this.parseString(logicalFilePathMatcher)) == null || "".equals(logicalFilePath)) {
                        logicalFilePath = changeLog.getLogicalFilePath();
                    }
                    if (logicalFilePath != null) {
                        logicalFilePath = changeLogParameters.expandExpressions(logicalFilePath, changeLog);
                    }
                    if ((dbms = this.parseString(dbmsPatternMatcher)) != null) {
                        dbms = changeLogParameters.expandExpressions(dbms, changeLog);
                    }
                    if ((ignore = this.parseString(ignorePatternMatcher)) != null) {
                        ignore = changeLogParameters.expandExpressions(ignore, changeLog);
                    }
                    String idGroup = changeSetPatternMatcher.group(2);
                    String authorGroup = changeSetPatternMatcher.group(1);
                    Pattern changeSetAuthorIdPattern = Pattern.compile("\\s*\\-\\-[\\s]*changeset\\s+" + Pattern.quote(authorGroup + ":" + idGroup) + ".*$", 2);
                    Matcher changeSetAuthorIdPatternMatcher = changeSetAuthorIdPattern.matcher(line);
                    if (!changeSetAuthorIdPatternMatcher.matches()) {
                        String message5 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--changeset <authorname>:<changesetId>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                        throw new ChangeLogParseException("\n" + message5);
                    }
                    String changeSetId = changeLogParameters.expandExpressions(StringUtil.stripEnclosingQuotes(idGroup), changeLog);
                    String changeSetAuthor = changeLogParameters.expandExpressions(StringUtil.stripEnclosingQuotes(authorGroup), changeLog);
                    changeSet = new ChangeSet(changeSetId, changeSetAuthor, runAlways, runOnChange, DatabaseChangeLog.normalizePath(logicalFilePath), context, dbms, runWith, runWithSpoolFile, runInTransaction, changeLog.getObjectQuotingStrategy(), changeLog);
                    changeSet.setLabels(new Labels(labels));
                    changeSet.setIgnore(Boolean.parseBoolean(ignore));
                    changeSet.setFailOnError(failOnError);
                    changeLog.addChangeSet(changeSet);
                    change = new RawSQLChange();
                    change.setSql(finalCurrentSql);
                    if (splitStatementsPatternMatcher.matches()) {
                        change.setSplitStatements(splitStatements);
                    }
                    change.setStripComments(stripComments);
                    change.setEndDelimiter(endDelimiter);
                    changeSet.addChange(change);
                    currentSql.setLength(0);
                    currentRollbackSql.setLength(0);
                    continue;
                }
                Matcher altChangeSetOneDashPatternMatcher = ALT_CHANGE_SET_ONE_DASH_PATTERN.matcher(line);
                Matcher altChangeSetNoOtherInfoPatternMatcher = ALT_CHANGE_SET_NO_OTHER_INFO_PATTERN.matcher(line);
                if (altChangeSetOneDashPatternMatcher.matches() || altChangeSetNoOtherInfoPatternMatcher.matches()) {
                    message = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--changeset <authorname>:<changesetId>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                    throw new ChangeLogParseException("\n" + message);
                }
                if (changeSet != null) {
                    String message6;
                    Matcher altCommentOneDashMatcher = ALT_COMMENT_ONE_DASH_PATTERN.matcher(line);
                    Matcher altCommentPluralMatcher = ALT_COMMENT_PLURAL_PATTERN.matcher(line);
                    Matcher rollbackMatcher = ROLLBACK_PATTERN.matcher(line);
                    Matcher altRollbackMatcher = ALT_ROLLBACK_ONE_DASH_PATTERN.matcher(line);
                    Matcher preconditionsMatcher = PRECONDITIONS_PATTERN.matcher(line);
                    Matcher altPreconditionsOneDashMatcher = ALT_PRECONDITIONS_ONE_DASH_PATTERN.matcher(line);
                    Matcher preconditionMatcher = PRECONDITION_PATTERN.matcher(line);
                    Matcher altPreconditionOneDashMatcher = ALT_PRECONDITION_ONE_DASH_PATTERN.matcher(line);
                    Matcher validCheckSumMatcher = VALID_CHECK_SUM_PATTERN.matcher(line);
                    Matcher altValidCheckSumOneDashMatcher = ALT_VALID_CHECK_SUM_ONE_DASH_PATTERN.matcher(line);
                    Matcher rollbackMultiLineStartMatcher = ROLLBACK_MULTI_LINE_START_PATTERN.matcher(line);
                    if (commentMatcher.matches()) {
                        if (commentMatcher.groupCount() == 0) {
                            message6 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--comment <comment>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                            throw new ChangeLogParseException("\n" + message6);
                        }
                        if (commentMatcher.groupCount() != 1) continue;
                        changeSet.setComments(commentMatcher.group(1));
                        continue;
                    }
                    if (altCommentOneDashMatcher.matches() || altCommentPluralMatcher.matches()) {
                        message6 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--comment <comment>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                        throw new ChangeLogParseException("\n" + message6);
                    }
                    if (validCheckSumMatcher.matches()) {
                        if (validCheckSumMatcher.groupCount() == 0) {
                            message6 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--rollback <rollback SQL>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                            throw new ChangeLogParseException("\n" + message6);
                        }
                        if (validCheckSumMatcher.groupCount() != 1) continue;
                        changeSet.addValidCheckSum(validCheckSumMatcher.group(1));
                        continue;
                    }
                    if (altValidCheckSumOneDashMatcher.matches()) {
                        message6 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--validChecksum <checksum>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                        throw new ChangeLogParseException("\n" + message6);
                    }
                    if (rollbackMatcher.matches()) {
                        if (rollbackMatcher.groupCount() == 0) {
                            message6 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--rollback <rollback SQL>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                            throw new ChangeLogParseException("\n" + message6);
                        }
                        currentRollbackSql.append(rollbackMatcher.group(1)).append(System.lineSeparator());
                        continue;
                    }
                    if (altRollbackMatcher.matches()) {
                        message6 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--rollback <rollback SQL>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                        throw new ChangeLogParseException("\n" + message6);
                    }
                    if (rollbackMultiLineStartMatcher.matches()) {
                        if (rollbackMultiLineStartMatcher.groupCount() != 0) continue;
                        currentRollbackSql.append((CharSequence)this.extractMultiLineRollBackSQL(reader));
                        continue;
                    }
                    if (preconditionsMatcher.matches()) {
                        if (preconditionsMatcher.groupCount() == 0) {
                            message6 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--preconditions <onFail>|<onError>|<onUpdate>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                            throw new ChangeLogParseException("\n" + message6);
                        }
                        if (preconditionsMatcher.groupCount() != 1) continue;
                        String body = preconditionsMatcher.group(1);
                        Matcher onFailMatcher = ON_FAIL_PATTERN.matcher(body);
                        Matcher onErrorMatcher = ON_ERROR_PATTERN.matcher(body);
                        Matcher onUpdateSqlMatcher = ON_UPDATE_SQL_PATTERN.matcher(body);
                        Matcher onSqlOutputMatcher = ON_SQL_OUTPUT_PATTERN.matcher(body);
                        PreconditionContainer pc = new PreconditionContainer();
                        pc.setOnFail(StringUtil.trimToNull(this.parseString(onFailMatcher)));
                        pc.setOnError(StringUtil.trimToNull(this.parseString(onErrorMatcher)));
                        if (onSqlOutputMatcher.matches() && onUpdateSqlMatcher.matches()) {
                            throw new IllegalArgumentException("Please modify the changelog to have preconditions set with either 'onUpdateSql' or 'onSqlOutput', and not with both.");
                        }
                        if (onSqlOutputMatcher.matches()) {
                            pc.setOnSqlOutput(StringUtil.trimToNull(this.parseString(onSqlOutputMatcher)));
                        } else {
                            pc.setOnSqlOutput(StringUtil.trimToNull(this.parseString(onUpdateSqlMatcher)));
                        }
                        changeSet.setPreconditions(pc);
                        continue;
                    }
                    if (altPreconditionsOneDashMatcher.matches()) {
                        message6 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--preconditions <onFail>|<onError>|<onUpdate>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                        throw new ChangeLogParseException("\n" + message6);
                    }
                    if (preconditionMatcher.matches()) {
                        String name;
                        if (changeSet.getPreconditions() == null) {
                            changeSet.setPreconditions(new PreconditionContainer());
                        }
                        if (preconditionMatcher.groupCount() != 2 || (name = StringUtil.trimToNull(preconditionMatcher.group(1))) == null) continue;
                        String body = preconditionMatcher.group(2).trim();
                        if ("sql-check".equals(name)) {
                            changeSet.getPreconditions().addNestedPrecondition(this.parseSqlCheckCondition(changeLogParameters.expandExpressions(StringUtil.trimToNull(body), changeSet.getChangeLog())));
                            continue;
                        }
                        throw new ChangeLogParseException("The '" + name + "' precondition type is not supported.");
                    }
                    if (altPreconditionOneDashMatcher.matches()) {
                        message6 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--precondition-sql-check' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                        throw new ChangeLogParseException("\n" + message6);
                    }
                    currentSql.append(line).append(System.lineSeparator());
                    continue;
                }
                if (!commentMatcher.matches()) continue;
                message = String.format("Unexpected formatting at line %d. Formatted SQL changelogs do not allow comment lines outside of changesets. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                throw new ChangeLogParseException("\n" + message);
            }
            if (changeSet != null) {
                change.setSql(changeLogParameters.expandExpressions(StringUtil.trimToNull(currentSql.toString()), changeSet.getChangeLog()));
                if (change.getEndDelimiter() == null && StringUtil.trimToEmpty(((RawSQLChange)change).getSql()).endsWith("\n/")) {
                    change.setEndDelimiter("\n/$");
                }
                if (StringUtil.trimToNull(currentRollbackSql.toString()) != null) {
                    if (currentRollbackSql.toString().trim().toLowerCase().matches("^not required.*")) {
                        changeSet.addRollbackChange(new EmptyChange());
                    } else if (currentRollbackSql.toString().trim().toLowerCase().contains("changesetid")) {
                        String rollbackString = currentRollbackSql.toString().replace("\n", "").replace("\r", "");
                        Matcher authorMatcher = ROLLBACK_CHANGE_SET_AUTHOR_PATTERN.matcher(rollbackString);
                        Matcher idMatcher = ROLLBACK_CHANGE_SET_ID_PATTERN.matcher(rollbackString);
                        Matcher pathMatcher = ROLLBACK_CHANGE_SET_PATH_PATTERN.matcher(rollbackString);
                        String changeSetAuthor = StringUtil.trimToNull(this.parseString(authorMatcher));
                        String changeSetId = StringUtil.trimToNull(this.parseString(idMatcher));
                        String changeSetPath = StringUtil.trimToNull(this.parseString(pathMatcher));
                        if (changeSetId == null) {
                            throw new ChangeLogParseException("'changesetId' not set in rollback block '" + rollbackString + "'");
                        }
                        if (changeSetAuthor == null) {
                            throw new ChangeLogParseException("'changesetAuthor' not set in rollback block '" + rollbackString + "'");
                        }
                        if (changeSetPath == null) {
                            changeSetPath = physicalChangeLogLocation;
                        }
                        ChangeSet rollbackChangeSet = changeLog.getChangeSet(changeSetPath, changeSetAuthor, changeSetId);
                        DatabaseChangeLog parent = changeLog;
                        while (rollbackChangeSet == null && parent != null) {
                            if ((parent = parent.getParentChangeLog()) == null) continue;
                            rollbackChangeSet = parent.getChangeSet(changeSetPath, changeSetAuthor, changeSetId);
                        }
                        if (rollbackChangeSet == null) {
                            throw new ChangeLogParseException("Change set " + new ChangeSet(changeSetId, changeSetAuthor, false, false, changeSetPath, null, null, null).toString(false) + " does not exist");
                        }
                        for (Change rollbackChange : rollbackChangeSet.getChanges()) {
                            changeSet.addRollbackChange(rollbackChange);
                        }
                    } else {
                        RawSQLChange rollbackChange = new RawSQLChange();
                        rollbackChange.setSql(changeLogParameters.expandExpressions(currentRollbackSql.toString(), changeSet.getChangeLog()));
                        if (rollbackSplitStatementsPatternMatcher.matches()) {
                            rollbackChange.setSplitStatements(rollbackSplitStatements);
                        }
                        if (rollbackEndDelimiter != null) {
                            rollbackChange.setEndDelimiter(rollbackEndDelimiter);
                        }
                        changeSet.addRollbackChange(rollbackChange);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ChangeLogParseException(e);
        }
        return changeLog;
    }

    private void handleProperty(ChangeLogParameters changeLogParameters, DatabaseChangeLog changeLog, Matcher propertyPatternMatcher) {
        String name = null;
        String value = null;
        String context = null;
        String labels = null;
        String dbms = null;
        boolean global = true;
        block16: for (int i = 1; i <= propertyPatternMatcher.groupCount(); ++i) {
            String key;
            String temp = propertyPatternMatcher.group(i);
            String[] parts = temp.split(":");
            switch (key = parts[0].trim().toLowerCase()) {
                case "name": {
                    name = parts[1].trim();
                    continue block16;
                }
                case "value": {
                    value = parts[1].trim();
                    continue block16;
                }
                case "context": {
                    context = parts[1].trim();
                    continue block16;
                }
                case "labels": {
                    labels = parts[1].trim();
                    continue block16;
                }
                case "dbms": {
                    dbms = parts[1].trim();
                    continue block16;
                }
                case "global": {
                    global = Boolean.parseBoolean(parts[1].trim());
                }
            }
        }
        changeLogParameters.set(name, value, context, labels, dbms, global, changeLog);
    }

    private StringBuilder extractMultiLineRollBackSQL(BufferedReader reader) throws IOException, ChangeLogParseException {
        StringBuilder multiLineRollbackSQL = new StringBuilder();
        Pattern rollbackMultiLineEndPattern = Pattern.compile(".*\\s*\\*\\/\\s*$", 2);
        if (reader != null) {
            String line;
            while ((line = reader.readLine()) != null) {
                if (rollbackMultiLineEndPattern.matcher(line).matches()) {
                    String[] lastLineSplit = line.split("\\*\\/\\s*$");
                    if (lastLineSplit.length > 0 && !StringUtil.isWhitespace(lastLineSplit[0])) {
                        multiLineRollbackSQL.append(lastLineSplit[0]);
                    }
                    return multiLineRollbackSQL;
                }
                multiLineRollbackSQL.append(line);
            }
            throw new ChangeLogParseException("Liquibase rollback comment is not closed.");
        }
        return multiLineRollbackSQL;
    }

    protected boolean supportsExtension(String changelogFile) {
        return changelogFile.toLowerCase().endsWith(".sql");
    }

    private SqlPrecondition parseSqlCheckCondition(String body) throws ChangeLogParseException {
        for (Pattern pattern : WORD_AND_QUOTING_PATTERNS) {
            Matcher matcher = pattern.matcher(body);
            if (!matcher.matches() || matcher.groupCount() != 2) continue;
            SqlPrecondition p = new SqlPrecondition();
            p.setExpectedResult(matcher.group(1));
            p.setSql(matcher.group(2));
            return p;
        }
        throw new ChangeLogParseException("Could not parse a SqlCheck precondition from '" + body + "'.");
    }

    private String parseString(Matcher matcher) {
        String endDelimiter = null;
        if (matcher.matches()) {
            endDelimiter = matcher.group(1);
        }
        return endDelimiter;
    }

    private boolean parseBoolean(Matcher matcher, ChangeSet changeSet, boolean defaultValue) throws ChangeLogParseException {
        boolean stripComments = defaultValue;
        if (matcher.matches()) {
            try {
                stripComments = Boolean.parseBoolean(matcher.group(1));
            }
            catch (Exception e) {
                throw new ChangeLogParseException("Cannot parse " + changeSet + " " + matcher.toString().replaceAll("\\.*", "") + " as a boolean");
            }
        }
        return stripComments;
    }

    protected InputStream openChangeLogFile(String physicalChangeLogLocation, ResourceAccessor resourceAccessor) throws IOException {
        return resourceAccessor.getExisting(physicalChangeLogLocation).openInputStream();
    }
}

