/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import jakarta.servlet.ServletContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.resteasy.plugins.server.servlet.ConfigurationBootstrap;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class ListenerBootstrap
extends ConfigurationBootstrap {
    protected ServletContext servletContext;
    private static Object RD_LOCK = new Object();

    public ListenerBootstrap(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResteasyDeployment createDeployment() {
        ResteasyDeployment deployment = (ResteasyDeployment)this.servletContext.getAttribute(ResteasyDeployment.class.getName());
        if (deployment == null) {
            deployment = super.createDeployment();
        }
        deployment.getDefaultContextObjects().put(ResteasyDeployment.class, deployment);
        deployment.getDefaultContextObjects().put(ServletContext.class, this.servletContext);
        deployment.getDefaultContextObjects().put(ResteasyConfiguration.class, this);
        String servletMappingPrefix = this.getParameter("resteasy.servlet.mapping.prefix");
        if (servletMappingPrefix == null) {
            servletMappingPrefix = "";
        }
        servletMappingPrefix = servletMappingPrefix.trim();
        Object object = RD_LOCK;
        synchronized (object) {
            ConcurrentHashMap<String, ResteasyDeployment> deployments = (ConcurrentHashMap<String, ResteasyDeployment>)this.servletContext.getAttribute("resteasy.deployments");
            if (deployments == null) {
                deployments = new ConcurrentHashMap<String, ResteasyDeployment>();
                this.servletContext.setAttribute("resteasy.deployments", deployments);
            }
            deployments.put(servletMappingPrefix, deployment);
        }
        return deployment;
    }

    public static URL[] findWebInfLibClasspaths(ServletContext servletContext) {
        ArrayList<URL> list = new ArrayList<URL>();
        Set libJars = servletContext.getResourcePaths("/WEB-INF/lib");
        if (libJars == null) {
            URL[] empty = new URL[]{};
            return empty;
        }
        for (String jar : libJars) {
            try {
                list.add(servletContext.getResource(jar));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    public Set<String> getParameterNames() {
        return this.getServletContextNames();
    }

    protected Set<String> getServletContextNames() {
        Enumeration en = this.servletContext.getInitParameterNames();
        HashSet<String> set = new HashSet<String>();
        while (en.hasMoreElements()) {
            set.add((String)en.nextElement());
        }
        return set;
    }

    public Set<String> getInitParameterNames() {
        return this.getParameterNames();
    }

    public String getInitParameter(String name) {
        return this.servletContext.getInitParameter(name);
    }
}

