/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.client.remote;

import ai.digital.deploy.permissions.api.rest.dto.RoleWithGlobalPermissionsDto;
import ai.digital.deploy.permissions.api.rest.pagination.Order$;
import ai.digital.deploy.permissions.api.rest.pagination.Paging$;
import ai.digital.deploy.permissions.client.GlobalPermissionsServiceClient;
import ai.digital.deploy.permissions.client.PaginatedResponse;
import ai.digital.deploy.permissions.client.util.SortOrder;
import com.xebialabs.deployit.ServerConfiguration;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@Profile(value={"!permission-service"})
@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001B\u0011#\u0001=B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u00061\u0002!\t!\u0017\u0005\b?\u0002\u0011\r\u0011\"\u0003a\u0011\u0019I\u0007\u0001)A\u0005C\"9!\u000e\u0001b\u0001\n\u0013\u0001\u0007BB6\u0001A\u0003%\u0011\rC\u0004m\u0001\t\u0007I\u0011\u00021\t\r5\u0004\u0001\u0015!\u0003b\u0011\u001dq\u0007A1A\u0005\n\u0001Daa\u001c\u0001!\u0002\u0013\t\u0007b\u00029\u0001\u0005\u0004%I\u0001\u0019\u0005\u0007c\u0002\u0001\u000b\u0011B1\t\u000fI\u0004!\u0019!C\u0005A\"11\u000f\u0001Q\u0001\n\u0005Dq\u0001\u001e\u0001C\u0002\u0013%\u0001\r\u0003\u0004v\u0001\u0001\u0006I!\u0019\u0005\bm\u0002\u0011\r\u0011\"\u0003a\u0011\u00199\b\u0001)A\u0005C\"9\u0001\u0010\u0001b\u0001\n\u0013\u0001\u0007BB=\u0001A\u0003%\u0011\rC\u0004{\u0001\t\u0007I\u0011\u00021\t\rm\u0004\u0001\u0015!\u0003b\u0011\u001da\bA1A\u0005\n\u0001Da! \u0001!\u0002\u0013\t\u0007\"\u0002@\u0001\t\u0003z\bbBA!\u0001\u0011\u0005\u00131\t\u0005\u0007i\u0002!\t%!\u0013\t\rQ\u0004A\u0011IA'\u0011\u001d\tY\b\u0001C!\u0003{Bq!a!\u0001\t\u0003\n)\tC\u0004\u0002\u0012\u0002!\t%a%\t\rY\u0004A\u0011IAN\u0005\u0011\u0012V-\\8uK\u001ecwNY1m!\u0016\u0014X.[:tS>t7oU3sm&\u001cWm\u00117jK:$(BA\u0012%\u0003\u0019\u0011X-\\8uK*\u0011QEJ\u0001\u0007G2LWM\u001c;\u000b\u0005\u001dB\u0013a\u00039fe6L7o]5p]NT!!\u000b\u0016\u0002\r\u0011,\u0007\u000f\\8z\u0015\tYC&A\u0004eS\u001eLG/\u00197\u000b\u00035\n!!Y5\u0004\u0001M\u0019\u0001\u0001\r\u001c\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g!\t9\u0004(D\u0001%\u0013\tIDE\u0001\u0010HY>\u0014\u0017\r\u001c)fe6L7o]5p]N\u001cVM\u001d<jG\u0016\u001cE.[3oi\u0006a!/Z:u)\u0016l\u0007\u000f\\1uKB\u0011A\bR\u0007\u0002{)\u0011QE\u0010\u0006\u0003\u007f\u0001\u000b1a^3c\u0015\t\t%)A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0019\u0015aA8sO&\u0011Q)\u0010\u0002\r%\u0016\u001cH\u000fV3na2\fG/\u001a\u0015\u0003\u0003\u001d\u0003\"\u0001S(\u000e\u0003%S!AS&\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002M\u001b\u00069a-Y2u_JL(B\u0001(A\u0003\u0015\u0011W-\u00198t\u0013\t\u0001\u0016JA\u0005BkR|w/\u001b:fI\"\"\u0011AU+W!\tA5+\u0003\u0002U\u0013\nI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002/\u0006i\u0002/\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3SKN$H+Z7qY\u0006$X-\u0001\u0004=S:LGO\u0010\u000b\u00035r\u0003\"a\u0017\u0001\u000e\u0003\tBQA\u000f\u0002A\u0002mB#\u0001X$)\tq\u0013VKV\u0001\u0015a\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,WK\u001d7\u0016\u0003\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\t1\fgn\u001a\u0006\u0002M\u0006!!.\u0019<b\u0013\tA7M\u0001\u0004TiJLgnZ\u0001\u0016a\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,WK\u001d7!\u0003a9Gn\u001c2bYB+'/\\5tg&|gn\u001d\"bg\u0016,&\u000f\\\u0001\u001aO2|'-\u00197QKJl\u0017n]:j_:\u001c()Y:f+Jd\u0007%\u0001\u0011fqR,g\u000eZ3e\u000f2|'-\u00197QKJl\u0017n]:j_:\u001c()Y:f+Jd\u0017!I3yi\u0016tG-\u001a3HY>\u0014\u0017\r\u001c)fe6L7o]5p]N\u0014\u0015m]3Ve2\u0004\u0013!E1eIB+'/\\5tg&|gn]+sY\u0006\u0011\u0012\r\u001a3QKJl\u0017n]:j_:\u001cXK\u001d7!\u0003Q\u0011X-\\8wKB+'/\\5tg&|gn]+sY\u0006)\"/Z7pm\u0016\u0004VM]7jgNLwN\\:Ve2\u0004\u0013!\u0004:fC\u0012\u0014\u0015PU8mKV\u0013H.\u0001\bsK\u0006$')\u001f*pY\u0016,&\u000f\u001c\u0011\u0002\tI,\u0017\rZ\u0001\u0006e\u0016\fG\rI\u0001\u0012e\u0016\fGMQ=S_2,\u0007+\u0019;uKJt\u0017A\u0005:fC\u0012\u0014\u0015PU8mKB\u000bG\u000f^3s]\u0002\nAB]3bI\u001a{'OU8mKN\fQB]3bI\u001a{'OU8mKN\u0004\u0013\u0001I4fi\u001ecwNY1m!\u0016\u0014X.[:tS>t7OR8s%>dW-\u00133Ve2\f\u0011eZ3u\u000f2|'-\u00197QKJl\u0017n]:j_:\u001chi\u001c:S_2,\u0017\nZ+sY\u0002\nqeZ3u\u000f2|'-\u00197QKJl\u0017n]:j_:\u001chi\u001c:Qe&t7-\u001b9bY:\u000bW.Z+sY\u0006As-\u001a;HY>\u0014\u0017\r\u001c)fe6L7o]5p]N4uN\u001d)sS:\u001c\u0017\u000e]1m\u001d\u0006lW-\u0016:mA\u0005q\u0011\r\u001a3QKJl\u0017n]:j_:\u001cHCBA\u0001\u0003+\ti\u0003\u0005\u0003\u0002\u0004\u0005EQBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0007\u0011$xN\u0003\u0003\u0002\f\u00055\u0011\u0001\u0002:fgRT1!a\u0004'\u0003\r\t\u0007/[\u0005\u0005\u0003'\t)A\u0001\u000fS_2,w+\u001b;i\u000f2|'-\u00197QKJl\u0017n]:j_:\u001cH\t^8\t\u000f\u0005]\u0011\u00041\u0001\u0002\u001a\u0005A!o\u001c7f\u001d\u0006lW\r\u0005\u0003\u0002\u001c\u0005%b\u0002BA\u000f\u0003K\u00012!a\b3\u001b\t\t\tCC\u0002\u0002$9\na\u0001\u0010:p_Rt\u0014bAA\u0014e\u00051\u0001K]3eK\u001aL1\u0001[A\u0016\u0015\r\t9C\r\u0005\u0007Oe\u0001\r!a\f\u0011\r\u0005E\u00121HA\r\u001d\u0011\t\u0019$a\u000e\u000f\t\u0005}\u0011QG\u0005\u0002g%\u0019\u0011\u0011\b\u001a\u0002\u000fA\f7m[1hK&!\u0011QHA \u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005e\"'A\tsK6|g/\u001a)fe6L7o]5p]N$b!!\u0001\u0002F\u0005\u001d\u0003bBA\f5\u0001\u0007\u0011\u0011\u0004\u0005\u0007Oi\u0001\r!a\f\u0015\t\u0005=\u00121\n\u0005\b\u0003/Y\u0002\u0019AA\r)1\ty%!\u0016\u0002Z\u0005\r\u0014qMA<!\u00159\u0014\u0011KA\u0001\u0013\r\t\u0019\u0006\n\u0002\u0012!\u0006<\u0017N\\1uK\u0012\u0014Vm\u001d9p]N,\u0007bBA,9\u0001\u0007\u0011\u0011D\u0001\fe>dW\rU1ui\u0016\u0014h\u000eC\u0004\u0002\\q\u0001\r!!\u0018\u0002\tA\fw-\u001a\t\u0004c\u0005}\u0013bAA1e\t\u0019\u0011J\u001c;\t\u000f\u0005\u0015D\u00041\u0001\u0002^\u0005!1/\u001b>f\u0011\u001d\tI\u0007\ba\u0001\u0003W\nQa\u001c:eKJ\u0004B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004\u0003c\"\u0013\u0001B;uS2LA!!\u001e\u0002p\tI1k\u001c:u\u001fJ$WM\u001d\u0005\b\u0003sb\u0002\u0019AA\r\u0003\u00151\u0017.\u001a7e\u0003u9W\r^$m_\n\fG\u000eU3s[&\u001c8/[8og\u001a{'OU8mK&#G\u0003BA\u0018\u0003\u007fBq!!!\u001e\u0001\u0004\tI\"\u0001\u0004s_2,\u0017\nZ\u0001!O\u0016$x\t\\8cC2\u0004VM]7jgNLwN\\:G_J\u0004&/\u001b8dSB\fG\u000e\u0006\u0003\u0002\b\u00065\u0005CBA\u000e\u0003\u0013\u000bI\"\u0003\u0003\u0002\f\u0006-\"aA*fi\"9\u0011q\u0012\u0010A\u0002\u0005e\u0011!\u00049sS:\u001c\u0017\u000e]1m\u001d\u0006lW-\u0001\u000fhKR<En\u001c2bYB+'/\\5tg&|gn\u001d$peJ{G.Z:\u0015\t\u0005U\u0015q\u0013\t\u0007\u0003c\tY$!\u0001\t\u000f\u0005eu\u00041\u0001\u00020\u0005I!o\u001c7f\u001d\u0006lWm\u001d\u000b\u0005\u0003+\u000bi\nC\u0004\u0002X\u0001\u0002\r!!\u0007)\u0007\u0001\t\t\u000b\u0005\u0003\u0002$\u0006%VBAAS\u0015\r\t9\u000bQ\u0001\u000bgR,'/Z8usB,\u0017\u0002BAV\u0003K\u0013\u0011bQ8na>tWM\u001c;)\r\u0001\ty+VA_!\u0011\t\t,!/\u000e\u0005\u0005M&b\u0001&\u00026*\u0019\u0011q\u0017!\u0002\u000f\r|g\u000e^3yi&!\u00111XAZ\u0005\u001d\u0001&o\u001c4jY\u0016d#!a0\"\u0005\u0005\u0005\u0017aE\u0011qKJl\u0017n]:j_:l3/\u001a:wS\u000e,\u0007")
public class RemoteGlobalPermissionsServiceClient
implements GlobalPermissionsServiceClient {
    @Autowired
    @Qualifier(value="permissionServiceRestTemplate")
    private final RestTemplate restTemplate;
    private final String permissionServiceUrl;
    private final String globalPermissionsBaseUrl;
    private final String extendedGlobalPermissionsBaseUrl;
    private final String addPermissionsUrl;
    private final String removePermissionsUrl;
    private final String readByRoleUrl;
    private final String read;
    private final String readByRolePattern;
    private final String readForRoles;
    private final String getGlobalPermissionsForRoleIdUrl;
    private final String getGlobalPermissionsForPrincipalNameUrl;

    private String permissionServiceUrl() {
        return this.permissionServiceUrl;
    }

    private String globalPermissionsBaseUrl() {
        return this.globalPermissionsBaseUrl;
    }

    private String extendedGlobalPermissionsBaseUrl() {
        return this.extendedGlobalPermissionsBaseUrl;
    }

    private String addPermissionsUrl() {
        return this.addPermissionsUrl;
    }

    private String removePermissionsUrl() {
        return this.removePermissionsUrl;
    }

    private String readByRoleUrl() {
        return this.readByRoleUrl;
    }

    private String read() {
        return this.read;
    }

    private String readByRolePattern() {
        return this.readByRolePattern;
    }

    private String readForRoles() {
        return this.readForRoles;
    }

    private String getGlobalPermissionsForRoleIdUrl() {
        return this.getGlobalPermissionsForRoleIdUrl;
    }

    private String getGlobalPermissionsForPrincipalNameUrl() {
        return this.getGlobalPermissionsForPrincipalNameUrl;
    }

    @Override
    public RoleWithGlobalPermissionsDto addPermissions(String roleName, List<String> permissions) {
        URI uri = UriComponentsBuilder.fromUriString((String)this.addPermissionsUrl()).build(new Object[]{roleName});
        return (RoleWithGlobalPermissionsDto)this.restTemplate.postForObject(uri, permissions, RoleWithGlobalPermissionsDto.class);
    }

    @Override
    public RoleWithGlobalPermissionsDto removePermissions(String roleName, List<String> permissions) {
        URI uri = UriComponentsBuilder.fromUriString((String)this.removePermissionsUrl()).build(new Object[]{roleName});
        return (RoleWithGlobalPermissionsDto)this.restTemplate.exchange(uri, HttpMethod.DELETE, new HttpEntity((Object)CollectionConverters$.MODULE$.SeqHasAsJava(permissions).asJava()), RoleWithGlobalPermissionsDto.class).getBody();
    }

    @Override
    public List<String> read(String roleName) {
        ParameterizedTypeReference<List<String>> responseType = new ParameterizedTypeReference<List<String>>(null){};
        URI uri = UriComponentsBuilder.fromUriString((String)this.readByRoleUrl()).build(new Object[]{roleName});
        return (List)this.restTemplate.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)responseType).getBody();
    }

    @Override
    public PaginatedResponse<RoleWithGlobalPermissionsDto> read(String rolePattern, int page, int size, SortOrder order, String field) {
        ParameterizedTypeReference<RoleWithGlobalPermissionsDto[]> responseType = new ParameterizedTypeReference<RoleWithGlobalPermissionsDto[]>(null){};
        URI uri = UriComponentsBuilder.fromUriString((String)this.read()).queryParam("rolePattern", new Object[]{rolePattern}).queryParam(Paging$.MODULE$.PAGE_PARAMETER(), new Object[]{BoxesRunTime.boxToInteger((int)page)}).queryParam(Paging$.MODULE$.SIZE_PARAMETER(), new Object[]{BoxesRunTime.boxToInteger((int)size)}).queryParam(Order$.MODULE$.ORDER_PARAMETER(), new Object[]{field + ":" + order.value()}).build().toUri();
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)responseType);
        HttpHeaders headers = response.getHeaders();
        return new PaginatedResponse<RoleWithGlobalPermissionsDto>(Predef$.MODULE$.wrapRefArray((Object[])response.getBody()).toList(), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(headers.getFirst(Paging$.MODULE$.X_TOTAL_COUNT_HEADER()))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(headers.getFirst(Paging$.MODULE$.X_PAGE()))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(headers.getFirst(Paging$.MODULE$.X_SIZE()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(headers.getFirst(Paging$.MODULE$.X_HAS_NEXT_PAGE_HEADER()))));
    }

    @Override
    public List<String> getGlobalPermissionsForRoleId(String roleId) {
        ParameterizedTypeReference<List<String>> responseType = new ParameterizedTypeReference<List<String>>(null){};
        URI uri = UriComponentsBuilder.fromUriString((String)this.getGlobalPermissionsForRoleIdUrl()).buildAndExpand(new Object[]{roleId}).toUri();
        return (List)this.restTemplate.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)responseType).getBody();
    }

    @Override
    public Set<String> getGlobalPermissionsForPrincipal(String principalName) {
        ParameterizedTypeReference<Set<String>> responseType = new ParameterizedTypeReference<Set<String>>(null){};
        URI uri = UriComponentsBuilder.fromUriString((String)this.getGlobalPermissionsForPrincipalNameUrl()).buildAndExpand(new Object[]{principalName}).toUri();
        return (Set)this.restTemplate.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)responseType).getBody();
    }

    @Override
    public List<RoleWithGlobalPermissionsDto> getGlobalPermissionsForRoles(List<String> roleNames) {
        ParameterizedTypeReference<List<RoleWithGlobalPermissionsDto>> responseType = new ParameterizedTypeReference<List<RoleWithGlobalPermissionsDto>>(null){};
        return (List)this.restTemplate.exchange(this.readForRoles(), HttpMethod.GET, new HttpEntity(roleNames), (ParameterizedTypeReference)responseType, new Object[0]).getBody();
    }

    @Override
    public List<RoleWithGlobalPermissionsDto> readByRolePattern(String rolePattern) {
        ParameterizedTypeReference<List<RoleWithGlobalPermissionsDto>> responseType = new ParameterizedTypeReference<List<RoleWithGlobalPermissionsDto>>(null){};
        URI uri = UriComponentsBuilder.fromUriString((String)this.readByRolePattern()).queryParam("rolePattern", new Object[]{rolePattern}).build().toUri();
        return (List)this.restTemplate.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)responseType).getBody();
    }

    public RemoteGlobalPermissionsServiceClient(@Autowired @Qualifier(value="permissionServiceRestTemplate") RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.permissionServiceUrl = ServerConfiguration.getInstance().getExternalPermissionServiceUri();
        this.globalPermissionsBaseUrl = this.permissionServiceUrl() + "/v1/permissions/global";
        this.extendedGlobalPermissionsBaseUrl = this.permissionServiceUrl() + "/v2/permissions/global";
        this.addPermissionsUrl = this.globalPermissionsBaseUrl() + "/{roleName}";
        this.removePermissionsUrl = this.globalPermissionsBaseUrl() + "/{roleName}";
        this.readByRoleUrl = this.globalPermissionsBaseUrl() + "/{roleName}";
        this.read = this.globalPermissionsBaseUrl();
        this.readByRolePattern = this.globalPermissionsBaseUrl() + "/filter";
        this.readForRoles = this.globalPermissionsBaseUrl() + "/roles";
        this.getGlobalPermissionsForRoleIdUrl = this.extendedGlobalPermissionsBaseUrl() + "/{roleId}";
        this.getGlobalPermissionsForPrincipalNameUrl = this.extendedGlobalPermissionsBaseUrl() + "/principal/{principalName}";
    }
}

