/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render.displaylist;

import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.PaintingInfo;
import com.openhtmltopdf.newtable.TableBox;
import com.openhtmltopdf.newtable.TableCellBox;
import com.openhtmltopdf.newtable.TableSectionBox;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.DisplayListItem;
import com.openhtmltopdf.render.InlineLayoutBox;
import com.openhtmltopdf.render.LineBox;
import com.openhtmltopdf.render.OperatorClip;
import com.openhtmltopdf.render.OperatorSetClip;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PagedBoxCollector {
    private final List<PageResult> result;
    private final List<PageBox> pages;
    private final PageFinder finder;
    private final int startPage;
    public static final int PAGE_BASE_ONLY = -1;
    public static final int PAGE_ALL = -2;

    public PagedBoxCollector(List<PageBox> pages, int minPage, int maxPage) {
        this.pages = pages;
        this.result = new ArrayList<PageResult>(maxPage - minPage + 1);
        this.finder = new PageFinder(pages);
        this.startPage = minPage;
        for (int i = minPage; i <= maxPage; ++i) {
            this.result.add(new PageResult());
        }
    }

    public void collect(CssContext c, Layer layer) {
        if (layer.isInline()) {
            this.collectInline(c, layer);
        } else {
            this.collect(c, layer, layer.getMaster(), -2);
        }
    }

    private void collectInline(CssContext c, Layer layer) {
        InlineLayoutBox iB = (InlineLayoutBox)layer.getMaster();
        List<Box> content = iB.getElementWithContent();
        for (Box b : content) {
            int pgStart = this.findStartPage(c, b, layer.getCurrentTransformMatrix());
            int pgEnd = this.findEndPage(c, b, layer.getCurrentTransformMatrix());
            for (int i = pgStart; i <= pgEnd; ++i) {
                Rectangle pageClip = this.getPageResult(i).getContentWindowOnDocument(this.getPageBox(i), c);
                if (!b.intersects(c, pageClip)) continue;
                if (b instanceof InlineLayoutBox) {
                    this.getPageResult(i).addInline(b);
                    continue;
                }
                BlockBox bb = (BlockBox)b;
                if (bb.isInline()) {
                    if (!this.intersectsAny(c, pageClip, b, b)) continue;
                    this.getPageResult(i).addInline(b);
                    continue;
                }
                this.collect(c, layer, bb, -2);
            }
        }
    }

    public void collectFloats(CssContext c, Layer layer) {
        for (int iflt = layer.getFloats().size() - 1; iflt >= 0; --iflt) {
            BlockBox floater = layer.getFloats().get(iflt);
            int pgStart = this.findStartPage(c, floater, layer.getCurrentTransformMatrix());
            int pgEnd = this.findEndPage(c, floater, layer.getCurrentTransformMatrix());
            for (int i = this.getValidMinPageNumber(pgStart); i <= this.getValidMaxPageNumber(pgEnd); ++i) {
                PageBox pageBox;
                PageResult pgRes = this.getPageResult(i);
                if (this.intersectsAggregateBounds(c, pgRes.getContentWindowOnDocument(pageBox = this.getPageBox(i), c), floater)) {
                    pgRes.addFloat(floater);
                }
                if (!pageBox.shouldInsertPages()) continue;
                this.addBoxToShadowPages(c, floater, i, pgRes, null, null, layer, AddFloatToShadowPage.INSTANCE);
            }
        }
    }

    public void collect(CssContext c, Layer layer, Box container, int shadowPageNumber) {
        int pgEnd;
        int pgStart;
        if (container instanceof BlockBox) {
            Rectangle bounds = container.getBorderBox(c);
            pgStart = this.findStartPage(c, bounds, layer.getCurrentTransformMatrix());
            pgEnd = this.findEndPage(c, bounds, layer.getCurrentTransformMatrix());
        } else {
            pgStart = this.findStartPage(c, container, layer.getCurrentTransformMatrix());
            pgEnd = this.findEndPage(c, container, layer.getCurrentTransformMatrix());
        }
        this.collect(c, layer, container, pgStart, pgEnd, shadowPageNumber);
    }

    public void collect(CssContext c, Layer layer, Box container, int pgStart, int pgEnd, int shadowPageNumber) {
        block16: {
            block15: {
                if (layer != container.getContainingLayer()) {
                    return;
                }
                if (!(container instanceof LineBox)) break block15;
                for (int i = this.getValidMinPageNumber(pgStart); i <= this.getValidMaxPageNumber(pgEnd); ++i) {
                    if (shadowPageNumber == -2) {
                        this.addLineBoxToAll(c, layer, (LineBox)container, i, true);
                        continue;
                    }
                    if (shadowPageNumber == -1) {
                        this.addLineBoxToAll(c, layer, (LineBox)container, i, false);
                        continue;
                    }
                    this.addLineBoxToShadowPage(c, layer, (LineBox)container, i, shadowPageNumber);
                }
                break block16;
            }
            Rectangle ourClip = null;
            ArrayList clipPages = null;
            if (container.getLayer() == null || layer.getMaster() == container || !(container instanceof BlockBox)) {
                BlockBox block;
                if (c instanceof RenderingContext && container instanceof BlockBox && (block = (BlockBox)container).isNeedsClipOnPaint(c)) {
                    ourClip = block.getChildrenClipEdge(c);
                    clipPages = new ArrayList();
                }
                if (shadowPageNumber == -2) {
                    this.addBlockToAll(c, layer, container, pgStart, pgEnd, ourClip, clipPages, true);
                } else if (shadowPageNumber == -1) {
                    this.addBlockToAll(c, layer, container, pgStart, pgEnd, ourClip, clipPages, false);
                } else {
                    this.addBlockToShadowPage(c, layer, container, pgStart, pgEnd, ourClip, clipPages, shadowPageNumber);
                }
            }
            if (container instanceof TableSectionBox && (((TableSectionBox)container).isHeader() || ((TableSectionBox)container).isFooter()) && ((TableSectionBox)container).getTable().hasContentLimitContainer() && (container.getLayer() == null || container == layer.getMaster()) && c instanceof RenderingContext) {
                this.addTableHeaderFooter(c, layer, container, shadowPageNumber);
            } else if (container.getLayer() == null || container == layer.getMaster()) {
                for (int i = 0; i < container.getChildCount(); ++i) {
                    Box child = container.getChild(i);
                    this.collect(c, layer, child, shadowPageNumber);
                }
            }
            if (clipPages == null) break block16;
            for (PageResult pgRes : clipPages) {
                pgRes.setClipAll(new OperatorSetClip(null));
            }
        }
    }

    private void addBlockToAll(CssContext c, Layer layer, Box container, int pgStart, int pgEnd, Shape ourClip, List<PageResult> clipPages, boolean includeShadowPages) {
        for (int i = this.getValidMinPageNumber(pgStart); i <= this.getValidMaxPageNumber(pgEnd); ++i) {
            PageBox pageBox;
            PageResult pageResult = this.getPageResult(i);
            Rectangle pageClip = pageResult.getContentWindowOnDocument(pageBox = this.getPageBox(i), c);
            if (this.intersectsBorderBoxBounds(c, pageClip, container)) {
                this.addBlock(container, pageResult);
                if (ourClip != null) {
                    pageResult.clipAll(new OperatorClip(ourClip));
                    clipPages.add(pageResult);
                }
            }
            if (!includeShadowPages || !pageBox.shouldInsertPages()) continue;
            this.addBoxToShadowPages(c, container, i, pageResult, ourClip, clipPages, layer, AddBlockToShadowPage.INSTANCE);
        }
    }

    private void addBlockToShadowPage(CssContext c, Layer layer, Box container, int pgStart, int pgEnd, Shape ourClip, List<PageResult> clipPages, int shadowPageNumber) {
        for (int i = this.getValidMinPageNumber(pgStart); i <= this.getValidMaxPageNumber(pgEnd); ++i) {
            PageBox pageBox;
            PageResult pageResult = this.getPageResult(i);
            Rectangle shadowPageClip = pageResult.getShadowWindowOnDocument(pageBox = this.getPageBox(i), c, shadowPageNumber);
            if (!this.intersectsBorderBoxBounds(c, shadowPageClip, container)) continue;
            PageResult shadowPageResult = this.getOrCreateShadowPage(pageResult, shadowPageNumber);
            this.addBlock(container, shadowPageResult);
            if (ourClip == null) continue;
            shadowPageResult.clipAll(new OperatorClip(ourClip));
            clipPages.add(shadowPageResult);
        }
    }

    private void addLineBoxToShadowPage(CssContext c, Layer layer, LineBox container, int basePageNumber, int shadowPageNumber) {
        PageBox pageBox;
        PageResult pageResult = this.getPageResult(basePageNumber);
        Rectangle shadowPageClip = pageResult.getShadowWindowOnDocument(pageBox = this.getPageBox(basePageNumber), c, shadowPageNumber);
        if (this.intersectsAggregateBounds(c, shadowPageClip, container)) {
            PageResult shadowPageResult = this.getOrCreateShadowPage(pageResult, shadowPageNumber);
            shadowPageResult.addInline(container);
            container.addAllChildren(shadowPageResult._inlines, layer);
        }
    }

    private void addLineBoxToAll(CssContext c, Layer layer, LineBox container, int basePageNumber, boolean includeShadowPages) {
        PageBox pageBox;
        PageResult pageResult = this.getPageResult(basePageNumber);
        Rectangle pageClip = pageResult.getContentWindowOnDocument(pageBox = this.getPageBox(basePageNumber), c);
        if (this.intersectsAggregateBounds(c, pageClip, container)) {
            pageResult.addInline(container);
            container.addAllChildren(pageResult._inlines, layer);
        }
        if (includeShadowPages && pageBox.shouldInsertPages()) {
            this.addBoxToShadowPages(c, container, basePageNumber, pageResult, null, null, layer, AddInlineToShadowPage.INSTANCE);
        }
    }

    private PageResult getOrCreateShadowPage(PageResult basePage, int shadowPageNumber) {
        while (shadowPageNumber >= basePage.shadowPages().size()) {
            basePage.addShadowPage(new PageResult());
        }
        return basePage.shadowPages().get(shadowPageNumber);
    }

    private void addBoxToShadowPages(CssContext c, Box container, int pageNumber, PageResult pageResult, Shape ourClip, List<PageResult> clipPages, Layer layer, AddToShadowPage addToMethod) {
        int maxShadowPages;
        FourPoint corners;
        PageBox basePageBox = this.getPageBox(pageNumber);
        AffineTransform ctm = container.getContainingLayer().getCurrentTransformMatrix();
        Rectangle bounds = container.getBorderBox(c);
        FourPoint fourPoint = corners = ctm == null ? null : PagedBoxCollector.getCornersFromTransformedBounds(bounds, ctm);
        if (basePageBox.getCutOffPageDirection() == IdentValue.LTR) {
            int maxX = (int)(ctm == null ? bounds.getMaxX() : PagedBoxCollector.getMaxX(corners));
            maxShadowPages = Math.min(basePageBox.getMaxInsertedPages(), basePageBox.getMaxShadowPagesForXPos(c, maxX));
        } else {
            int minX = (int)(ctm == null ? bounds.getMinX() : PagedBoxCollector.getMinX(corners));
            maxShadowPages = Math.min(basePageBox.getMaxInsertedPages(), basePageBox.getMaxShadowPagesForXPos(c, minX));
        }
        for (int i = 0; i < maxShadowPages; ++i) {
            PageResult shadowPageResult;
            boolean intersects;
            Rectangle shadowPageClip = pageResult.getShadowWindowOnDocument(basePageBox, c, i);
            boolean bl = intersects = addToMethod.boundsBox() == 2 ? this.intersectsAggregateBounds(c, shadowPageClip, container) : this.intersectsBorderBoxBounds(c, shadowPageClip, container);
            if (!intersects || !addToMethod.add(this, shadowPageResult = this.getOrCreateShadowPage(pageResult, i), container, ourClip, layer)) continue;
            clipPages.add(shadowPageResult);
        }
    }

    private void addTableHeaderFooter(CssContext c, Layer layer, Box container, int shadowPageNumber) {
        TableBox table = ((TableSectionBox)container).getTable();
        RenderingContext rc = (RenderingContext)c;
        int tableStart = this.findStartPage(c, table, layer.getCurrentTransformMatrix());
        int tableEnd = this.findEndPage(c, table, layer.getCurrentTransformMatrix());
        for (int pgTable = this.getValidMinPageNumber(tableStart); pgTable <= this.getValidMaxPageNumber(tableEnd); ++pgTable) {
            rc.setPage(pgTable, this.getPageBox(pgTable));
            table.updateHeaderFooterPosition(rc);
            for (int i = 0; i < container.getChildCount(); ++i) {
                Box child = container.getChild(i);
                this.collect(c, layer, child, shadowPageNumber);
            }
        }
    }

    private void addBlock(Box container, PageResult pageResult) {
        pageResult.addBlock(container);
        if (container instanceof BlockBox) {
            BlockBox block = (BlockBox)container;
            if (block.getReplacedElement() != null) {
                pageResult.addReplaced(block);
            }
            if (block.isListItem()) {
                pageResult.addListItem(block);
            }
        }
        if (container instanceof TableCellBox && ((TableCellBox)container).hasCollapsedPaintingBorder()) {
            pageResult.addTableCell((TableCellBox)container);
        }
    }

    private boolean intersectsAggregateBounds(CssContext c, Shape clip, Box box) {
        if (clip == null) {
            return true;
        }
        PaintingInfo info = box.getPaintingInfo();
        if (info == null) {
            return false;
        }
        Rectangle bounds = info.getAggregateBounds();
        return this.boxIntersects(c, clip, box, bounds);
    }

    private boolean intersectsBorderBoxBounds(CssContext c, Shape clip, Box box) {
        Rectangle borderBoxBounds = box.getBorderBox(c);
        return this.boxIntersects(c, clip, box, borderBoxBounds);
    }

    private boolean boxIntersects(CssContext c, Shape clip, Box box, Rectangle boxBounds) {
        AffineTransform ctm = box.getContainingLayer().getCurrentTransformMatrix();
        Area overflowClip = box.getAbsoluteClipBox(c);
        if (ctm == null && overflowClip == null) {
            return clip.intersects(boxBounds);
        }
        if (ctm != null && overflowClip == null) {
            Shape boxShape = ctm.createTransformedShape(boxBounds);
            Area boxArea = new Area(boxShape);
            Area clipArea = new Area(clip);
            boxArea.intersect(clipArea);
            return !boxArea.isEmpty();
        }
        Area boxArea = new Area(ctm == null ? boxBounds : ctm.createTransformedShape(boxBounds));
        boxArea.intersect(overflowClip);
        boxArea.intersect(new Area(clip));
        return !boxArea.isEmpty();
    }

    private boolean intersectsAny(CssContext c, Shape clip, Box master, Box container) {
        if (container instanceof LineBox) {
            if (container.intersects(c, clip)) {
                return true;
            }
        } else {
            if ((container.getLayer() == null || !(container instanceof BlockBox)) && container.intersects(c, clip)) {
                return true;
            }
            if (container.getLayer() == null || container == master) {
                for (int i = 0; i < container.getChildCount(); ++i) {
                    Box child = container.getChild(i);
                    boolean possibleResult = this.intersectsAny(c, clip, master, child);
                    if (!possibleResult) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static FourPoint getCornersFromTransformedBounds(Rectangle bounds, AffineTransform transform) {
        Point2D.Double ul = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
        Point2D.Double ur = new Point2D.Double(bounds.getMaxX(), bounds.getMinY());
        Point2D.Double ll = new Point2D.Double(bounds.getMinX(), bounds.getMaxY());
        Point2D.Double lr = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
        Point2D ult = transform.transform(ul, null);
        Point2D urt = transform.transform(ur, null);
        Point2D llt = transform.transform(ll, null);
        Point2D lrt = transform.transform(lr, null);
        return new FourPoint(ult, urt, llt, lrt);
    }

    private static double getMinYFromTransformedBox(Rectangle bounds, AffineTransform transform) {
        FourPoint corners = PagedBoxCollector.getCornersFromTransformedBounds(bounds, transform);
        double minY = Math.min(corners.ul.getY(), corners.ur.getY());
        minY = Math.min(corners.ll.getY(), minY);
        minY = Math.min(corners.lr.getY(), minY);
        return minY;
    }

    private static double getMaxYFromTransformedBox(Rectangle bounds, AffineTransform transform) {
        FourPoint corners = PagedBoxCollector.getCornersFromTransformedBounds(bounds, transform);
        double maxY = Math.max(corners.ul.getY(), corners.ur.getY());
        maxY = Math.max(corners.ll.getY(), maxY);
        maxY = Math.max(corners.lr.getY(), maxY);
        return maxY;
    }

    private static double getMaxXFromTransformedBox(Rectangle bounds, AffineTransform transform) {
        FourPoint corners = PagedBoxCollector.getCornersFromTransformedBounds(bounds, transform);
        double maxX = Math.max(corners.ul.getX(), corners.ur.getX());
        maxX = Math.max(corners.ll.getX(), maxX);
        maxX = Math.max(corners.lr.getX(), maxX);
        return maxX;
    }

    public static int findPageForY(CssContext c, double y, List<PageBox> pages) {
        PageFinder finder = new PageFinder(pages);
        return finder.findPageAdjusted(c, (int)y);
    }

    public static int getShadowPageForBounds(CssContext c, Rectangle bounds, PageBox page) {
        if (!page.shouldInsertPages()) {
            return -1;
        }
        if (page.getCutOffPageDirection() == IdentValue.LTR) {
            int minXShadowPage = page.getMaxShadowPagesForXPos(c, (int)bounds.getMinX());
            return Math.min(minXShadowPage - 1, page.getMaxInsertedPages());
        }
        int maxXShadowPage = page.getMaxShadowPagesForXPos(c, (int)bounds.getMaxX());
        return Math.min(maxXShadowPage, page.getMaxInsertedPages());
    }

    public static Rectangle findAdjustedBoundsForBorderBox(CssContext c, Box container, List<PageBox> pages) {
        Rectangle bounds = container.getBorderBox(c);
        AffineTransform transform = container.getContainingLayer().getCurrentTransformMatrix();
        Area overflowClip = container.getAbsoluteClipBox(c);
        PagedBoxCollector.transformBounds(bounds, transform);
        bounds = PagedBoxCollector.applyOverflowClip(bounds, overflowClip);
        return bounds;
    }

    public static Rectangle findAdjustedBoundsForContentBox(CssContext c, Box container) {
        Rectangle bounds = container.getContentAreaEdge(container.getAbsX(), container.getAbsY(), c);
        AffineTransform transform = container.getContainingLayer().getCurrentTransformMatrix();
        Area overflowClip = container.getAbsoluteClipBox(c);
        PagedBoxCollector.transformBounds(bounds, transform);
        bounds = PagedBoxCollector.applyOverflowClip(bounds, overflowClip);
        return bounds;
    }

    protected int findStartPage(CssContext c, Rectangle bounds, AffineTransform transform) {
        double minY = transform == null ? bounds.getMinY() : PagedBoxCollector.getMinYFromTransformedBox(bounds, transform);
        return this.finder.findPageAdjusted(c, (int)minY);
    }

    protected int findEndPage(CssContext c, Rectangle bounds, AffineTransform transform) {
        double maxY = transform == null ? bounds.getMaxY() : PagedBoxCollector.getMaxYFromTransformedBox(bounds, transform);
        return this.finder.findPageAdjusted(c, (int)maxY);
    }

    protected int findStartPage(CssContext c, Box container, AffineTransform transform) {
        PaintingInfo info = container.calcPaintingInfo(c, true);
        if (info == null) {
            return -1;
        }
        Rectangle bounds = info.getAggregateBounds();
        if (bounds == null) {
            return -1;
        }
        double minY = transform == null ? bounds.getMinY() : PagedBoxCollector.getMinYFromTransformedBox(bounds, transform);
        return this.finder.findPageAdjusted(c, (int)minY);
    }

    protected int findEndPage(CssContext c, Box container, AffineTransform transform) {
        PaintingInfo info = container.calcPaintingInfo(c, true);
        if (info == null) {
            return -1;
        }
        Rectangle bounds = info.getAggregateBounds();
        if (bounds == null) {
            return -1;
        }
        double maxY = transform == null ? bounds.getMaxY() : PagedBoxCollector.getMaxYFromTransformedBox(bounds, transform);
        return this.finder.findPageAdjusted(c, (int)maxY);
    }

    protected PageResult getPageResult(int pageNo) {
        return this.result.get(pageNo - this.startPage);
    }

    protected int getMaxPageNumber() {
        return this.startPage + this.result.size() - 1;
    }

    protected int getMinPageNumber() {
        return this.startPage;
    }

    protected int getValidMinPageNumber(int pageNo) {
        return Math.max(pageNo, this.getMinPageNumber());
    }

    protected int getValidMaxPageNumber(int pageNo) {
        return Math.min(pageNo, this.getMaxPageNumber());
    }

    protected PageBox getPageBox(int pageNo) {
        return this.pages.get(pageNo);
    }

    private static Rectangle getBoxRect(CssContext c, Box container) {
        PaintingInfo info = container.calcPaintingInfo(c, true);
        Rectangle bounds = info.getAggregateBounds();
        return bounds;
    }

    public static Rectangle findLayerRect(CssContext c, Layer layer) {
        Box container = layer.getMaster();
        Rectangle bounds = PagedBoxCollector.getBoxRect(c, container);
        for (BlockBox floater : layer.getFloats()) {
            Rectangle fBounds = PagedBoxCollector.getBoxRect(c, floater);
            bounds.add(fBounds);
        }
        return bounds;
    }

    private static double getMinY(FourPoint corners) {
        double minY = Math.min(corners.ul.getY(), corners.ur.getY());
        minY = Math.min(corners.ll.getY(), minY);
        minY = Math.min(corners.lr.getY(), minY);
        return minY;
    }

    private static double getMinX(FourPoint corners) {
        double minX = Math.min(corners.ul.getX(), corners.ur.getX());
        minX = Math.min(corners.ll.getX(), minX);
        minX = Math.min(corners.lr.getX(), minX);
        return minX;
    }

    private static double getMaxY(FourPoint corners) {
        double maxY = Math.max(corners.ul.getY(), corners.ur.getY());
        maxY = Math.max(corners.ll.getY(), maxY);
        maxY = Math.max(corners.lr.getY(), maxY);
        return maxY;
    }

    private static double getMaxX(FourPoint corners) {
        double maxX = Math.max(corners.ul.getX(), corners.ur.getX());
        maxX = Math.max(corners.ll.getX(), maxX);
        maxX = Math.max(corners.lr.getX(), maxX);
        return maxX;
    }

    private static void transformBounds(Rectangle bounds, AffineTransform transform) {
        if (transform != null) {
            FourPoint corners = PagedBoxCollector.getCornersFromTransformedBounds(bounds, transform);
            double minX = PagedBoxCollector.getMinX(corners);
            double minY = PagedBoxCollector.getMinY(corners);
            double maxX = PagedBoxCollector.getMaxX(corners);
            double maxY = PagedBoxCollector.getMaxY(corners);
            bounds.setBounds((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
        }
    }

    private static Rectangle applyOverflowClip(Rectangle bounds, Area overflowClip) {
        if (overflowClip != null) {
            Area boxArea = new Area(bounds);
            boxArea.intersect(overflowClip);
            return boxArea.getBounds();
        }
        return bounds;
    }

    public static List<PageInfo> findLayerPages(CssContext c, Layer layer, List<PageBox> pages) {
        PageFinder finder = new PageFinder(pages);
        Rectangle bounds = PagedBoxCollector.findLayerRect(c, layer);
        Box container = layer.getMaster();
        AffineTransform transform = container.getContainingLayer().getCurrentTransformMatrix();
        Area overflowClip = container.getAbsoluteClipBox(c);
        PagedBoxCollector.transformBounds(bounds, transform);
        bounds = PagedBoxCollector.applyOverflowClip(bounds, overflowClip);
        int firstPage = finder.findPageAdjusted(c, (int)bounds.getMinY());
        int lastPage = finder.findPageAdjusted(c, (int)bounds.getMaxY());
        ArrayList<PageInfo> result = new ArrayList<PageInfo>();
        for (int i = firstPage; i <= lastPage; ++i) {
            result.add(new PageInfo(i, -1));
            if (!pages.get(i).shouldInsertPages()) continue;
            int maxXShadowPage = pages.get(i).getMaxShadowPagesForXPos(c, (int)bounds.getMaxX());
            int minXShadowPage = pages.get(i).getMaxShadowPagesForXPos(c, (int)bounds.getMinX());
            int shadowPageCount = Math.max(maxXShadowPage, minXShadowPage);
            shadowPageCount = Math.min(shadowPageCount, pages.get(i).getMaxInsertedPages());
            for (int j = 0; j < shadowPageCount; ++j) {
                result.add(new PageInfo(i, j));
            }
        }
        return result;
    }

    public static int findStartPage(CssContext c, Box container, List<PageBox> pages) {
        PageFinder finder = new PageFinder(pages);
        PaintingInfo info = container.calcPaintingInfo(c, true);
        Rectangle bounds = info.getAggregateBounds();
        AffineTransform transform = container.getContainingLayer().getCurrentTransformMatrix();
        double minY = transform == null ? bounds.getMinY() : PagedBoxCollector.getMinYFromTransformedBox(bounds, transform);
        return finder.findPageAdjusted(c, (int)minY);
    }

    public static int findEndPage(CssContext c, Box container, List<PageBox> pages) {
        PageFinder finder = new PageFinder(pages);
        PaintingInfo info = container.calcPaintingInfo(c, true);
        Rectangle bounds = info.getAggregateBounds();
        AffineTransform transform = container.getContainingLayer().getCurrentTransformMatrix();
        double maxY = transform == null ? bounds.getMaxY() : PagedBoxCollector.getMaxYFromTransformedBox(bounds, transform);
        return finder.findPageAdjusted(c, (int)maxY);
    }

    public static class PageInfo {
        public static final int BASE_PAGE = -1;
        public final int pageNumber;
        public final int shadowPageNumber;

        private PageInfo(int pgNumber, int shadowPgNumber) {
            this.pageNumber = pgNumber;
            this.shadowPageNumber = shadowPgNumber;
        }
    }

    private static class FourPoint {
        private final Point2D ul;
        private final Point2D ur;
        private final Point2D ll;
        private final Point2D lr;

        private FourPoint(Point2D ul, Point2D ur, Point2D ll, Point2D lr) {
            this.ul = ul;
            this.ur = ur;
            this.ll = ll;
            this.lr = lr;
        }
    }

    private static class AddFloatToShadowPage
    implements AddToShadowPage {
        private static final AddToShadowPage INSTANCE = new AddFloatToShadowPage();

        private AddFloatToShadowPage() {
        }

        @Override
        public int boundsBox() {
            return 1;
        }

        @Override
        public boolean add(PagedBoxCollector collector, PageResult shadowPageResult, Box container, Shape clip, Layer layer) {
            shadowPageResult.addFloat((BlockBox)container);
            return false;
        }
    }

    private static class AddInlineToShadowPage
    implements AddToShadowPage {
        private static final AddToShadowPage INSTANCE = new AddInlineToShadowPage();

        private AddInlineToShadowPage() {
        }

        @Override
        public int boundsBox() {
            return 2;
        }

        @Override
        public boolean add(PagedBoxCollector collector, PageResult shadowPageResult, Box container, Shape clip, Layer layer) {
            shadowPageResult.addInline(container);
            ((LineBox)container).addAllChildren(shadowPageResult._inlines, layer);
            return false;
        }
    }

    private static class AddBlockToShadowPage
    implements AddToShadowPage {
        private static final AddToShadowPage INSTANCE = new AddBlockToShadowPage();

        private AddBlockToShadowPage() {
        }

        @Override
        public int boundsBox() {
            return 1;
        }

        @Override
        public boolean add(PagedBoxCollector collector, PageResult shadowPageResult, Box container, Shape clip, Layer layer) {
            collector.addBlock(container, shadowPageResult);
            if (clip != null) {
                shadowPageResult.clipAll(new OperatorClip(clip));
                return true;
            }
            return false;
        }
    }

    private static interface AddToShadowPage {
        public static final int BORDER_BOX = 1;
        public static final int AGGREGATE_BOX = 2;

        public int boundsBox();

        public boolean add(PagedBoxCollector var1, PageResult var2, Box var3, Shape var4, Layer var5);
    }

    public static class PageFinder {
        private int lastRequested = 0;
        private final List<PageBox> pages;
        private static final int PAGE_BEFORE_START = -1;
        private static final int PAGE_AFTER_END = -2;

        public PageFinder(List<PageBox> pages) {
            this.pages = pages;
        }

        public int findPageAdjusted(CssContext c, int yOffset) {
            int pg = this.findPage(c, yOffset);
            if (pg == -1) {
                return 0;
            }
            if (pg == -2) {
                return this.pages.size() - 1;
            }
            return pg;
        }

        private int findPage(CssContext c, int yOffset) {
            if (yOffset < 0) {
                return -1;
            }
            PageBox lastRequest = this.pages.get(this.lastRequested);
            if (yOffset >= lastRequest.getTop() && yOffset < lastRequest.getBottom()) {
                return this.lastRequested;
            }
            PageBox last = this.pages.get(this.pages.size() - 1);
            if (yOffset >= last.getTop() && yOffset < last.getBottom()) {
                this.lastRequested = this.pages.size() - 1;
                return this.lastRequested;
            }
            if (yOffset < last.getBottom()) {
                int count = this.pages.size();
                for (int i = count - 1; i >= 0 && i >= count - 5; --i) {
                    PageBox pageBox = this.pages.get(i);
                    if (yOffset < pageBox.getTop() || yOffset >= pageBox.getBottom()) continue;
                    this.lastRequested = i;
                    return i;
                }
                int low = 0;
                int high = count - 6;
                while (low <= high) {
                    int mid = low + high >> 1;
                    PageBox pageBox = this.pages.get(mid);
                    if (yOffset >= pageBox.getTop() && yOffset < pageBox.getBottom()) {
                        this.lastRequested = mid;
                        return mid;
                    }
                    if (pageBox.getTop() < yOffset) {
                        low = mid + 1;
                        continue;
                    }
                    high = mid - 1;
                }
            } else {
                return -2;
            }
            return -1;
        }
    }

    public static class PageResult {
        private List<DisplayListItem> _blocks = null;
        private List<DisplayListItem> _inlines = null;
        private List<TableCellBox> _tcells = null;
        private List<DisplayListItem> _replaceds = null;
        private List<DisplayListItem> _listItems = null;
        private List<BlockBox> _floats = null;
        private List<PageResult> _shadowPages = null;
        private boolean _hasListItems = false;
        private boolean _hasReplaceds = false;
        private Rectangle _contentWindowOnDocument = null;
        private Rectangle _firstShadowPageContentWindowOnDocument = null;

        private void addShadowPage(PageResult shadowPage) {
            if (this._shadowPages == null) {
                this._shadowPages = new ArrayList<PageResult>();
            }
            this._shadowPages.add(shadowPage);
        }

        private void addFloat(BlockBox floater) {
            if (this._floats == null) {
                this._floats = new ArrayList<BlockBox>();
            }
            this._floats.add(floater);
        }

        private void addBlock(DisplayListItem block) {
            if (this._blocks == null) {
                this._blocks = new ArrayList<DisplayListItem>();
            }
            this._blocks.add(block);
        }

        private void addInline(DisplayListItem inline) {
            if (this._inlines == null) {
                this._inlines = new ArrayList<DisplayListItem>();
            }
            this._inlines.add(inline);
        }

        private void addTableCell(TableCellBox tcell) {
            if (this._tcells == null) {
                this._tcells = new ArrayList<TableCellBox>();
            }
            this._tcells.add(tcell);
        }

        private void addReplaced(DisplayListItem replaced) {
            if (this._replaceds == null) {
                this._replaceds = new ArrayList<DisplayListItem>();
            }
            this._replaceds.add(replaced);
            if (!(replaced instanceof OperatorClip) && !(replaced instanceof OperatorSetClip)) {
                this._hasReplaceds = true;
            }
        }

        private void addListItem(DisplayListItem listItem) {
            if (this._listItems == null) {
                this._listItems = new ArrayList<DisplayListItem>();
            }
            this._listItems.add(listItem);
            if (!(listItem instanceof OperatorClip) && !(listItem instanceof OperatorSetClip)) {
                this._hasListItems = true;
            }
        }

        private void clipAll(OperatorClip dli) {
            this.addBlock(dli);
            this.addInline(dli);
            this.addReplaced(dli);
            this.addListItem(dli);
        }

        private void setClipAll(OperatorSetClip dli) {
            this.addBlock(dli);
            this.addInline(dli);
            this.addReplaced(dli);
            this.addListItem(dli);
        }

        public List<BlockBox> floats() {
            return this._floats == null ? Collections.emptyList() : this._floats;
        }

        public List<DisplayListItem> blocks() {
            return this._blocks == null ? Collections.emptyList() : this._blocks;
        }

        public List<DisplayListItem> inlines() {
            return this._inlines == null ? Collections.emptyList() : this._inlines;
        }

        public List<TableCellBox> tcells() {
            return this._tcells == null ? Collections.emptyList() : this._tcells;
        }

        public List<DisplayListItem> replaceds() {
            return this._hasReplaceds ? this._replaceds : Collections.emptyList();
        }

        public List<DisplayListItem> listItems() {
            return this._hasListItems ? this._listItems : Collections.emptyList();
        }

        public List<PageResult> shadowPages() {
            return this._shadowPages == null ? Collections.emptyList() : this._shadowPages;
        }

        public boolean hasShadowPage(int shadow) {
            return this._shadowPages != null && shadow < this._shadowPages.size();
        }

        private Rectangle getContentWindowOnDocument(PageBox page, CssContext c) {
            if (this._contentWindowOnDocument == null) {
                this._contentWindowOnDocument = page.getDocumentCoordinatesContentBounds(c);
            }
            return this._contentWindowOnDocument;
        }

        public Rectangle getShadowWindowOnDocument(PageBox page, CssContext c, int shadowPageNumber) {
            if (shadowPageNumber == 0 && this._firstShadowPageContentWindowOnDocument == null) {
                this._firstShadowPageContentWindowOnDocument = page.getDocumentCoordinatesContentBoundsForInsertedPage(c, shadowPageNumber);
                return this._firstShadowPageContentWindowOnDocument;
            }
            if (shadowPageNumber == 0) {
                return this._firstShadowPageContentWindowOnDocument;
            }
            return page.getDocumentCoordinatesContentBoundsForInsertedPage(c, shadowPageNumber);
        }
    }
}

