/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.booter.remote.execution.RemoteStepState;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.xltype.serialization.util.DateUtil;
import com.xebialabs.xltype.serialization.xstream.AbstractStepConverter;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import java.util.ArrayList;

@XStreamProvider(readable=StepState.class, tagName="step")
public class StepConverter
extends AbstractStepConverter {
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RemoteStepState s = new RemoteStepState();
        if (reader.getAttribute("failures") != null) {
            s.setFailureCount(Integer.parseInt(reader.getAttribute("failures")));
        }
        if (reader.getAttribute("skippable") != null) {
            s.setSkippable(Boolean.parseBoolean(reader.getAttribute("skippable")));
        }
        s.setState(StepExecutionState.valueOf((String)reader.getAttribute("state")));
        String attrDescription = reader.getAttribute("description");
        if (attrDescription != null) {
            s.setDescription(attrDescription);
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("description".equals(reader.getNodeName())) {
                s.setDescription(reader.getValue());
            } else if ("startDate".equals(reader.getNodeName())) {
                s.setStartDate(DateUtil.fromString((String)reader.getValue()));
            } else if ("completionDate".equals(reader.getNodeName())) {
                s.setCompletionDate(DateUtil.fromString((String)reader.getValue()));
            } else if ("previousAttemptsLogs".equals(reader.getNodeName())) {
                ArrayList<String> logs = new ArrayList<String>();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    String nodeName = reader.getNodeName();
                    String content = reader.getValue();
                    if (nodeName.equals("log")) {
                        logs.add(content);
                    }
                    reader.moveUp();
                }
                s.setPreviousAttemptsLogs(logs);
            } else if ("log".equals(reader.getNodeName())) {
                s.setLog(reader.getValue());
            } else if ("metadata".equals(reader.getNodeName())) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    s.getMetadata().put(reader.getNodeName(), reader.getValue());
                    reader.moveUp();
                }
            }
            reader.moveUp();
        }
        return s;
    }
}

