/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi;

import jakarta.persistence.Basic;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import jakarta.persistence.metamodel.Type;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;

public class DefaultEnhancementContext
implements EnhancementContext {
    private final ConcurrentHashMap<String, Type.PersistenceType> discoveredTypes = new ConcurrentHashMap();

    @Override
    public ClassLoader getLoadingClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public boolean isEntityClass(UnloadedClass classDescriptor) {
        return classDescriptor.hasAnnotation(Entity.class);
    }

    @Override
    public boolean isCompositeClass(UnloadedClass classDescriptor) {
        return classDescriptor.hasAnnotation(Embeddable.class) || this.discoveredTypes.get(classDescriptor.getName()) == Type.PersistenceType.EMBEDDABLE;
    }

    @Override
    public boolean isMappedSuperclassClass(UnloadedClass classDescriptor) {
        return classDescriptor.hasAnnotation(MappedSuperclass.class);
    }

    @Override
    public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
        return true;
    }

    @Override
    public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
        return true;
    }

    @Override
    public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
        return false;
    }

    @Override
    public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
        return true;
    }

    @Override
    public boolean isLazyLoadable(UnloadedField field) {
        return true;
    }

    @Override
    public boolean isPersistentField(UnloadedField ctField) {
        return !ctField.hasAnnotation(Transient.class);
    }

    @Override
    public boolean isMappedCollection(UnloadedField field) {
        if (field.hasAnnotation(OneToMany.class) || field.hasAnnotation(ManyToMany.class) || field.hasAnnotation(ElementCollection.class)) {
            return true;
        }
        return !field.hasAnnotation(Basic.class);
    }

    @Override
    public UnloadedField[] order(UnloadedField[] persistentFields) {
        return persistentFields;
    }

    @Override
    public boolean isDiscoveredType(UnloadedClass classDescriptor) {
        return this.discoveredTypes.containsKey(classDescriptor.getName());
    }

    @Override
    public void registerDiscoveredType(UnloadedClass classDescriptor, Type.PersistenceType type) {
        this.discoveredTypes.put(classDescriptor.getName(), type);
    }
}

