/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decompiler.decompiler;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.jboss.windup.decompiler.api.ClassDecompileRequest;
import org.jboss.windup.decompiler.api.DecompilationException;
import org.jboss.windup.decompiler.api.DecompilationListener;
import org.jboss.windup.decompiler.api.DecompilationResult;
import org.jboss.windup.decompiler.api.Decompiler;
import org.jboss.windup.decompiler.util.Filter;
import org.jboss.windup.util.Checks;
import org.jboss.windup.util.exception.WindupStopException;
import org.jboss.windup.util.threading.WindupExecutors;

public abstract class AbstractDecompiler
implements Decompiler {
    private ExecutorService executorService = WindupExecutors.newSingleThreadExecutor();
    private int numberOfThreads = 1;

    public abstract Logger getLogger();

    public void setExecutorService(ExecutorService service, int numberOfThreads) {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Was not able to shutdown the compilation ExecutorService in ten minutes.");
        }
        this.numberOfThreads = numberOfThreads;
        this.executorService = service;
    }

    protected Map<String, List<ClassDecompileRequest>> groupDecompileRequests(Collection<ClassDecompileRequest> requests) {
        HashMap<String, List<ClassDecompileRequest>> requestMap = new HashMap<String, List<ClassDecompileRequest>>();
        for (ClassDecompileRequest request : requests) {
            String key;
            String filename = request.getClassFile().getFileName().toString();
            boolean mainClassFile = false;
            if (filename.matches(".*\\$.*.class")) {
                key = request.getClassFile().getParent().resolve(filename.substring(0, filename.indexOf("$")) + ".class").toString();
            } else {
                mainClassFile = true;
                key = request.getClassFile().toString();
            }
            ArrayList<ClassDecompileRequest> list = (ArrayList<ClassDecompileRequest>)requestMap.get(key);
            if (list == null) {
                list = new ArrayList<ClassDecompileRequest>();
                requestMap.put(key, list);
            }
            if (mainClassFile) {
                list.add(0, request);
                continue;
            }
            list.add(request);
        }
        return requestMap;
    }

    public abstract Collection<Callable<File>> getDecompileTasks(Map<String, List<ClassDecompileRequest>> var1, DecompilationListener var2);

    @Override
    public void decompileClassFiles(Collection<ClassDecompileRequest> requests, DecompilationListener listener) {
        Map<String, List<ClassDecompileRequest>> requestMap = this.groupDecompileRequests(requests);
        Collection<Callable<File>> tasks = this.getDecompileTasks(requestMap, listener);
        try {
            List<Future<File>> futures = this.executorService.invokeAll(tasks);
            futures.forEach(f -> {
                try {
                    f.get();
                }
                catch (WindupStopException windupStopException) {
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            });
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Decompilation was interrupted.");
        }
        finally {
            listener.decompilationProcessComplete();
        }
    }

    @Override
    public void close() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Was not able to decompile in the given time limit.");
        }
    }

    @Override
    public DecompilationResult decompileArchive(Path archive, Path outputDir, DecompilationListener listener) throws DecompilationException {
        return this.decompileArchive(archive, outputDir, null, listener);
    }

    @Override
    public DecompilationResult decompileArchive(Path archive, Path outputDir, Filter<ZipEntry> filter, DecompilationListener listener) throws DecompilationException {
        Checks.checkFileToBeRead((File)archive.toFile(), (String)"Archive to decompile");
        Checks.checkDirectoryToBeFilled((File)outputDir.toFile(), (String)"Output directory");
        return this.decompileArchiveImpl(archive, outputDir, filter, listener);
    }

    public abstract DecompilationResult decompileArchiveImpl(Path var1, Path var2, Filter<ZipEntry> var3, DecompilationListener var4);

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }
}

