/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.invm;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptor;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnection;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMRegistry;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.spi.core.remoting.AbstractConnector;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ConnectionLifeCycleListener;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ActiveMQThreadPoolExecutor;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InVMConnector
extends AbstractConnector {
    public static String INVM_CONNECTOR_TYPE = "IN-VM";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Map<String, Object> DEFAULT_CONFIG;
    public static volatile boolean failOnCreateConnection;
    public static volatile int numberOfFailures;
    private static volatile int failures;
    protected final int id;
    private final ClientProtocolManager protocolManager;
    private final BufferHandler handler;
    private final BaseConnectionLifeCycleListener listener;
    private final InVMAcceptor acceptor;
    private final ConcurrentMap<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private volatile boolean started;
    protected final OrderedExecutorFactory executorFactory;
    private final Executor closeExecutor;
    private final boolean bufferPoolingEnabled;
    private static ExecutorService threadPoolExecutor;

    public static synchronized void resetFailures() {
        failures = 0;
        failOnCreateConnection = false;
        numberOfFailures = -1;
    }

    private static synchronized void incFailures() {
        if (++failures == numberOfFailures) {
            InVMConnector.resetFailures();
        }
    }

    public static synchronized void resetThreadPool() {
        if (threadPoolExecutor != null) {
            ActiveMQThreadFactory tf;
            ThreadPoolExecutor tp;
            threadPoolExecutor.shutdownNow();
            if (threadPoolExecutor instanceof ThreadPoolExecutor && (tp = (ThreadPoolExecutor)threadPoolExecutor).getThreadFactory() instanceof ActiveMQThreadFactory && !(tf = (ActiveMQThreadFactory)tp.getThreadFactory()).join(10, TimeUnit.SECONDS)) {
                logger.warn("Thread pool is still busy. couldn't stop on time");
            }
            threadPoolExecutor = null;
        }
    }

    private static synchronized ExecutorService getInVMExecutor() {
        if (threadPoolExecutor == null) {
            threadPoolExecutor = ActiveMQClient.getGlobalThreadPoolSize() <= -1 ? new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)InVMConnector.class.getName())) : new ActiveMQThreadPoolExecutor(0, ActiveMQClient.getGlobalThreadPoolSize(), 60L, TimeUnit.SECONDS, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)InVMConnector.class.getName()));
        }
        return threadPoolExecutor;
    }

    public InVMConnector(Map<String, Object> configuration, BufferHandler handler, ClientConnectionLifeCycleListener listener, Executor closeExecutor, Executor threadPool, ClientProtocolManager protocolManager) {
        super(configuration);
        this.listener = listener;
        this.id = ConfigurationHelper.getIntProperty((String)"serverId", (int)0, configuration);
        this.bufferPoolingEnabled = ConfigurationHelper.getBooleanProperty((String)"bufferPooling", (boolean)true, configuration);
        this.handler = handler;
        this.closeExecutor = closeExecutor;
        this.executorFactory = new OrderedExecutorFactory((Executor)InVMConnector.getInVMExecutor());
        InVMRegistry registry = InVMRegistry.instance;
        this.acceptor = registry.getAcceptor(this.id);
        this.protocolManager = protocolManager;
    }

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    public synchronized void close() {
        if (!this.started) {
            return;
        }
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID(), false);
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Connection createConnection() {
        if (failOnCreateConnection) {
            InVMConnector.incFailures();
            logger.debug("Returning null on InVMConnector for tests");
            return null;
        }
        if (this.acceptor == null) {
            return null;
        }
        if (this.acceptor.getConnectionsAllowed() == -1L || (long)this.acceptor.getConnectionCount() < this.acceptor.getConnectionsAllowed()) {
            Connection conn = this.internalCreateConnection(this.acceptor.getHandler(), new Listener(), this.acceptor.getExecutorFactory().getExecutor());
            this.acceptor.connect((String)conn.getID(), this.handler, this, this.executorFactory.getExecutor());
            return conn;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Connection limit of {} reached. Refusing connection.", (Object)this.acceptor.getConnectionsAllowed());
        }
        return null;
    }

    public synchronized void start() {
        this.started = true;
        logger.debug("Started InVM Connector");
    }

    public BufferHandler getHandler() {
        return this.handler;
    }

    public void disconnect(String connectionID) {
        if (!this.started) {
            return;
        }
        Connection conn = (Connection)this.connections.get(connectionID);
        if (conn != null) {
            conn.close();
        }
    }

    protected Connection internalCreateConnection(BufferHandler handler, ClientConnectionLifeCycleListener listener, ArtemisExecutor serverExecutor) {
        InVMConnection inVMConnection = new InVMConnection(this.id, handler, (BaseConnectionLifeCycleListener)listener, serverExecutor);
        inVMConnection.setEnableBufferPooling(this.bufferPoolingEnabled);
        listener.connectionCreated(null, (Connection)inVMConnection, (Object)this.protocolManager);
        return inVMConnection;
    }

    public boolean isEquivalent(Map<String, Object> configuration) {
        int serverId = ConfigurationHelper.getIntProperty((String)"serverId", (int)0, configuration);
        return this.id == serverId;
    }

    static {
        HashMap<String, Integer> config = new HashMap<String, Integer>();
        config.put("serverId", 0);
        DEFAULT_CONFIG = Collections.unmodifiableMap(config);
        numberOfFailures = -1;
    }

    private class Listener
    implements ClientConnectionLifeCycleListener {
        private Listener() {
        }

        public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
            if (InVMConnector.this.connections.putIfAbsent((String)connection.getID(), connection) != null) {
                throw ActiveMQMessageBundle.BUNDLE.connectionExists(connection.getID());
            }
            if (InVMConnector.this.listener instanceof ConnectionLifeCycleListener) {
                InVMConnector.this.listener.connectionCreated(component, connection, (Object)protocol.getName());
            } else {
                InVMConnector.this.listener.connectionCreated(component, connection, (Object)protocol);
            }
        }

        public void connectionDestroyed(Object connectionID, boolean failed) {
            if (InVMConnector.this.connections.remove(connectionID) != null) {
                InVMConnector.this.acceptor.disconnect((String)connectionID);
                InVMConnector.this.closeExecutor.execute(() -> InVMConnector.this.listener.connectionDestroyed(connectionID, failed));
            }
        }

        public void connectionException(Object connectionID, ActiveMQException me) {
            InVMConnector.this.closeExecutor.execute(() -> InVMConnector.this.listener.connectionException(connectionID, me));
        }

        public void connectionReadyForWrites(Object connectionID, boolean ready) {
        }
    }
}

