/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class TimestampOperatorNode
extends BinaryOperatorNode {
    TimestampOperatorNode(ValueNode valueNode, ValueNode valueNode2, ContextManager contextManager) {
        super(contextManager);
        this.leftOperand = valueNode;
        this.rightOperand = valueNode2;
        this.operator = "timestamp";
        this.methodName = "getTimestamp";
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, list);
        this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, list);
        if (this.leftOperand.requiresTypeFromContext()) {
            this.leftOperand.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(91));
        }
        if (this.rightOperand.requiresTypeFromContext()) {
            this.rightOperand.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(92));
        }
        TypeId typeId = this.leftOperand.getTypeId();
        TypeId typeId2 = this.rightOperand.getTypeId();
        if (!this.leftOperand.requiresTypeFromContext() && !typeId.isStringTypeId() && typeId.getJDBCTypeId() != 91) {
            throw StandardException.newException((String)"42Y95", (Object[])new Object[]{this.operator, typeId.getSQLTypeName(), typeId2.getSQLTypeName()});
        }
        if (!this.rightOperand.requiresTypeFromContext() && !typeId2.isStringTypeId() && typeId2.getJDBCTypeId() != 92) {
            throw StandardException.newException((String)"42Y95", (Object[])new Object[]{this.operator, typeId.getSQLTypeName(), typeId2.getSQLTypeName()});
        }
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(93));
        return this.genSQLJavaSQLTree();
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        expressionClassBuilder.pushDataValueFactory(methodBuilder);
        this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.cast("org.apache.derby.iapi.types.DataValueDescriptor");
        this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.cast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder.callMethod((short)185, null, this.methodName, "org.apache.derby.iapi.types.DateTimeDataValue", 2);
    }
}

