/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util.matcher;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class OrRequestMatcher
implements RequestMatcher {
    private final List<RequestMatcher> requestMatchers;

    public OrRequestMatcher(List<RequestMatcher> requestMatchers) {
        Assert.notEmpty(requestMatchers, (String)"requestMatchers must contain a value");
        Assert.noNullElements(requestMatchers, (String)"requestMatchers cannot contain null values");
        this.requestMatchers = requestMatchers;
    }

    public OrRequestMatcher(RequestMatcher ... requestMatchers) {
        this(Arrays.asList(requestMatchers));
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        for (RequestMatcher matcher : this.requestMatchers) {
            if (!matcher.matches(request)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RequestMatcher.MatchResult matcher(HttpServletRequest request) {
        for (RequestMatcher matcher : this.requestMatchers) {
            RequestMatcher.MatchResult result = matcher.matcher(request);
            if (!result.isMatch()) continue;
            return result;
        }
        return RequestMatcher.MatchResult.notMatch();
    }

    public String toString() {
        return "Or " + String.valueOf(this.requestMatchers);
    }
}

