/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.generate;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class MethodName {
    private static final String[] PREFIXES = new String[]{"get", "set", "is"};
    public static final MethodName NONE = MethodName.of(new String[0]);
    private final String value;

    private MethodName(String value) {
        this.value = value;
    }

    static MethodName of(String ... parts) {
        Assert.notNull((Object)parts, "'parts' must not be null");
        return new MethodName(MethodName.join(parts));
    }

    MethodName and(MethodName name) {
        Assert.notNull((Object)name, "'name' must not be null");
        return this.and(name.value);
    }

    MethodName and(String ... parts) {
        Assert.notNull((Object)parts, "'parts' must not be null");
        String joined = MethodName.join(parts);
        String prefix = this.getPrefix(joined);
        String suffix = joined.substring(prefix.length());
        return MethodName.of(prefix, this.value, suffix);
    }

    private String getPrefix(String name) {
        for (String candidate : PREFIXES) {
            if (!name.startsWith(candidate)) continue;
            return candidate;
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof MethodName)) return false;
        MethodName that = (MethodName)other;
        if (!this.value.equals(that.value)) return false;
        return true;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return !StringUtils.hasLength(this.value) ? "$$aot" : this.value;
    }

    private static String join(String[] parts) {
        return StringUtils.uncapitalize(Arrays.stream(parts).map(MethodName::clean).map(StringUtils::capitalize).collect(Collectors.joining()));
    }

    private static String clean(@Nullable String part) {
        char[] chars = part != null ? part.toCharArray() : new char[]{};
        StringBuilder name = new StringBuilder(chars.length);
        boolean uppercase = false;
        for (char ch : chars) {
            char outputChar = !uppercase ? ch : Character.toUpperCase(ch);
            name.append(!Character.isLetter(ch) ? "" : Character.valueOf(outputChar));
            uppercase = ch == '.';
        }
        return name.toString();
    }
}

