/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.repository.config.PropertiesBasedNamedQueriesFactoryBean;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class NamedQueriesBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ATTRIBUTE = "named-queries-location";
    private final String defaultLocation;

    public NamedQueriesBeanDefinitionParser(String defaultLocation) {
        Assert.hasText((String)defaultLocation, (String)"DefaultLocation must not be null nor empty");
        this.defaultLocation = defaultLocation;
    }

    @NonNull
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder namedQueries = BeanDefinitionBuilder.rootBeanDefinition(PropertiesBasedNamedQueriesFactoryBean.class);
        namedQueries.addPropertyValue("locations", (Object)this.getDefaultedLocation(element));
        if (this.isDefaultLocation(element)) {
            namedQueries.addPropertyValue("ignoreResourceNotFound", (Object)true);
        }
        AbstractBeanDefinition namedQueriesDefinition = namedQueries.getBeanDefinition();
        namedQueriesDefinition.setSource(parserContext.extractSource((Object)element));
        return namedQueriesDefinition;
    }

    private boolean isDefaultLocation(Element element) {
        return !StringUtils.hasText((String)element.getAttribute(ATTRIBUTE));
    }

    private String getDefaultedLocation(Element element) {
        String locations = element.getAttribute(ATTRIBUTE);
        return StringUtils.hasText((String)locations) ? locations : this.defaultLocation;
    }
}

