/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import jakarta.persistence.metamodel.SingularAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.LockOptions;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.internal.BaseNaturalIdLoadAccessImpl;
import org.hibernate.loader.internal.LoadAccessContext;
import org.hibernate.metamodel.mapping.EntityMappingType;

public class NaturalIdLoadAccessImpl<T>
extends BaseNaturalIdLoadAccessImpl<T>
implements NaturalIdLoadAccess<T> {
    private final Map<String, Object> naturalIdParameters = new LinkedHashMap<String, Object>();

    public NaturalIdLoadAccessImpl(LoadAccessContext context, EntityMappingType entityDescriptor) {
        super(context, entityDescriptor);
    }

    @Override
    public NaturalIdLoadAccessImpl<T> with(LockOptions lockOptions) {
        return (NaturalIdLoadAccessImpl)super.with(lockOptions);
    }

    @Override
    public <X> NaturalIdLoadAccess<T> using(SingularAttribute<? super T, X> attribute, X value) {
        this.naturalIdParameters.put(attribute.getName(), value);
        return this;
    }

    @Override
    public NaturalIdLoadAccess<T> using(String attributeName, Object value) {
        this.naturalIdParameters.put(attributeName, value);
        return this;
    }

    @Override
    public NaturalIdLoadAccess<T> using(Map<String, ?> mappings) {
        this.naturalIdParameters.putAll(mappings);
        return this;
    }

    @Override
    @Deprecated
    public NaturalIdLoadAccess<T> using(Object ... mappings) {
        CollectionHelper.collectMapEntries(this.naturalIdParameters::put, mappings);
        return this;
    }

    @Override
    public NaturalIdLoadAccessImpl<T> setSynchronizationEnabled(boolean synchronizationEnabled) {
        super.synchronizationEnabled(synchronizationEnabled);
        return this;
    }

    @Override
    public final T getReference() {
        return this.doGetReference(this.entityPersister().getNaturalIdMapping().normalizeInput(this.naturalIdParameters));
    }

    @Override
    public final T load() {
        return this.doLoad(this.entityPersister().getNaturalIdMapping().normalizeInput(this.naturalIdParameters));
    }

    @Override
    public Optional<T> loadOptional() {
        return Optional.ofNullable(this.load());
    }

    @Override
    public NaturalIdLoadAccess<T> with(RootGraph<T> graph, GraphSemantic semantic) {
        super.with(graph, semantic);
        return this;
    }

    @Override
    public NaturalIdLoadAccess<T> enableFetchProfile(String profileName) {
        super.enableFetchProfile(profileName);
        return this;
    }

    @Override
    public NaturalIdLoadAccess<T> disableFetchProfile(String profileName) {
        super.enableFetchProfile(profileName);
        return this;
    }
}

