/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheAction;
import org.infinispan.security.actions.GetCacheComponentRegistryAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static <K, V> ComponentRegistry getComponentRegistry(AdvancedCache<K, V> cache) {
        return SecurityActions.doPrivileged(new GetCacheComponentRegistryAction(cache));
    }

    static <K, V> Cache<K, V> getCache(EmbeddedCacheManager cacheManager, String cacheName) {
        return (Cache)SecurityActions.doPrivileged(new GetCacheAction(cacheManager, cacheName));
    }
}

