/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ram;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;

class RamFileData
implements Serializable {
    private static final long serialVersionUID = 20101208L;
    private FileName name;
    private FileType type;
    private byte[] content;
    private long lastModifiedMillis;
    private final Collection<RamFileData> children = Collections.synchronizedCollection(new ArrayList());

    public RamFileData(FileName name) {
        this.clear();
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        this.name = name;
    }

    byte[] getContent() {
        return this.content;
    }

    void setContent(byte[] content) {
        this.updateLastModified();
        this.content = content;
    }

    long getLastModified() {
        return this.lastModifiedMillis;
    }

    void setLastModified(long lastModified) {
        this.lastModifiedMillis = lastModified;
    }

    FileType getType() {
        return this.type;
    }

    void setType(FileType type) {
        this.type = type;
    }

    void clear() {
        this.content = ArrayUtils.EMPTY_BYTE_ARRAY;
        this.updateLastModified();
        this.type = FileType.IMAGINARY;
        this.children.clear();
        this.name = null;
    }

    void updateLastModified() {
        this.lastModifiedMillis = System.currentTimeMillis();
    }

    FileName getName() {
        return this.name;
    }

    public String toString() {
        return this.name.toString();
    }

    void addChild(RamFileData data) throws FileSystemException {
        if (!this.getType().hasChildren()) {
            throw new FileSystemException("A child can only be added in a folder");
        }
        FileSystemException.requireNonNull(data, "No child can be null");
        if (this.children.contains(data)) {
            throw new FileSystemException("Child already exists. " + data);
        }
        this.children.add(data);
        this.updateLastModified();
    }

    void removeChild(RamFileData data) throws FileSystemException {
        if (!this.getType().hasChildren()) {
            throw new FileSystemException("A child can only be removed from a folder");
        }
        if (!this.children.contains(data)) {
            throw new FileSystemException("Child not found. " + data);
        }
        this.children.remove(data);
        this.updateLastModified();
    }

    Collection<RamFileData> getChildren() {
        if (this.name == null) {
            throw new IllegalStateException("Data is clear");
        }
        return this.children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RamFileData)) {
            return false;
        }
        RamFileData data = (RamFileData)o;
        return this.getName().equals(data.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    boolean hasChildren(RamFileData data) {
        return this.children.contains(data);
    }

    int size() {
        return this.content.length;
    }

    void resize(long newSize) {
        if (newSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("newSize(%d) > Integer.MAX_VALUE(%d)", newSize, Integer.MAX_VALUE));
        }
        int resize = (int)newSize;
        int size = this.size();
        byte[] newBuf = new byte[resize];
        System.arraycopy(this.content, 0, newBuf, 0, Math.min(resize, size));
        this.content = newBuf;
        this.updateLastModified();
    }
}

