/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.shared.common.error.StandardException;

public class SYSTRIGGERSRowFactory
extends CatalogRowFactory {
    static final String TABLENAME_STRING = "SYSTRIGGERS";
    public static final int SYSTRIGGERS_TRIGGERID = 1;
    public static final int SYSTRIGGERS_TRIGGERNAME = 2;
    public static final int SYSTRIGGERS_SCHEMAID = 3;
    public static final int SYSTRIGGERS_CREATIONTIMESTAMP = 4;
    public static final int SYSTRIGGERS_EVENT = 5;
    public static final int SYSTRIGGERS_FIRINGTIME = 6;
    public static final int SYSTRIGGERS_TYPE = 7;
    public static final int SYSTRIGGERS_STATE = 8;
    public static final int SYSTRIGGERS_TABLEID = 9;
    public static final int SYSTRIGGERS_WHENSTMTID = 10;
    public static final int SYSTRIGGERS_ACTIONSTMTID = 11;
    public static final int SYSTRIGGERS_REFERENCEDCOLUMNS = 12;
    public static final int SYSTRIGGERS_TRIGGERDEFINITION = 13;
    public static final int SYSTRIGGERS_REFERENCINGOLD = 14;
    public static final int SYSTRIGGERS_REFERENCINGNEW = 15;
    public static final int SYSTRIGGERS_OLDREFERENCINGNAME = 16;
    public static final int SYSTRIGGERS_NEWREFERENCINGNAME = 17;
    public static final int SYSTRIGGERS_WHENCLAUSETEXT = 18;
    public static final int SYSTRIGGERS_COLUMN_COUNT = 18;
    public static final int SYSTRIGGERS_INDEX1_ID = 0;
    public static final int SYSTRIGGERS_INDEX2_ID = 1;
    public static final int SYSTRIGGERS_INDEX3_ID = 2;
    private static final int[][] indexColumnPositions = new int[][]{{1}, {2, 3}, {9, 4}};
    private static final boolean[] uniqueness = new boolean[]{true, true, false};
    private static final String[] uuids = new String[]{"c013800d-00d7-c025-4809-000a0a411200", "c013800d-00d7-c025-480a-000a0a411200", "c013800d-00d7-c025-480b-000a0a411200", "c013800d-00d7-c025-480c-000a0a411200", "c013800d-00d7-c025-480d-000a0a411200"};
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final DataDictionary dataDictionary;

    SYSTRIGGERSRowFactory(DataDictionary dataDictionary, UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) throws StandardException {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.dataDictionary = dataDictionary;
        this.initInfo(18, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        return this.makeRow(tupleDescriptor, this.getHeapColumnCount());
    }

    @Override
    public ExecRow makeEmptyRowForCurrentVersion() throws StandardException {
        return this.makeRow(null, 18);
    }

    private ExecRow makeRow(TupleDescriptor tupleDescriptor, int n) throws StandardException {
        Object object;
        Object object2;
        String string = null;
        UUID uUID = null;
        UUID uUID2 = null;
        UUID uUID3 = null;
        UUID uUID4 = null;
        UUID uUID5 = null;
        Timestamp timestamp = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        ReferencedColumnsDescriptorImpl referencedColumnsDescriptorImpl = null;
        boolean bl = false;
        boolean bl2 = false;
        String string9 = null;
        if (tupleDescriptor != null) {
            object2 = (TriggerDescriptor)tupleDescriptor;
            string = ((TriggerDescriptor)object2).getName();
            uUID = ((TriggerDescriptor)object2).getUUID();
            uUID2 = ((TriggerDescriptor)object2).getSchemaDescriptor().getUUID();
            timestamp = ((TriggerDescriptor)object2).getCreationTimestamp();
            string2 = ((TriggerDescriptor)object2).listensForEvent(1) ? "U" : (((TriggerDescriptor)object2).listensForEvent(2) ? "D" : "I");
            string3 = ((TriggerDescriptor)object2).isBeforeTrigger() ? "B" : "A";
            string4 = ((TriggerDescriptor)object2).isRowTrigger() ? "R" : "S";
            string5 = ((TriggerDescriptor)object2).isEnabled() ? "E" : "D";
            uUID3 = ((TriggerDescriptor)object2).getTableDescriptor().getUUID();
            object = ((TriggerDescriptor)object2).getReferencedCols();
            int[] nArray = ((TriggerDescriptor)object2).getReferencedColsInTriggerAction();
            referencedColumnsDescriptorImpl = object != null || nArray != null ? new ReferencedColumnsDescriptorImpl((int[])object, nArray) : null;
            uUID4 = ((TriggerDescriptor)object2).getActionId();
            uUID5 = ((TriggerDescriptor)object2).getWhenClauseId();
            string6 = ((TriggerDescriptor)object2).getTriggerDefinition();
            bl = ((TriggerDescriptor)object2).getReferencingOld();
            bl2 = ((TriggerDescriptor)object2).getReferencingNew();
            string7 = ((TriggerDescriptor)object2).getOldReferencingName();
            string8 = ((TriggerDescriptor)object2).getNewReferencingName();
            string9 = ((TriggerDescriptor)object2).getWhenClauseText();
        }
        object2 = this.getExecutionFactory().getValueRow(n);
        object2.setColumn(1, new SQLChar(uUID == null ? null : uUID.toString()));
        object2.setColumn(2, new SQLVarchar(string));
        object2.setColumn(3, new SQLChar(uUID2 == null ? null : uUID2.toString()));
        object = timestamp == null ? new SQLTimestamp(null) : new SQLTimestamp(timestamp, this.getCalendarForCreationTimestamp());
        object2.setColumn(4, (DataValueDescriptor)object);
        object2.setColumn(5, new SQLChar(string2));
        object2.setColumn(6, new SQLChar(string3));
        object2.setColumn(7, new SQLChar(string4));
        object2.setColumn(8, new SQLChar(string5));
        object2.setColumn(9, new SQLChar(uUID3 == null ? null : uUID3.toString()));
        object2.setColumn(10, new SQLChar(uUID5 == null ? null : uUID5.toString()));
        object2.setColumn(11, new SQLChar(uUID4 == null ? null : uUID4.toString()));
        object2.setColumn(12, new UserType(referencedColumnsDescriptorImpl));
        object2.setColumn(13, this.dvf.getLongvarcharDataValue(string6));
        object2.setColumn(14, new SQLBoolean(bl));
        object2.setColumn(15, new SQLBoolean(bl2));
        object2.setColumn(16, new SQLVarchar(string7));
        object2.setColumn(17, new SQLVarchar(string8));
        if (object2.nColumns() >= 18) {
            object2.setColumn(18, this.dvf.getLongvarcharDataValue(string9));
        }
        return object2;
    }

    private Calendar getCalendarForCreationTimestamp() throws StandardException {
        if (this.dataDictionary.checkVersion(230, null)) {
            return Calendar.getInstance(UTC);
        }
        return Calendar.getInstance();
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        UUID uUID = null;
        UUID uUID2 = null;
        int n = 0;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID3 = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        String string2 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(3);
        string = dataValueDescriptor.getString();
        UUID uUID4 = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(4);
        Timestamp timestamp = dataValueDescriptor.getTimestamp(this.getCalendarForCreationTimestamp());
        dataValueDescriptor = execRow.getColumn(5);
        char c = dataValueDescriptor.getString().charAt(0);
        switch (c) {
            case 'U': {
                n = 1;
                break;
            }
            case 'I': {
                n = 4;
                break;
            }
            case 'D': {
                n = 2;
                break;
            }
        }
        boolean bl = this.getCharBoolean(execRow.getColumn(6), 'B', 'A');
        boolean bl2 = this.getCharBoolean(execRow.getColumn(7), 'R', 'S');
        boolean bl3 = this.getCharBoolean(execRow.getColumn(8), 'E', 'D');
        dataValueDescriptor = execRow.getColumn(9);
        string = dataValueDescriptor.getString();
        UUID uUID5 = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(10);
        string = dataValueDescriptor.getString();
        if (string != null) {
            uUID2 = this.getUUIDFactory().recreateUUID(string);
        }
        if ((string = (dataValueDescriptor = execRow.getColumn(11)).getString()) != null) {
            uUID = this.getUUIDFactory().recreateUUID(string);
        }
        dataValueDescriptor = execRow.getColumn(12);
        ReferencedColumns referencedColumns = (ReferencedColumns)dataValueDescriptor.getObject();
        dataValueDescriptor = execRow.getColumn(13);
        String string3 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(14);
        boolean bl4 = dataValueDescriptor.getBoolean();
        dataValueDescriptor = execRow.getColumn(15);
        boolean bl5 = dataValueDescriptor.getBoolean();
        dataValueDescriptor = execRow.getColumn(16);
        String string4 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(17);
        String string5 = dataValueDescriptor.getString();
        String string6 = null;
        if (execRow.nColumns() >= 18) {
            dataValueDescriptor = execRow.getColumn(18);
            string6 = dataValueDescriptor.getString();
        }
        TriggerDescriptor triggerDescriptor = dataDescriptorGenerator.newTriggerDescriptor(dataDictionary.getSchemaDescriptor(uUID4, null), uUID3, string2, n, bl, bl2, bl3, dataDictionary.getTableDescriptor(uUID5), uUID2, uUID, timestamp, referencedColumns == null ? (int[])null : referencedColumns.getReferencedColumnPositions(), referencedColumns == null ? (int[])null : referencedColumns.getTriggerActionReferencedColumnPositions(), string3, bl4, bl5, string4, string5, string6);
        return triggerDescriptor;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("TRIGGERID", false), SystemColumnImpl.getIdentifierColumn("TRIGGERNAME", false), SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getColumn("CREATIONTIMESTAMP", 93, false), SystemColumnImpl.getIndicatorColumn("EVENT"), SystemColumnImpl.getIndicatorColumn("FIRINGTIME"), SystemColumnImpl.getIndicatorColumn("TYPE"), SystemColumnImpl.getIndicatorColumn("STATE"), SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getUUIDColumn("WHENSTMTID", true), SystemColumnImpl.getUUIDColumn("ACTIONSTMTID", true), SystemColumnImpl.getJavaColumn("REFERENCEDCOLUMNS", "org.apache.derby.catalog.ReferencedColumns", true), SystemColumnImpl.getColumn("TRIGGERDEFINITION", -1, true, Integer.MAX_VALUE), SystemColumnImpl.getColumn("REFERENCINGOLD", 16, true), SystemColumnImpl.getColumn("REFERENCINGNEW", 16, true), SystemColumnImpl.getIdentifierColumn("OLDREFERENCINGNAME", true), SystemColumnImpl.getIdentifierColumn("NEWREFERENCINGNAME", true), SystemColumnImpl.getColumn("WHENCLAUSETEXT", -1, true, Integer.MAX_VALUE)};
    }

    private boolean getCharBoolean(DataValueDescriptor dataValueDescriptor, char c, char c2) throws StandardException {
        char c3 = dataValueDescriptor.getString().charAt(0);
        if (c3 == c) {
            return true;
        }
        return c3 != c2;
    }

    @Override
    public int getHeapColumnCount() throws StandardException {
        boolean bl = this.dataDictionary.checkVersion(230, null);
        int n = super.getHeapColumnCount();
        return bl ? n : n - 1;
    }
}

