/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheValue;
import org.infinispan.marshall.core.Ids;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public class MetadataTransientMortalCacheEntry
extends AbstractInternalCacheEntry
implements MetadataAware {
    Metadata metadata;
    long created;
    long lastUsed;

    public MetadataTransientMortalCacheEntry(Object key, Object value, Metadata metadata, long now) {
        this(key, value, metadata, now, now);
    }

    public MetadataTransientMortalCacheEntry(Object key, Object value, Metadata metadata, long lastUsed, long created) {
        this(key, value, null, metadata, lastUsed, created);
    }

    protected MetadataTransientMortalCacheEntry(Object key, Object value, PrivateMetadata internalMetadata, Metadata metadata, long lastUsed, long created) {
        super(key, value, internalMetadata);
        this.metadata = metadata;
        this.lastUsed = lastUsed;
        this.created = created;
    }

    @Override
    public long getLifespan() {
        return this.metadata.lifespan();
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransientMortal(this.metadata.maxIdle(), this.lastUsed, this.metadata.lifespan(), this.created, now);
    }

    @Override
    public boolean canExpireMaxIdle() {
        return true;
    }

    @Override
    public final long getExpiryTime() {
        long muet;
        long lifespan = this.metadata.lifespan();
        long lset = lifespan > -1L ? this.created + lifespan : -1L;
        long maxIdle = this.metadata.maxIdle();
        long l = muet = maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    public InternalCacheValue<?> toInternalCacheValue() {
        return new MetadataTransientMortalCacheValue(this.value, this.internalMetadata, this.metadata, this.created, this.lastUsed);
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.lastUsed = currentTimeMillis;
    }

    @Override
    public void reincarnate(long now) {
        this.created = now;
    }

    @Override
    public long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", metadata=").append(this.metadata);
        builder.append(", created=").append(this.created);
        builder.append(", lastUsed=").append(this.lastUsed);
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataTransientMortalCacheEntry> {
        public void writeObject(ObjectOutput output, MetadataTransientMortalCacheEntry ice) throws IOException {
            output.writeObject(ice.key);
            output.writeObject(ice.value);
            output.writeObject(ice.internalMetadata);
            output.writeObject(ice.metadata);
            UnsignedNumeric.writeUnsignedLong((DataOutput)output, (long)ice.created);
            UnsignedNumeric.writeUnsignedLong((DataOutput)output, (long)ice.lastUsed);
        }

        public MetadataTransientMortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object key = input.readObject();
            Object value = input.readObject();
            PrivateMetadata internalMetadata = (PrivateMetadata)input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong((DataInput)input);
            long lastUsed = UnsignedNumeric.readUnsignedLong((DataInput)input);
            return new MetadataTransientMortalCacheEntry(key, value, internalMetadata, metadata, lastUsed, created);
        }

        public Integer getId() {
            return Ids.METADATA_TRANSIENT_MORTAL_ENTRY;
        }

        public Set<Class<? extends MetadataTransientMortalCacheEntry>> getTypeClasses() {
            return Collections.singleton(MetadataTransientMortalCacheEntry.class);
        }
    }
}

