/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault.authentication;

import java.util.function.Supplier;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.util.Assert;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.KubernetesAuthentication;
import org.springframework.vault.authentication.KubernetesAuthenticationOptions;
import org.springframework.vault.authentication.KubernetesServiceAccountTokenFile;
import org.springframework.web.client.RestOperations;

public class KubernetesClientAuthenticationProvider
extends SpringVaultClientAuthenticationProvider {
    public KubernetesClientAuthenticationProvider() {
        super(VaultEnvironmentProperties.AuthenticationMethod.KUBERNETES);
    }

    @Override
    public ClientAuthentication getClientAuthentication(VaultEnvironmentProperties vaultProperties, RestOperations vaultRestOperations, RestOperations externalRestOperations) {
        VaultEnvironmentProperties.KubernetesProperties kubernetes = vaultProperties.getKubernetes();
        Assert.hasText((String)kubernetes.getRole(), (String)this.missingPropertyForAuthMethod("kubernetes.role", VaultEnvironmentProperties.AuthenticationMethod.KUBERNETES));
        Assert.hasText((String)kubernetes.getServiceAccountTokenFile(), (String)this.missingPropertyForAuthMethod("kubernetes.service-account-token-file", VaultEnvironmentProperties.AuthenticationMethod.KUBERNETES));
        KubernetesAuthenticationOptions options = KubernetesAuthenticationOptions.builder().path(kubernetes.getKubernetesPath()).role(kubernetes.getRole()).jwtSupplier((Supplier)new KubernetesServiceAccountTokenFile(kubernetes.getServiceAccountTokenFile())).build();
        return new KubernetesAuthentication(options, vaultRestOperations);
    }
}

