/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.BindableType;
import org.hibernate.query.spi.QueryParameterBindingTypeResolver;

public abstract class QueryParameterBindingTypeResolverImpl
implements QueryParameterBindingTypeResolver {
    @Override
    public <T> BindableType<T> resolveParameterBindType(Class<T> javaType) {
        return this.getMappingMetamodel().resolveQueryParameterType(javaType);
    }

    @Override
    public <T> BindableType<? super T> resolveParameterBindType(T bindValue) {
        Class<T> clazz;
        if (bindValue == null) {
            return null;
        }
        Class<T> c = clazz = QueryParameterBindingTypeResolverImpl.unproxiedClass(bindValue);
        do {
            BindableType<Class<T>> type;
            if ((type = this.resolveParameterBindType((T)c)) == null) continue;
            return type;
        } while ((c = c.getSuperclass()) != Object.class);
        if (clazz.isEnum()) {
            return null;
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return this.resolveParameterBindType((T)Serializable.class);
        }
        return null;
    }

    private static <T> Class<T> unproxiedClass(T bindValue) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(bindValue);
        Class<?> result = lazyInitializer != null ? lazyInitializer.getPersistentClass() : bindValue.getClass();
        return result;
    }
}

