/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

import io.github.resilience4j.core.ClassUtils;
import io.github.resilience4j.core.ContextPropagator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;

public class ThreadPoolBulkheadConfig {
    public static final int DEFAULT_QUEUE_CAPACITY = 100;
    public static final Duration DEFAULT_KEEP_ALIVE_DURATION = Duration.ofMillis(20L);
    public static final int DEFAULT_CORE_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors() > 1 ? Runtime.getRuntime().availableProcessors() - 1 : 1;
    public static final int DEFAULT_MAX_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    public static final boolean DEFAULT_WRITABLE_STACK_TRACE_ENABLED = true;
    private int maxThreadPoolSize = DEFAULT_MAX_THREAD_POOL_SIZE;
    private int coreThreadPoolSize = DEFAULT_CORE_THREAD_POOL_SIZE;
    private int queueCapacity = 100;
    private Duration keepAliveDuration = DEFAULT_KEEP_ALIVE_DURATION;
    private boolean writableStackTraceEnabled = true;
    private List<ContextPropagator> contextPropagators = new ArrayList<ContextPropagator>();
    private RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();

    private ThreadPoolBulkheadConfig() {
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder from(ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
        return new Builder(threadPoolBulkheadConfig);
    }

    public static ThreadPoolBulkheadConfig ofDefaults() {
        return new Builder().build();
    }

    public Duration getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public int getCoreThreadPoolSize() {
        return this.coreThreadPoolSize;
    }

    public boolean isWritableStackTraceEnabled() {
        return this.writableStackTraceEnabled;
    }

    public List<ContextPropagator> getContextPropagator() {
        return this.contextPropagators;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ThreadPoolBulkheadConfig{");
        sb.append("maxThreadPoolSize=").append(this.maxThreadPoolSize);
        sb.append(", coreThreadPoolSize=").append(this.coreThreadPoolSize);
        sb.append(", queueCapacity=").append(this.queueCapacity);
        sb.append(", keepAliveDuration=").append(this.keepAliveDuration);
        sb.append(", writableStackTraceEnabled=").append(this.writableStackTraceEnabled);
        sb.append(", contextPropagators=").append(this.contextPropagators);
        sb.append(", rejectExecutionHandle=").append(this.rejectedExecutionHandler.getClass().getSimpleName());
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private Class<? extends ContextPropagator>[] contextPropagatorClasses = new Class[0];
        private List<? extends ContextPropagator> contextPropagators = new ArrayList<ContextPropagator>();
        private ThreadPoolBulkheadConfig config;

        public Builder(ThreadPoolBulkheadConfig bulkheadConfig) {
            this.config = bulkheadConfig;
        }

        public Builder() {
            this.config = new ThreadPoolBulkheadConfig();
        }

        public Builder maxThreadPoolSize(int maxThreadPoolSize) {
            if (maxThreadPoolSize < 1) {
                throw new IllegalArgumentException("maxThreadPoolSize must be a positive integer value >= 1");
            }
            this.config.maxThreadPoolSize = maxThreadPoolSize;
            return this;
        }

        public Builder coreThreadPoolSize(int coreThreadPoolSize) {
            if (coreThreadPoolSize < 1) {
                throw new IllegalArgumentException("coreThreadPoolSize must be a positive integer value >= 1");
            }
            this.config.coreThreadPoolSize = coreThreadPoolSize;
            return this;
        }

        public final Builder contextPropagator(Class<? extends ContextPropagator> ... contextPropagatorClasses) {
            this.contextPropagatorClasses = contextPropagatorClasses != null ? contextPropagatorClasses : new Class[]{};
            return this;
        }

        public final Builder contextPropagator(ContextPropagator ... contextPropagators) {
            this.contextPropagators = contextPropagators != null ? Arrays.stream(contextPropagators).collect(Collectors.toList()) : new ArrayList<ContextPropagator>();
            return this;
        }

        public Builder queueCapacity(int queueCapacity) {
            if (queueCapacity < 0) {
                throw new IllegalArgumentException("queueCapacity must be a positive integer value >= 0");
            }
            this.config.queueCapacity = queueCapacity;
            return this;
        }

        public Builder keepAliveDuration(Duration keepAliveDuration) {
            if (keepAliveDuration.toMillis() < 0L) {
                throw new IllegalArgumentException("keepAliveDuration must be a positive integer value >= 0");
            }
            this.config.keepAliveDuration = keepAliveDuration;
            return this;
        }

        public Builder writableStackTraceEnabled(boolean writableStackTraceEnabled) {
            this.config.writableStackTraceEnabled = writableStackTraceEnabled;
            return this;
        }

        public Builder rejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
            Objects.requireNonNull(rejectedExecutionHandler);
            this.config.rejectedExecutionHandler = rejectedExecutionHandler;
            return this;
        }

        public ThreadPoolBulkheadConfig build() {
            if (this.config.maxThreadPoolSize < this.config.coreThreadPoolSize) {
                throw new IllegalArgumentException("maxThreadPoolSize must be a greater than or equals to coreThreadPoolSize");
            }
            if (this.contextPropagatorClasses.length > 0) {
                this.config.contextPropagators.addAll(Arrays.stream(this.contextPropagatorClasses).map(ClassUtils::instantiateClassDefConstructor).collect(Collectors.toList()));
            }
            if (!this.contextPropagators.isEmpty()) {
                this.config.contextPropagators.addAll(this.contextPropagators);
            }
            return this.config;
        }
    }
}

