/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.handlers.bulk;

import com.sksamuel.elastic4s.handlers.VersionTypeHttpString$;
import com.sksamuel.elastic4s.handlers.index.IndexContentBuilder$;
import com.sksamuel.elastic4s.handlers.update.UpdateBuilderFn$;
import com.sksamuel.elastic4s.json.XContentBuilder;
import com.sksamuel.elastic4s.json.XContentFactory$;
import com.sksamuel.elastic4s.requests.bulk.BulkCompatibleRequest;
import com.sksamuel.elastic4s.requests.bulk.BulkRequest;
import com.sksamuel.elastic4s.requests.common.FetchSourceContext;
import com.sksamuel.elastic4s.requests.common.VersionType;
import com.sksamuel.elastic4s.requests.delete.DeleteByIdRequest;
import com.sksamuel.elastic4s.requests.indexes.IndexRequest;
import com.sksamuel.elastic4s.requests.update.UpdateRequest;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class BulkBuilderFn$ {
    public static final BulkBuilderFn$ MODULE$ = new BulkBuilderFn$();

    public Iterator<String> apply(BulkRequest bulk) {
        return bulk.requests().iterator().flatMap((Function1 & Serializable)x0$1 -> {
            Iterator iterator;
            BulkCompatibleRequest bulkCompatibleRequest = x0$1;
            if (bulkCompatibleRequest instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)bulkCompatibleRequest;
                XContentBuilder builder = XContentFactory$.MODULE$.jsonBuilder();
                String createOrIndex = BoxesRunTime.unboxToBoolean((Object)indexRequest.createOnly().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? "create" : "index";
                builder.startObject(createOrIndex);
                builder.field("_index", indexRequest.index().name());
                indexRequest.id().foreach((Function1 & Serializable)id -> builder.field("_id", id));
                indexRequest.parent().foreach((Function1 & Serializable)x$1 -> builder.field("_parent", x$1));
                indexRequest.routing().foreach((Function1 & Serializable)x$2 -> builder.field("routing", x$2));
                indexRequest.version().foreach((Function1 & Serializable)x$3 -> builder.field("version", BoxesRunTime.unboxToLong((Object)x$3)));
                indexRequest.ifPrimaryTerm().foreach((Function1 & Serializable)x$4 -> builder.field("if_primary_term", BoxesRunTime.unboxToLong((Object)x$4)));
                indexRequest.ifSeqNo().foreach((Function1 & Serializable)x$5 -> builder.field("if_seq_no", BoxesRunTime.unboxToLong((Object)x$5)));
                indexRequest.versionType().foreach((Function1 & Serializable)versionType -> builder.field("version_type", VersionTypeHttpString$.MODULE$.apply((VersionType)versionType)));
                indexRequest.pipeline().foreach((Function1 & Serializable)x$6 -> builder.field("pipeline", x$6));
                builder.endObject();
                builder.endObject();
                iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{builder.string(), IndexContentBuilder$.MODULE$.apply(indexRequest)}));
            } else if (bulkCompatibleRequest instanceof DeleteByIdRequest) {
                DeleteByIdRequest deleteByIdRequest = (DeleteByIdRequest)bulkCompatibleRequest;
                XContentBuilder builder = XContentFactory$.MODULE$.jsonBuilder();
                builder.startObject("delete");
                builder.field("_index", deleteByIdRequest.index().index());
                builder.field("_id", deleteByIdRequest.id());
                deleteByIdRequest.parent().foreach((Function1 & Serializable)x$7 -> builder.field("_parent", x$7));
                deleteByIdRequest.routing().foreach((Function1 & Serializable)x$8 -> builder.field("routing", x$8));
                deleteByIdRequest.version().foreach((Function1 & Serializable)x$9 -> builder.field("version", BoxesRunTime.unboxToLong((Object)x$9)));
                deleteByIdRequest.ifPrimaryTerm().foreach((Function1 & Serializable)x$10 -> builder.field("if_primary_term", BoxesRunTime.unboxToLong((Object)x$10)));
                deleteByIdRequest.ifSeqNo().foreach((Function1 & Serializable)x$11 -> builder.field("if_seq_no", BoxesRunTime.unboxToLong((Object)x$11)));
                deleteByIdRequest.versionType().foreach((Function1 & Serializable)versionType -> builder.field("version_type", VersionTypeHttpString$.MODULE$.apply((VersionType)versionType)));
                builder.endObject();
                builder.endObject();
                iterator = package$.MODULE$.Iterator().single((Object)builder.string());
            } else if (bulkCompatibleRequest instanceof UpdateRequest) {
                UpdateRequest updateRequest = (UpdateRequest)bulkCompatibleRequest;
                XContentBuilder builder = XContentFactory$.MODULE$.jsonBuilder();
                builder.startObject("update");
                builder.field("_index", updateRequest.index().index());
                builder.field("_id", updateRequest.id());
                updateRequest.parent().foreach((Function1 & Serializable)x$12 -> builder.field("_parent", x$12));
                updateRequest.routing().foreach((Function1 & Serializable)x$13 -> builder.field("routing", x$13));
                updateRequest.version().foreach((Function1 & Serializable)x$14 -> builder.field("version", BoxesRunTime.unboxToLong((Object)x$14)));
                updateRequest.ifPrimaryTerm().foreach((Function1 & Serializable)x$15 -> builder.field("if_primary_term", BoxesRunTime.unboxToLong((Object)x$15)));
                updateRequest.ifSeqNo().foreach((Function1 & Serializable)x$16 -> builder.field("if_seq_no", BoxesRunTime.unboxToLong((Object)x$16)));
                updateRequest.versionType().foreach((Function1 & Serializable)x$17 -> builder.field("version_type", x$17));
                updateRequest.retryOnConflict().foreach((Function1 & Serializable)x$18 -> builder.field("retry_on_conflict", BoxesRunTime.unboxToInt((Object)x$18)));
                updateRequest.fetchSource().foreach((Function1 & Serializable)x0$2 -> {
                    FetchSourceContext fetchSourceContext = x0$2;
                    if (fetchSourceContext == null) {
                        throw new MatchError((Object)fetchSourceContext);
                    }
                    boolean fetchSource = fetchSourceContext.fetchSource();
                    Set includes = fetchSourceContext.includes();
                    Set excludes = fetchSourceContext.excludes();
                    builder.field("_source", fetchSource);
                    Object object = includes.nonEmpty() ? builder.field("_source_includes", includes.mkString(",")) : BoxedUnit.UNIT;
                    BoxedUnit boxedUnit = excludes.nonEmpty() ? builder.field("_source_excludes", excludes.mkString(",")) : BoxedUnit.UNIT;
                    return boxedUnit;
                });
                builder.endObject();
                builder.endObject();
                iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{builder.string(), UpdateBuilderFn$.MODULE$.apply(updateRequest).string()}));
            } else {
                throw new MatchError((Object)bulkCompatibleRequest);
            }
            return iterator;
        });
    }

    private BulkBuilderFn$() {
    }
}

