/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.rendering.DateHeaderRendering;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.headers.Connection;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.CustomHeader;
import org.apache.pekko.http.scaladsl.model.headers.Date;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.Server;
import org.apache.pekko.http.scaladsl.model.headers.Transfer$minusEncoding;
import org.apache.pekko.http.scaladsl.model.headers.User$minusAgent;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class HttpMessageRendering$ {
    public static final HttpMessageRendering$ MODULE$ = new HttpMessageRendering$();

    public void addContentHeaders(VectorBuilder<Tuple2<String, String>> headerPairs, HttpEntity entity) {
        if (entity.contentType() != ContentTypes$.MODULE$.NoContentType()) {
            headerPairs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content-type"), (Object)entity.contentType().toString()));
        }
        entity.contentLengthOption().foreach((Function1 & Serializable)x$2 -> HttpMessageRendering$.$anonfun$addContentHeaders$1(headerPairs, BoxesRunTime.unboxToLong((Object)x$2)));
    }

    public Seq<Tuple2<String, String>> renderHeaders(Seq<HttpHeader> headers2, LoggingAdapter log, boolean isServer, boolean shouldRenderAutoHeaders, DateHeaderRendering dateHeaderRendering) {
        VectorBuilder headerPairs = new VectorBuilder();
        this.renderHeaders(headers2, (VectorBuilder<Tuple2<String, String>>)headerPairs, (Option<Tuple2<String, String>>)None$.MODULE$, log, isServer, shouldRenderAutoHeaders, dateHeaderRendering);
        return headerPairs.result();
    }

    public void renderHeaders(Seq<HttpHeader> headersSeq, VectorBuilder<Tuple2<String, String>> headerPairs, Option<Tuple2<String, String>> peerIdHeader, LoggingAdapter log, boolean isServer, boolean shouldRenderAutoHeaders, DateHeaderRendering dateHeaderRendering) {
        Iterator it = headersSeq.iterator();
        boolean peerIdSeen = false;
        boolean dateSeen = false;
        while (it.hasNext()) {
            RawHeader rawHeader;
            HttpHeader header = (HttpHeader)it.next();
            if ((!header.renderInResponses() || !isServer) && (!header.renderInRequests() || isServer)) continue;
            if (header instanceof Server) {
                Server server = (Server)header;
                if (isServer) {
                    HttpMessageRendering$.addHeader$1(server, headerPairs);
                    peerIdSeen = true;
                    continue;
                }
            }
            if (header instanceof User$minusAgent) {
                User$minusAgent user$minusAgent = (User$minusAgent)header;
                if (!isServer) {
                    HttpMessageRendering$.addHeader$1(user$minusAgent, headerPairs);
                    peerIdSeen = true;
                    continue;
                }
            }
            if (header instanceof Date) {
                Date date = (Date)header;
                if (isServer) {
                    HttpMessageRendering$.addHeader$1(date, headerPairs);
                    dateSeen = true;
                    continue;
                }
            }
            if (header instanceof CustomHeader) {
                HttpMessageRendering$.addHeader$1((CustomHeader)header, headerPairs);
                continue;
            }
            if (header instanceof RawHeader && ((rawHeader = (RawHeader)header).is("content-type") || rawHeader.is("content-length") || rawHeader.is("transfer-encoding") || rawHeader.is("date") || rawHeader.is("server") || rawHeader.is("user-agent") || rawHeader.is("connection"))) {
                String suppressionWarning$1_msg = "illegal RawHeader";
                log.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)rawHeader, (Object)suppressionWarning$1_msg);
                Object var21_20 = null;
                continue;
            }
            if (header instanceof Content$minusLength) {
                Content$minusLength content$minusLength = (Content$minusLength)header;
                String suppressionWarning$1_msg = "explicit `Content-Length` header is not allowed. Use the appropriate HttpEntity subtype.";
                log.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)content$minusLength, (Object)suppressionWarning$1_msg);
                Object var22_21 = null;
                continue;
            }
            if (header instanceof Content$minusType) {
                Content$minusType content$minusType = (Content$minusType)header;
                String suppressionWarning$1_msg = "explicit `Content-Type` header is not allowed. Set `HttpResponse.entity.contentType` instead.";
                log.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)content$minusType, (Object)suppressionWarning$1_msg);
                Object var23_22 = null;
                continue;
            }
            if (header instanceof Transfer$minusEncoding) {
                Transfer$minusEncoding transfer$minusEncoding = (Transfer$minusEncoding)header;
                String suppressionWarning$1_msg = "`Transfer-Encoding` header is not allowed for HTTP/2";
                log.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)transfer$minusEncoding, (Object)suppressionWarning$1_msg);
                Object var24_23 = null;
                continue;
            }
            if (header instanceof Connection) {
                Connection connection = (Connection)header;
                String suppressionWarning$1_msg = "`Connection` header is not allowed for HTTP/2";
                log.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)connection, (Object)suppressionWarning$1_msg);
                Object var25_24 = null;
                continue;
            }
            HttpMessageRendering$.addHeader$1(header, headerPairs);
        }
        if (shouldRenderAutoHeaders && !dateSeen && isServer) {
            headerPairs.$plus$eq(dateHeaderRendering.renderHeaderPair());
        }
        if (shouldRenderAutoHeaders && !peerIdSeen) {
            if (peerIdHeader instanceof Some) {
                Tuple2 peerIdTuple = (Tuple2)((Some)peerIdHeader).value();
                headerPairs.$plus$eq((Object)peerIdTuple);
                return;
            }
            if (None$.MODULE$.equals(peerIdHeader)) {
                return;
            }
            throw new MatchError(peerIdHeader);
        }
    }

    public static final /* synthetic */ VectorBuilder $anonfun$addContentHeaders$1(VectorBuilder headerPairs$1, long x$2) {
        return (VectorBuilder)headerPairs$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content-length"), (Object)Long.toString(x$2)));
    }

    private static final void suppressionWarning$1(HttpHeader h, String msg, LoggingAdapter log$1) {
        log$1.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)h, (Object)msg);
    }

    private static final void addHeader$1(HttpHeader h, VectorBuilder headerPairs$2) {
        headerPairs$2.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)h.lowercaseName()), (Object)h.value()));
    }

    private HttpMessageRendering$() {
    }
}

