/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.AttributeImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class Attributes {
    public static final Attributes EMPTY = new Attributes();
    private LinkedHashMap<String, Attribute> attributes;

    public Attributes() {
        this.attributes = null;
    }

    public Attributes(Attributes attributes) {
        this.attributes = attributes == null || attributes.attributes == null ? null : new LinkedHashMap<String, Attribute>(attributes.attributes);
    }

    protected LinkedHashMap<String, Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap();
        }
        return this.attributes;
    }

    public Attribute get(CharSequence key) {
        if (this.attributes == null || key == null || key.length() == 0) {
            return null;
        }
        String useKey = String.valueOf(key);
        return this.attributes.get(useKey);
    }

    public String getValue(CharSequence key) {
        if (this.attributes == null || key == null || key.length() == 0) {
            return "";
        }
        String useKey = String.valueOf(key);
        Attribute attribute = this.attributes.get(useKey);
        if (attribute == null) {
            return "";
        }
        return attribute.getValue();
    }

    public Attribute replaceValue(Attribute attribute) {
        return this.replaceValue(attribute.getName(), attribute.getValue());
    }

    public Attribute replaceValue(CharSequence key, CharSequence value) {
        Attribute attribute;
        String useKey = String.valueOf(key);
        attribute = this.attributes == null ? AttributeImpl.of(useKey, value) : ((attribute = this.attributes.get(useKey)) != null ? attribute.replaceValue(value) : AttributeImpl.of(useKey, value));
        this.getAttributes().put(useKey, attribute);
        return attribute;
    }

    public Attribute addValue(Attribute attribute) {
        return this.addValue(attribute.getName(), attribute.getValue());
    }

    public Attributes addValues(Attributes attributes) {
        for (Attribute attribute : attributes.values()) {
            this.addValue(attribute.getName(), attribute.getValue());
        }
        return this;
    }

    public Attribute addValue(CharSequence key, CharSequence value) {
        Attribute attribute;
        String useKey = String.valueOf(key);
        attribute = this.attributes == null ? AttributeImpl.of(key, value) : ((attribute = this.attributes.get(useKey)) != null ? attribute.setValue(value) : AttributeImpl.of(useKey, value));
        this.getAttributes().put(useKey, attribute);
        return attribute;
    }

    public Attribute removeValue(Attribute attribute) {
        return this.removeValue(attribute.getName(), attribute.getValue());
    }

    public Attribute remove(Attribute attribute) {
        return this.remove(attribute.getName());
    }

    public Attribute removeValue(CharSequence key, CharSequence value) {
        if (this.attributes == null || key == null || key.length() == 0) {
            return null;
        }
        String useKey = String.valueOf(key);
        Attribute oldAttribute = this.attributes.get(useKey);
        Attribute attribute = oldAttribute.removeValue(value);
        this.getAttributes().put(useKey, attribute);
        return attribute;
    }

    public boolean contains(CharSequence key) {
        if (this.attributes == null || key == null || key.length() == 0) {
            return false;
        }
        String useKey = String.valueOf(key);
        return this.attributes.containsKey(useKey);
    }

    public boolean containsValue(CharSequence key, CharSequence value) {
        if (this.attributes == null) {
            return false;
        }
        String useKey = String.valueOf(key);
        Attribute attribute = this.attributes.get(useKey);
        return attribute != null && attribute.containsValue(value);
    }

    public boolean isEmpty() {
        return this.attributes == null || this.attributes.isEmpty();
    }

    public void clear() {
        this.attributes = null;
    }

    public Set<String> keySet() {
        return this.attributes != null ? this.attributes.keySet() : Collections.EMPTY_SET;
    }

    public Collection<Attribute> values() {
        return this.attributes != null ? this.attributes.values() : Collections.EMPTY_LIST;
    }

    public Set<Map.Entry<String, Attribute>> entrySet() {
        return this.attributes != null ? this.attributes.entrySet() : Collections.EMPTY_SET;
    }

    public void forEach(BiConsumer<String, Attribute> action) {
        if (this.attributes != null) {
            for (Map.Entry<String, Attribute> entry : this.attributes.entrySet()) {
                action.accept(entry.getKey(), entry.getValue());
            }
        }
    }

    public int size() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public Attribute remove(CharSequence key) {
        if (this.attributes == null || key == null || key.length() == 0) {
            return null;
        }
        String useKey = String.valueOf(key);
        Attribute oldAttribute = this.attributes.get(useKey);
        this.attributes.remove(useKey);
        return oldAttribute;
    }

    public void replaceValues(Attributes attributes) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Attribute>(attributes.attributes);
        } else {
            this.attributes.putAll(attributes.attributes);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String attrName : this.keySet()) {
            sb.append(sep).append(attrName);
            Attribute attribute = this.attributes.get(attrName);
            if (!attribute.getValue().isEmpty()) {
                sb.append("=").append("\"").append(attribute.getValue().replace("\"", "\\\"")).append("\"");
            }
            sep = " ";
        }
        return "Attributes{" + sb.toString() + '}';
    }
}

