/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.pekko.http.impl.model.parser.CharacterClasses$;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$Path$Empty$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$Empty$;
import org.apache.pekko.http.scaladsl.model.UriRendering$HostRenderer$;
import org.parboiled2.CharPredicate;
import org.parboiled2.CharUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class UriRendering$ {
    public static final UriRendering$ MODULE$ = new UriRendering$();

    public <R extends Rendering> R renderUri(R r, Uri value, Charset charset) {
        this.renderUriWithoutFragment(r, value, charset);
        if (value.fragment().isDefined()) {
            this.encode(r.$tilde$tilde('#'), (String)value.fragment().get(), charset, CharacterClasses$.MODULE$.query$minusfragment$minuschar(), false);
        }
        return r;
    }

    public <R extends Rendering> R renderUriWithoutFragment(R r, Uri value, Charset charset) {
        if (value.isAbsolute()) {
            r.$tilde$tilde(value.scheme()).$tilde$tilde(':');
        }
        if (value.authority().nonEmpty()) {
            r.$tilde$tilde('/').$tilde$tilde('/');
        }
        this.renderAuthority(r, value.authority(), value.path(), value.scheme(), charset);
        this.renderPath(r, value.path(), charset, value.isRelative());
        value.rawQueryString().foreach((Function1 & Serializable)x$4 -> r.$tilde$tilde('?').$tilde$tilde((String)x$4));
        return r;
    }

    public <R extends Rendering> R renderAuthority(R r, Uri.Authority authority, String scheme, Charset charset) {
        return this.renderAuthority(r, authority, Uri$Path$Empty$.MODULE$, scheme, charset);
    }

    public <R extends Rendering> R renderAuthority(R r, Uri.Authority authority, Uri.Path path, String scheme, Charset charset) {
        block10: {
            if (authority.nonEmpty()) {
                if (!authority.userinfo().isEmpty()) {
                    this.encode(r, authority.userinfo(), charset, CharacterClasses$.MODULE$.userinfo$minuschar(), false).$tilde$tilde('@');
                }
                r.$tilde$tilde((Uri.Host)authority.host(), UriRendering$HostRenderer$.MODULE$);
                if (authority.port() != 0) {
                    return (R)r.$tilde$tilde(':').$tilde$tilde(authority.port());
                }
                return r;
            }
            switch (scheme == null ? 0 : scheme.hashCode()) {
                case -1081572750: {
                    if ("mailto".equals(scheme)) {
                        break;
                    }
                    break block10;
                }
                case 0: {
                    if ("".equals(scheme)) {
                        break;
                    }
                    break block10;
                }
                default: {
                    break block10;
                }
            }
            return r;
        }
        if (path.isEmpty() || path.startsWithSlash()) {
            return (R)r.$tilde$tilde('/').$tilde$tilde('/');
        }
        return r;
    }

    public <R extends Rendering> R renderPath(R r, Uri.Path path, Charset charset, boolean encodeFirstSegmentColons) {
        while (true) {
            if (Uri$Path$Empty$.MODULE$.equals(path)) {
                return r;
            }
            if (path instanceof Uri.Path.Slash) {
                Uri.Path tail = ((Uri.Path.Slash)path).tail();
                encodeFirstSegmentColons = false;
                path = tail;
                r = r.$tilde$tilde('/');
                continue;
            }
            if (!(path instanceof Uri.Path.Segment)) break;
            Uri.Path.Segment segment = (Uri.Path.Segment)path;
            String head = segment.head();
            Uri.Path.SlashOrEmpty tail = segment.tail();
            CharPredicate keep = encodeFirstSegmentColons ? CharacterClasses$.MODULE$.pchar$minusbase$minusnc() : CharacterClasses$.MODULE$.pchar$minusbase();
            Rendering rendering = this.encode((Rendering)r, head, charset, keep, false);
            encodeFirstSegmentColons = false;
            path = tail;
            r = rendering;
        }
        throw new MatchError((Object)path);
    }

    public <R extends Rendering> boolean renderPath$default$4() {
        return false;
    }

    public <R extends Rendering> R renderQuery(R r, Uri.Query query, Charset charset, CharPredicate keep) {
        return (R)this.append$3(query, r, query, charset, keep);
    }

    public <R extends Rendering> CharPredicate renderQuery$default$4() {
        return CharacterClasses$.MODULE$.strict$minusquery$minuschar$minusnp();
    }

    public Rendering encode(Rendering r, String string, Charset charset, CharPredicate keep, boolean replaceSpaces) {
        boolean asciiCompatible = this.isAsciiCompatible(charset);
        return this.rec$3(0, r, string, keep, replaceSpaces, asciiCompatible, charset);
    }

    public boolean encode$default$5() {
        return false;
    }

    public boolean isAsciiCompatible(Charset cs) {
        block3: {
            block2: {
                Charset charset = cs;
                Charset charset2 = package$.MODULE$.UTF8();
                if (!(charset == null ? charset2 != null : !((Object)charset).equals(charset2))) break block2;
                Charset charset3 = cs;
                Charset charset4 = package$.MODULE$.ISO88591();
                if (!(charset3 == null ? charset4 != null : !((Object)charset3).equals(charset4))) break block2;
                Charset charset5 = cs;
                Charset charset6 = package$.MODULE$.ASCII();
                if (charset5 != null ? !((Object)charset5).equals(charset6) : charset6 != null) break block3;
            }
            return true;
        }
        return false;
    }

    private final void enc$1(String s2, Rendering r$2, Charset charset$3, CharPredicate keep$1) {
        this.encode(r$2, s2, charset$3, keep$1, true);
    }

    private final Rendering append$3(Uri.Query q, Rendering r$2, Uri.Query query$1, Charset charset$3, CharPredicate keep$1) {
        while (true) {
            if (Seq.equals$((Seq)Uri$Query$Empty$.MODULE$, (Object)q)) {
                return r$2;
            }
            if (!(q instanceof Uri.Query.Cons)) break;
            Uri.Query.Cons cons = (Uri.Query.Cons)q;
            String key = cons.key();
            String value = cons.value();
            Uri.Query tail = cons.tail();
            if (q != query$1) {
                r$2.$tilde$tilde('&');
            }
            this.encode(r$2, key, charset$3, keep$1, true);
            if (value != Uri$Query$.MODULE$.EmptyValue()) {
                r$2.$tilde$tilde('=');
            }
            this.encode(r$2, value, charset$3, keep$1, true);
            q = tail;
        }
        throw new MatchError((Object)q);
    }

    private static final void appendEncoded$1(byte by, Rendering r$3) {
        r$3.$tilde$tilde('%').$tilde$tilde(CharUtils$.MODULE$.upperHexDigit(by >>> 4)).$tilde$tilde(CharUtils$.MODULE$.upperHexDigit((int)by));
    }

    private static final void append$4(String s2, Charset charset$4, Rendering r$3) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.byteArrayOps(s2.getBytes(charset$4)), (Function1 & Serializable)object -> {
            UriRendering$.appendEncoded$1(BoxesRunTime.unboxToByte((Object)object), r$3);
            return BoxedUnit.UNIT;
        });
    }

    private final Rendering rec$3(int ix, Rendering r$3, String string$3, CharPredicate keep$2, boolean replaceSpaces$1, boolean asciiCompatible$1, Charset charset$4) {
        while (ix < string$3.length()) {
            int n;
            char c = string$3.charAt(ix);
            if (keep$2.apply(c)) {
                r$3.$tilde$tilde(c);
                n = 1;
            } else if (' ' == c && replaceSpaces$1) {
                r$3.$tilde$tilde('+');
                n = 1;
            } else if (c <= '\u007f' && asciiCompatible$1) {
                UriRendering$.appendEncoded$1((byte)c, r$3);
                n = 1;
            } else if (Character.isHighSurrogate(c)) {
                UriRendering$.append$4(new String(new int[]{string$3.codePointAt(ix)}, 0, 1), charset$4, r$3);
                n = 2;
            } else {
                UriRendering$.append$4(Character.toString(c), charset$4, r$3);
                n = 1;
            }
            int charSize = n;
            ix += charSize;
        }
        return r$3;
    }

    private UriRendering$() {
    }
}

