/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.CharSequenceHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.ClockHelper;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class OffsetDateTimeJavaType
extends AbstractTemporalJavaType<OffsetDateTime>
implements VersionJavaType<OffsetDateTime> {
    public static final OffsetDateTimeJavaType INSTANCE = new OffsetDateTimeJavaType();
    private static final DateTimeFormatter PARSE_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().parseLenient().appendOffset("+HH:MM:ss", "Z").parseStrict().toFormatter();

    public OffsetDateTimeJavaType() {
        super(OffsetDateTime.class, ImmutableMutabilityPlan.instance(), OffsetDateTime.timeLineOrder());
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators stdIndicators) {
        if (stdIndicators.isPreferJavaTimeJdbcTypesEnabled()) {
            return stdIndicators.getJdbcType(3012);
        }
        return stdIndicators.getJdbcType(stdIndicators.getDefaultZonedTimestampSqlType());
    }

    @Override
    protected <X> TemporalJavaType<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(OffsetDateTime value) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(value);
    }

    @Override
    public OffsetDateTime fromString(CharSequence string) {
        return OffsetDateTime.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(string));
    }

    @Override
    public OffsetDateTime fromEncodedString(CharSequence string, int start, int end) {
        TemporalAccessor temporalAccessor = PARSE_FORMATTER.parse(CharSequenceHelper.subSequence(string, start, end));
        if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            return OffsetDateTime.from(temporalAccessor);
        }
        return LocalDateTime.from(temporalAccessor).atOffset(ZoneOffset.UTC);
    }

    @Override
    public <X> X unwrap(OffsetDateTime offsetDateTime, Class<X> type, WrapperOptions options) {
        if (offsetDateTime == null) {
            return null;
        }
        if (OffsetDateTime.class.isAssignableFrom(type)) {
            return (X)offsetDateTime;
        }
        if (ZonedDateTime.class.isAssignableFrom(type)) {
            return (X)offsetDateTime.toZonedDateTime();
        }
        if (Instant.class.isAssignableFrom(type)) {
            return (X)offsetDateTime.toInstant();
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(offsetDateTime.toZonedDateTime());
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            if (offsetDateTime.getYear() < 1905) {
                return (X)Timestamp.valueOf(offsetDateTime.atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime());
            }
            return (X)Timestamp.from(offsetDateTime.toInstant());
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.from(offsetDateTime.toInstant());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)Time.from(offsetDateTime.toInstant());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)java.util.Date.from(offsetDateTime.toInstant());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(offsetDateTime.toInstant().toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> OffsetDateTime wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof OffsetDateTime) {
            return (OffsetDateTime)value;
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)value;
            return OffsetDateTime.of(zonedDateTime.toLocalDateTime(), zonedDateTime.getOffset());
        }
        if (value instanceof Instant) {
            Instant instant = (Instant)value;
            return instant.atOffset(ZoneOffset.UTC);
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            if (ts.getYear() < 5) {
                return ts.toLocalDateTime().atZone(ZoneId.systemDefault()).toOffsetDateTime();
            }
            return OffsetDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
        }
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            return OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        if (value instanceof Long) {
            return OffsetDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneId.systemDefault());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return OffsetDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultTimestampPrecision();
    }

    @Override
    public OffsetDateTime seed(Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return OffsetDateTime.now(ClockHelper.forPrecision(precision, session));
    }

    @Override
    public OffsetDateTime next(OffsetDateTime current, Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return OffsetDateTime.now(ClockHelper.forPrecision(precision, session));
    }
}

