/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity.mutation;

import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.mutation.AbstractDeleteCoordinator;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.ast.ColumnValueBindingList;
import org.hibernate.sql.model.ast.TableMutation;
import org.hibernate.sql.model.ast.builder.TableUpdateBuilder;
import org.hibernate.sql.model.ast.builder.TableUpdateBuilderStandard;
import org.hibernate.sql.model.internal.MutationGroupSingle;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;

public class DeleteCoordinatorSoft
extends AbstractDeleteCoordinator {
    public DeleteCoordinatorSoft(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory) {
        super(entityPersister, factory);
    }

    @Override
    protected MutationOperationGroup generateOperationGroup(Object rowId, Object[] loadedState, boolean applyVersion, SharedSessionContractImplementor session) {
        EntityTableMapping rootTableMapping = this.entityPersister().getIdentifierTableMapping();
        TableUpdateBuilderStandard<MutationOperation> tableUpdateBuilder = new TableUpdateBuilderStandard<MutationOperation>(this.entityPersister(), rootTableMapping, this.factory());
        DeleteCoordinatorSoft.applyKeyRestriction(rowId, this.entityPersister(), tableUpdateBuilder, rootTableMapping);
        this.applySoftDelete(this.entityPersister().getSoftDeleteMapping(), tableUpdateBuilder);
        this.applyPartitionKeyRestriction(tableUpdateBuilder);
        this.applyOptimisticLocking(tableUpdateBuilder, loadedState, session);
        TableMutation tableMutation = tableUpdateBuilder.buildMutation();
        MutationGroupSingle mutationGroup = new MutationGroupSingle(MutationType.DELETE, this.entityPersister(), tableMutation);
        Object mutationOperation = tableMutation.createMutationOperation(null, this.factory());
        return MutationOperationGroupFactory.singleOperation(mutationGroup, mutationOperation);
    }

    private void applyPartitionKeyRestriction(TableUpdateBuilder<?> tableUpdateBuilder) {
        AbstractEntityPersister persister = this.entityPersister();
        if (persister.hasPartitionedSelectionMapping()) {
            AttributeMappingsList attributeMappings = persister.getAttributeMappings();
            for (int m = 0; m < attributeMappings.size(); ++m) {
                AttributeMapping attributeMapping = attributeMappings.get(m);
                int jdbcTypeCount = attributeMapping.getJdbcTypeCount();
                for (int i = 0; i < jdbcTypeCount; ++i) {
                    SelectableMapping selectableMapping = attributeMapping.getSelectable(i);
                    if (!selectableMapping.isPartitioned()) continue;
                    tableUpdateBuilder.addKeyRestrictionLeniently(selectableMapping);
                }
            }
        }
    }

    private void applySoftDelete(SoftDeleteMapping softDeleteMapping, TableUpdateBuilderStandard<MutationOperation> tableUpdateBuilder) {
        tableUpdateBuilder.addLiteralRestriction(softDeleteMapping.getSelectionExpression(), softDeleteMapping.getNonDeletedLiteralText(), softDeleteMapping.getJdbcMapping());
        tableUpdateBuilder.addValueColumn(softDeleteMapping.getSelectionExpression(), softDeleteMapping.getDeletedLiteralText(), softDeleteMapping.getJdbcMapping());
    }

    protected void applyOptimisticLocking(TableUpdateBuilderStandard<MutationOperation> tableUpdateBuilder, Object[] loadedState, SharedSessionContractImplementor session) {
        OptimisticLockStyle optimisticLockStyle = this.entityPersister().optimisticLockStyle();
        if (optimisticLockStyle.isVersion() && this.entityPersister().getVersionMapping() != null) {
            this.applyVersionBasedOptLocking(tableUpdateBuilder);
        } else if (loadedState != null && this.entityPersister().optimisticLockStyle().isAllOrDirty()) {
            this.applyNonVersionOptLocking(optimisticLockStyle, tableUpdateBuilder, loadedState, session);
        }
    }

    protected void applyVersionBasedOptLocking(TableUpdateBuilderStandard<MutationOperation> tableUpdateBuilder) {
        assert (this.entityPersister().optimisticLockStyle() == OptimisticLockStyle.VERSION);
        assert (this.entityPersister().getVersionMapping() != null);
        tableUpdateBuilder.addOptimisticLockRestriction(this.entityPersister().getVersionMapping());
    }

    protected void applyNonVersionOptLocking(OptimisticLockStyle lockStyle, TableUpdateBuilderStandard<MutationOperation> tableUpdateBuilder, Object[] loadedState, SharedSessionContractImplementor session) {
        AbstractEntityPersister persister = this.entityPersister();
        assert (loadedState != null);
        assert (lockStyle.isAllOrDirty());
        assert (persister.optimisticLockStyle().isAllOrDirty());
        assert (session != null);
        boolean[] versionability = persister.getPropertyVersionability();
        for (int attributeIndex = 0; attributeIndex < versionability.length; ++attributeIndex) {
            AttributeMapping attribute;
            if (!versionability[attributeIndex] || (attribute = persister.getAttributeMapping(attributeIndex)).isPluralAttributeMapping()) continue;
            this.breakDownJdbcValues(tableUpdateBuilder, session, attribute, loadedState[attributeIndex]);
        }
    }

    private void breakDownJdbcValues(TableUpdateBuilderStandard<MutationOperation> tableUpdateBuilder, SharedSessionContractImplementor session, AttributeMapping attribute, Object loadedValue) {
        if (!tableUpdateBuilder.getMutatingTable().getTableName().equals(attribute.getContainingTableExpression())) {
            return;
        }
        ColumnValueBindingList optimisticLockBindings = tableUpdateBuilder.getOptimisticLockBindings();
        if (optimisticLockBindings != null) {
            attribute.breakDownJdbcValues(loadedValue, (valueIndex, value, jdbcValueMapping) -> {
                if (!tableUpdateBuilder.getKeyRestrictionBindings().containsColumn(jdbcValueMapping.getSelectableName(), jdbcValueMapping.getJdbcMapping())) {
                    optimisticLockBindings.consume(valueIndex, value, jdbcValueMapping);
                }
            }, session);
        }
    }
}

