/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import org.apache.pekko.actor.Address;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.AssociationHandle$Unknown$;
import org.apache.pekko.remote.transport.netty.CommonHandlers;
import org.apache.pekko.remote.transport.netty.TcpAssociationHandle;
import org.apache.pekko.remote.transport.netty.TcpHandlers$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.CompactByteString$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dsA\u0002\b\u0010\u0011\u0003\u00192D\u0002\u0004\u001e\u001f!\u00051C\b\u0005\u0006K\u0005!\ta\n\u0005\bQ\u0005\u0011\r\u0011\"\u0003*\u0011\u0019\t\u0015\u0001)A\u0005U\u0019AQd\u0004I\u0001\u0004\u0003\u0019\"\tC\u0003G\u000b\u0011\u0005q\tC\u0003L\u000b\u0019EA\nC\u0003T\u000b\u0011\u0005C\u000bC\u0003i\u000b\u0011\u0005\u0013\u000eC\u0003z\u000b\u0011\u0005#\u0010C\u0004\u0002\u0002\u0015!\t%a\u0001\t\u000f\u0005]Q\u0001\"\u0011\u0002\u001a!9\u0011\u0011H\u0003\u0005\n\u0005m\u0012a\u0003+da\"\u000bg\u000e\u001a7feNT!\u0001E\t\u0002\u000b9,G\u000f^=\u000b\u0005I\u0019\u0012!\u0003;sC:\u001c\bo\u001c:u\u0015\t!R#\u0001\u0004sK6|G/\u001a\u0006\u0003-]\tQ\u0001]3lW>T!\u0001G\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0012aA8sOB\u0011A$A\u0007\u0002\u001f\tYAk\u00199IC:$G.\u001a:t'\t\tq\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t1$\u0001\u0005M\u0013N#VIT#S+\u0005Q\u0003cA\u00162g5\tAF\u0003\u0002.]\u0005!Q\u000f^5m\u0015\t\u0001rFC\u00011\u0003\tIw.\u0003\u00023Y\ta\u0011\t\u001e;sS\n,H/Z&fsB\u0011AG\u0010\b\u0003kqr!AN\u001e\u000f\u0005]RdB\u0001\u001d:\u001b\u00059\u0012B\u0001\f\u0018\u0013\t!R#\u0003\u0002\u0013'%\u0011Q(E\u0001\u0012\u0003N\u001cxnY5bi&|g\u000eS1oI2,\u0017BA A\u0005MA\u0015M\u001c3mK\u00163XM\u001c;MSN$XM\\3s\u0015\ti\u0014#A\u0005M\u0013N#VIT#SAM\u0019QaH\"\u0011\u0005q!\u0015BA#\u0010\u00059\u0019u.\\7p]\"\u000bg\u000e\u001a7feN\fa\u0001J5oSR$C#\u0001%\u0011\u0005\u0001J\u0015B\u0001&\"\u0005\u0011)f.\u001b;\u0002\u00071|w-F\u0001N!\tq\u0015+D\u0001P\u0015\t\u0001V#A\u0003fm\u0016tG/\u0003\u0002S\u001f\nqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u0005:fO&\u001cH/\u001a:MSN$XM\\3s)\u0011AU\u000b\u00180\t\u000bYC\u0001\u0019A,\u0002\u000f\rD\u0017M\u001c8fYB\u0011\u0001LW\u0007\u00023*\u0011aKL\u0005\u00037f\u0013qa\u00115b]:,G\u000eC\u0003^\u0011\u0001\u00071'\u0001\u0005mSN$XM\\3s\u0011\u0015y\u0006\u00021\u0001a\u0003M\u0011X-\\8uKN{7m[3u\u0003\u0012$'/Z:t!\t\tg-D\u0001c\u0015\t\u0019G-A\u0002oKRT\u0011!Z\u0001\u0005U\u00064\u0018-\u0003\u0002hE\n\t\u0012J\\3u'>\u001c7.\u001a;BI\u0012\u0014Xm]:\u0002\u0019\r\u0014X-\u0019;f\u0011\u0006tG\r\\3\u0015\t)twn\u001e\t\u0003W2l\u0011!E\u0005\u0003[F\u0011\u0011#Q:t_\u000eL\u0017\r^5p]\"\u000bg\u000e\u001a7f\u0011\u00151\u0016\u00021\u0001X\u0011\u0015\u0001\u0018\u00021\u0001r\u00031awnY1m\u0003\u0012$'/Z:t!\t\u0011X/D\u0001t\u0015\t!X#A\u0003bGR|'/\u0003\u0002wg\n9\u0011\t\u001a3sKN\u001c\b\"\u0002=\n\u0001\u0004\t\u0018!\u0004:f[>$X-\u00113ee\u0016\u001c8/\u0001\u0007p]\u0012K7oY8o]\u0016\u001cG\u000f\u0006\u0002Iw\")AP\u0003a\u0001{\u0006\u00191\r\u001e=\u0011\u0005as\u0018BA@Z\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqR\f\u0011b\u001c8NKN\u001c\u0018mZ3\u0015\u000b!\u000b)!a\u0002\t\u000bq\\\u0001\u0019A?\t\u000f\u0005%1\u00021\u0001\u0002\f\u0005\u0019Qn]4\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005/\u0003\u0019\u0011WO\u001a4fe&!\u0011QCA\b\u0005\u001d\u0011\u0015\u0010^3Ck\u001a\f1b\u001c8Fq\u000e,\u0007\u000f^5p]R)\u0001*a\u0007\u0002\u001e!)A\u0010\u0004a\u0001{\"9\u0011q\u0004\u0007A\u0002\u0005\u0005\u0012!A3\u0011\t\u0005\r\u00121\u0007\b\u0005\u0003K\tyC\u0004\u0003\u0002(\u00055RBAA\u0015\u0015\r\tYCJ\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ1!!\r\"\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u000e\u00028\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003c\t\u0013A\u00048pi&4\u0017\u0010T5ti\u0016tWM\u001d\u000b\u0006\u0011\u0006u\u0012q\b\u0005\u0006-6\u0001\ra\u0016\u0005\u0007!6\u0001\r!!\u0011\u0011\u0007Q\n\u0019%C\u0002\u0002F\u0001\u00131\u0002S1oI2,WI^3oi\u0002")
public interface TcpHandlers
extends CommonHandlers {
    public LoggingAdapter log();

    public static /* synthetic */ void registerListener$(TcpHandlers $this, Channel channel, AssociationHandle.HandleEventListener listener, InetSocketAddress remoteSocketAddress) {
        $this.registerListener(channel, listener, remoteSocketAddress);
    }

    @Override
    default public void registerListener(Channel channel, AssociationHandle.HandleEventListener listener, InetSocketAddress remoteSocketAddress) {
        channel.attr(TcpHandlers$.MODULE$.org$apache$pekko$remote$transport$netty$TcpHandlers$$LISTENER()).set((Object)listener);
    }

    public static /* synthetic */ AssociationHandle createHandle$(TcpHandlers $this, Channel channel, Address localAddress, Address remoteAddress) {
        return $this.createHandle(channel, localAddress, remoteAddress);
    }

    @Override
    default public AssociationHandle createHandle(Channel channel, Address localAddress, Address remoteAddress) {
        return new TcpAssociationHandle(localAddress, remoteAddress, this.transport(), channel);
    }

    public static /* synthetic */ void onDisconnect$(TcpHandlers $this, ChannelHandlerContext ctx) {
        $this.onDisconnect(ctx);
    }

    @Override
    default public void onDisconnect(ChannelHandlerContext ctx) {
        this.notifyListener(ctx.channel(), new AssociationHandle.Disassociated(AssociationHandle$Unknown$.MODULE$));
        this.log().debug("Remote connection to [{}] was disconnected.", (Object)ctx.channel().remoteAddress());
    }

    public static /* synthetic */ void onMessage$(TcpHandlers $this, ChannelHandlerContext ctx, ByteBuf msg) {
        $this.onMessage(ctx, msg);
    }

    @Override
    default public void onMessage(ChannelHandlerContext ctx, ByteBuf msg) {
        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)msg);
        if (bytes.length > 0) {
            this.notifyListener(ctx.channel(), new AssociationHandle.InboundPayload((ByteString)CompactByteString$.MODULE$.apply(bytes)));
            return;
        }
    }

    public static /* synthetic */ void onException$(TcpHandlers $this, ChannelHandlerContext ctx, Throwable e) {
        $this.onException(ctx, e);
    }

    @Override
    default public void onException(ChannelHandlerContext ctx, Throwable e) {
        this.notifyListener(ctx.channel(), new AssociationHandle.Disassociated(AssociationHandle$Unknown$.MODULE$));
        this.log().warning("Remote connection to [{}] failed with {}", (Object)ctx.channel().remoteAddress(), (Object)e.getCause());
        ctx.channel().close();
    }

    private void notifyListener(Channel channel, AssociationHandle.HandleEvent event) {
        AssociationHandle.HandleEventListener listener = (AssociationHandle.HandleEventListener)channel.attr(TcpHandlers$.MODULE$.org$apache$pekko$remote$transport$netty$TcpHandlers$$LISTENER()).get();
        if (listener != null) {
            listener.notify(event);
            return;
        }
    }

    public static void $init$(TcpHandlers $this) {
    }
}

