/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.BuiltBy;

public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static <B> Class<? extends Builder<B>> builderFor(B built) throws CacheConfigurationException {
        BuiltBy builtBy = built.getClass().getAnnotation(BuiltBy.class);
        if (builtBy == null) {
            throw new CacheConfigurationException("Missing BuiltBy annotation for configuration bean " + built.getClass().getName());
        }
        return builtBy.value();
    }

    public static <B> Class<? extends Builder<B>> builderForNonStrict(B built) {
        BuiltBy builtBy = built.getClass().getAnnotation(BuiltBy.class);
        if (builtBy == null) {
            return null;
        }
        return builtBy.value();
    }
}

