/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.util.Map;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.ssh.PropertyBasedSshSessionFactory;
import org.springframework.cloud.config.server.ssh.SshUriPropertyProcessor;

public class PropertiesBasedSshTransportConfigCallback
implements TransportConfigCallback {
    private final MultipleJGitEnvironmentProperties sshUriProperties;
    private final PropertyBasedSshSessionFactory sshdSessionFactory;

    public PropertiesBasedSshTransportConfigCallback(MultipleJGitEnvironmentProperties sshUriProperties) {
        this.sshUriProperties = sshUriProperties;
        Map<String, JGitEnvironmentProperties> sshKeysByHostname = new SshUriPropertyProcessor(this.sshUriProperties).getSshKeysByHostname();
        this.sshdSessionFactory = sshKeysByHostname.isEmpty() ? null : new PropertyBasedSshSessionFactory(sshKeysByHostname);
    }

    public MultipleJGitEnvironmentProperties getSshUriProperties() {
        return this.sshUriProperties;
    }

    public void configure(Transport transport) {
        if (this.sshdSessionFactory != null && transport instanceof SshTransport) {
            ((SshTransport)transport).setSshSessionFactory((SshSessionFactory)this.sshdSessionFactory);
        }
    }
}

