/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.util.Collections;
import java.util.Iterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;

public class ConsoleLogAdapter
implements LogAdapter {
    private static boolean debugEnabled = false;
    private static boolean infoEnabled = true;
    private static boolean warnEnabled = true;

    public void debug(Object object) {
        if (debugEnabled) {
            System.out.println(object.toString());
        }
    }

    public void error(Object object) {
        System.err.println(object.toString());
    }

    public void error(Object object, Throwable throwable) {
        System.err.println(object.toString());
    }

    public void fatal(Object object) {
        System.err.println(object.toString());
    }

    public void fatal(Object object, Throwable throwable) {
        System.err.println(object.toString());
    }

    public void info(Object object) {
        if (infoEnabled) {
            System.out.println(object.toString());
        }
    }

    public boolean isDebugEnabled() {
        return debugEnabled;
    }

    public boolean isInfoEnabled() {
        return infoEnabled;
    }

    public boolean isWarnEnabled() {
        return warnEnabled;
    }

    public void warn(Object object) {
        if (warnEnabled) {
            System.out.println(object.toString());
        }
    }

    public static void setDebugEnabled(boolean bl) {
        debugEnabled = bl;
    }

    public static void setWarnEnabled(boolean bl) {
        warnEnabled = bl;
    }

    public static void setInfoEnabled(boolean bl) {
        infoEnabled = bl;
    }

    public void setLogLevel(LogLevel logLevel) {
        debugEnabled = false;
        warnEnabled = false;
        infoEnabled = false;
        switch (logLevel.getLevel()) {
            case 2: {
                debugEnabled = true;
                warnEnabled = true;
                infoEnabled = true;
                break;
            }
            case 3: 
            case 4: {
                debugEnabled = true;
                break;
            }
            case 5: {
                infoEnabled = true;
                break;
            }
            case 6: {
                warnEnabled = true;
                break;
            }
        }
    }

    public String getName() {
        return "";
    }

    public LogLevel getLogLevel() {
        if (debugEnabled) {
            return LogLevel.DEBUG;
        }
        if (infoEnabled) {
            return LogLevel.INFO;
        }
        if (warnEnabled) {
            return LogLevel.WARN;
        }
        return LogLevel.OFF;
    }

    public LogLevel getEffectiveLogLevel() {
        return this.getLogLevel();
    }

    public Iterator getLogHandler() {
        return Collections.EMPTY_LIST.iterator();
    }
}

