/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.config;

import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.deployit.util.PasswordUtil;
import com.xebialabs.deployit.util.PropertyUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import javax.crypto.SecretKey;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public final class ServerConfigurationHelper$ {
    public static final ServerConfigurationHelper$ MODULE$ = new ServerConfigurationHelper$();
    private static final String ConfigAdminUser = "_xl-deploy-config-admin_";
    private static final String ConfigRole = "CONFIG_ADMIN";
    private static final File DEFAULT_CONFIGURATION_FILE = new File("conf", "deployit.conf");
    private static final PasswordEncrypter defaultEncrypter = new PasswordEncrypter(DeployitKeys.DEFAULT_PASSWORD_ENCRYPTION_KEY);
    private static final int HTTP_PORT = 8888;

    public String ConfigAdminUser() {
        return ConfigAdminUser;
    }

    public String ConfigRole() {
        return ConfigRole;
    }

    public File DEFAULT_CONFIGURATION_FILE() {
        return DEFAULT_CONFIGURATION_FILE;
    }

    private PasswordEncrypter defaultEncrypter() {
        return defaultEncrypter;
    }

    private int HTTP_PORT() {
        return HTTP_PORT;
    }

    /*
     * WARNING - void declaration
     */
    public ServerConfiguration init() {
        ServerConfiguration serverConfiguration;
        ServerConfigFile configFile = new ServerConfigFile(this.DEFAULT_CONFIGURATION_FILE());
        if (configFile.exists()) {
            serverConfiguration = configFile.loadConfig(false, false, true);
        } else {
            void var3_2;
            ServerConfiguration serverConfiguration2 = new ServerConfiguration(true);
            serverConfiguration2.loadDefault();
            serverConfiguration2.setHttpPort(this.HTTP_PORT());
            serverConfiguration = var3_2;
        }
        ServerConfiguration config = serverConfiguration;
        SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)config.getRepositoryKeyStorePassword());
        PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        this.encryptPasswords();
        ServerConfiguration.setInstance((ServerConfiguration)config);
        return config;
    }

    private void encryptPasswords() {
        if (this.DEFAULT_CONFIGURATION_FILE().exists()) {
            Properties properties = PropertyUtil.readPropertiesFile((File)this.DEFAULT_CONFIGURATION_FILE());
            ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(properties.stringPropertyNames()).asScala().filter((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)PasswordUtil.APPLICATION_PASSWORDS.contains(key)))).foreach((Function1 & Serializable)key -> {
                if ("repository.keystore.password".equals(key)) {
                    return properties.setProperty((String)key, MODULE$.defaultEncrypter().ensureEncrypted(properties.getProperty((String)key)));
                }
                PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
                return properties.setProperty((String)key, (String)Option$.MODULE$.apply((Object)properties.getProperty((String)key)).map((Function1 & Serializable)x$1 -> passwordEncrypter.ensureEncrypted(x$1)).get());
            });
            PropertyUtil.storePropertiesFile((File)this.DEFAULT_CONFIGURATION_FILE(), (Properties)properties);
            return;
        }
    }

    public Option<String> getAdminPassword() {
        if (ServerConfiguration.getInstance().getSpringCloudExternalConfig()) {
            return Option$.MODULE$.apply((Object)"admin");
        }
        PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
        return Option$.MODULE$.apply((Object)ServerConfiguration.getInstance().getAdminPassword()).map((Function1 & Serializable)x$1 -> passwordEncrypter.ensureDecrypted(x$1));
    }

    private ServerConfigurationHelper$() {
    }
}

