/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class MySQLServerConfiguration {
    private final int bytesPerCharacter;
    private final boolean noBackslashEscapesEnabled;

    public MySQLServerConfiguration(int bytesPerCharacter, boolean noBackslashEscapesEnabled) {
        this.bytesPerCharacter = bytesPerCharacter;
        this.noBackslashEscapesEnabled = noBackslashEscapesEnabled;
    }

    public int getBytesPerCharacter() {
        return this.bytesPerCharacter;
    }

    public boolean isNoBackslashEscapesEnabled() {
        return this.noBackslashEscapesEnabled;
    }

    public static MySQLServerConfiguration fromDialectResolutionInfo(DialectResolutionInfo info) {
        Integer bytesPerCharacter = null;
        Boolean noBackslashEscapes = null;
        DatabaseMetaData databaseMetaData = info.getDatabaseMetadata();
        if (databaseMetaData != null) {
            try (Statement s = databaseMetaData.getConnection().createStatement();){
                ResultSet rs = s.executeQuery("SELECT @@character_set_database, @@sql_mode");
                if (rs.next()) {
                    String characterSet = rs.getString(1);
                    int collationIndex = characterSet.indexOf(95);
                    switch (collationIndex == -1 ? characterSet : characterSet.substring(0, collationIndex)) {
                        case "utf16": 
                        case "utf16le": 
                        case "utf32": 
                        case "utf8mb4": 
                        case "gb18030": {
                            bytesPerCharacter = 4;
                        }
                        case "utf8": 
                        case "utf8mb3": 
                        case "eucjpms": 
                        case "ujis": {
                            bytesPerCharacter = 3;
                            break;
                        }
                        case "ucs2": 
                        case "cp932": 
                        case "big5": 
                        case "euckr": 
                        case "gb2312": 
                        case "gbk": 
                        case "sjis": {
                            bytesPerCharacter = 2;
                            break;
                        }
                        default: {
                            bytesPerCharacter = 1;
                        }
                    }
                    String sqlMode = rs.getString(2);
                    noBackslashEscapes = sqlMode.toLowerCase().contains("no_backslash_escapes");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (bytesPerCharacter == null) {
            bytesPerCharacter = ConfigurationHelper.getInt("hibernate.dialect.mysql.bytes_per_character", info.getConfigurationValues(), 4);
        }
        if (noBackslashEscapes == null) {
            noBackslashEscapes = ConfigurationHelper.getBoolean("hibernate.dialect.mysql.no_backslash_escapes", info.getConfigurationValues(), false);
        }
        return new MySQLServerConfiguration(bytesPerCharacter, noBackslashEscapes);
    }

    @Deprecated(since="6.4")
    public static MySQLServerConfiguration fromDatabaseMetadata(DatabaseMetaData databaseMetaData) {
        int bytesPerCharacter = 4;
        boolean noBackslashEscapes = false;
        if (databaseMetaData != null) {
            try (Statement s = databaseMetaData.getConnection().createStatement();){
                ResultSet rs = s.executeQuery("SELECT @@character_set_database, @@sql_mode");
                if (rs.next()) {
                    String characterSet = rs.getString(1);
                    int collationIndex = characterSet.indexOf(95);
                    switch (collationIndex == -1 ? characterSet : characterSet.substring(0, collationIndex)) {
                        case "utf16": 
                        case "utf16le": 
                        case "utf32": 
                        case "utf8mb4": 
                        case "gb18030": {
                            break;
                        }
                        case "utf8": 
                        case "utf8mb3": 
                        case "eucjpms": 
                        case "ujis": {
                            bytesPerCharacter = 3;
                            break;
                        }
                        case "ucs2": 
                        case "cp932": 
                        case "big5": 
                        case "euckr": 
                        case "gb2312": 
                        case "gbk": 
                        case "sjis": {
                            bytesPerCharacter = 2;
                            break;
                        }
                        default: {
                            bytesPerCharacter = 1;
                        }
                    }
                    String sqlMode = rs.getString(2);
                    if (sqlMode.toLowerCase().contains("no_backslash_escapes")) {
                        noBackslashEscapes = true;
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return new MySQLServerConfiguration(bytesPerCharacter, noBackslashEscapes);
    }
}

