/*
 * Decompiled with CFR 0.152.
 */
package com.tqdev.metrics.core;

import com.tqdev.metrics.core.Gauge;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;

public class MetricRegistry {
    protected volatile ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> values = new ConcurrentHashMap();
    protected boolean enabled;
    private static final MetricRegistry instance = new MetricRegistry();

    public MetricRegistry() {
        this.enabled = true;
    }

    public MetricRegistry(boolean enabled) {
        this.enabled = enabled;
    }

    public void reset() {
        for (Map.Entry<String, ConcurrentHashMap<String, Object>> entry : this.values.entrySet()) {
            entry.getValue().clear();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean increment(String type, String key) {
        Object o = this.values.computeIfAbsent(type, t -> new ConcurrentHashMap()).computeIfAbsent(key, k -> new LongAdder());
        if (o instanceof LongAdder) {
            ((LongAdder)o).increment();
            return true;
        }
        return false;
    }

    public boolean decrement(String type, String key) {
        Object o = this.values.computeIfAbsent(type, t -> new ConcurrentHashMap()).computeIfAbsent(key, k -> new LongAdder());
        if (o instanceof LongAdder) {
            ((LongAdder)o).decrement();
            return true;
        }
        return false;
    }

    public boolean add(String type, String key, long value) {
        Object o = this.values.computeIfAbsent(type, t -> new ConcurrentHashMap()).computeIfAbsent(key, k -> new LongAdder());
        if (o instanceof LongAdder) {
            ((LongAdder)o).add(value);
            return true;
        }
        return false;
    }

    public void set(String type, String key, long value) {
        LongAdder adder = new LongAdder();
        adder.add(value);
        this.values.computeIfAbsent(type, t -> new ConcurrentHashMap()).put(key, adder);
    }

    public void set(String type, String key, Gauge value) {
        this.values.computeIfAbsent(type, t -> new ConcurrentHashMap()).put(key, value);
    }

    public Iterable<String> getTypes() {
        return this.values.keySet();
    }

    public Iterable<String> getKeys(String type) {
        ConcurrentHashMap<String, Object> map = this.values.get(type);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    public boolean has(String type, String key) {
        ConcurrentHashMap<String, Object> map = this.values.get(type);
        if (map == null) {
            return false;
        }
        return map.containsKey(key);
    }

    public boolean hasType(String type) {
        return this.values.containsKey(type);
    }

    public long get(String type, String key) {
        ConcurrentHashMap<String, Object> map = this.values.get(type);
        if (map != null) {
            Object o = map.get(key);
            if (o instanceof LongAdder) {
                return ((LongAdder)o).sum();
            }
            if (o instanceof Gauge) {
                return ((Gauge)o).measure();
            }
        }
        return 0L;
    }

    public long getNanos() {
        return System.nanoTime();
    }

    public long getMillis() {
        return System.currentTimeMillis();
    }

    public static MetricRegistry getInstance() {
        return instance;
    }
}

