/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.util.logging.Log;

public class SingleFileStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<SingleFileStoreConfiguration, SingleFileStoreConfigurationBuilder> {
    public SingleFileStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        this(builder, SingleFileStoreConfiguration.attributeDefinitionSet());
    }

    public SingleFileStoreConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributeSet) {
        super(builder, attributeSet);
    }

    public SingleFileStoreConfigurationBuilder self() {
        return this;
    }

    public SingleFileStoreConfigurationBuilder location(String location) {
        this.attributes.attribute(SingleFileStoreConfiguration.LOCATION).set((Object)location);
        return this;
    }

    @Deprecated(forRemoval=true)
    public SingleFileStoreConfigurationBuilder maxEntries(int maxEntries) {
        this.attributes.attribute(SingleFileStoreConfiguration.MAX_ENTRIES).set((Object)maxEntries);
        return this;
    }

    public SingleFileStoreConfigurationBuilder fragmentationFactor(float fragmentationFactor) {
        this.attributes.attribute(SingleFileStoreConfiguration.FRAGMENTATION_FACTOR).set((Object)Float.valueOf(fragmentationFactor));
        return this;
    }

    @Override
    public void validate() {
        Attribute segmentedAttribute = this.attributes.attribute(AbstractStoreConfiguration.SEGMENTED);
        Attribute maxEntriesAttribute = this.attributes.attribute(SingleFileStoreConfiguration.MAX_ENTRIES);
        if (((Boolean)segmentedAttribute.get()).booleanValue() && (Integer)maxEntriesAttribute.get() > 0) {
            throw Log.CONFIG.segmentedSingleFileStoreDoesNotSupportMaxEntries();
        }
        super.validate();
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        PersistenceUtil.validateGlobalStateStoreLocation(globalConfig, SingleFileStore.class.getSimpleName(), this.attributes.attribute(SingleFileStoreConfiguration.LOCATION));
        super.validate(globalConfig);
    }

    public SingleFileStoreConfiguration create() {
        return new SingleFileStoreConfiguration(this.attributes.protect(), this.async.create());
    }

    @Override
    public Builder<?> read(SingleFileStoreConfiguration template, Combine combine) {
        super.read(template, combine);
        return this;
    }
}

