/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.number.AffixPatternUtils;
import com.ibm.icu.impl.number.Endpoint;
import com.ibm.icu.impl.number.Format;
import com.ibm.icu.impl.number.FormatQuantity;
import com.ibm.icu.impl.number.FormatQuantity4;
import com.ibm.icu.impl.number.Parse;
import com.ibm.icu.impl.number.PatternString;
import com.ibm.icu.impl.number.Properties;
import com.ibm.icu.impl.number.formatters.CurrencyFormat;
import com.ibm.icu.impl.number.formatters.PaddingFormat;
import com.ibm.icu.impl.number.formatters.PositiveDecimalFormat;
import com.ibm.icu.impl.number.formatters.ScientificFormat;
import com.ibm.icu.impl.number.rounders.SignificantDigitsRounder;
import com.ibm.icu.text.CurrencyPluralInfo;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.CurrencyAmount;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;

public class DecimalFormat
extends NumberFormat {
    private static final long serialVersionUID = 864413376551465018L;
    private final int serialVersionOnStream = 5;
    transient Properties properties;
    volatile transient DecimalFormatSymbols symbols;
    volatile transient Format.SingularFormat formatter;
    volatile transient Properties exportedProperties;
    private transient int icuMathContextForm = 0;
    private static final ThreadLocal<Properties> threadLocalProperties = new ThreadLocal<Properties>(){

        @Override
        protected Properties initialValue() {
            return new Properties();
        }
    };
    public static final int PAD_BEFORE_PREFIX = 0;
    public static final int PAD_AFTER_PREFIX = 1;
    public static final int PAD_BEFORE_SUFFIX = 2;
    public static final int PAD_AFTER_SUFFIX = 3;

    public DecimalFormat() {
        ULocale def = ULocale.getDefault(ULocale.Category.FORMAT);
        String pattern = DecimalFormat.getPattern(def, 0);
        this.symbols = DecimalFormat.getDefaultSymbols();
        this.properties = new Properties();
        this.exportedProperties = new Properties();
        boolean ignorePatternRounding = AffixPatternUtils.hasCurrencySymbols(pattern);
        this.setPropertiesFromPattern(pattern, ignorePatternRounding);
        this.refreshFormatter();
    }

    public DecimalFormat(String pattern) {
        this.symbols = DecimalFormat.getDefaultSymbols();
        this.properties = new Properties();
        this.exportedProperties = new Properties();
        boolean ignorePatternRounding = AffixPatternUtils.hasCurrencySymbols(pattern);
        this.setPropertiesFromPattern(pattern, ignorePatternRounding);
        this.refreshFormatter();
    }

    public DecimalFormat(String pattern, DecimalFormatSymbols symbols) {
        this.symbols = (DecimalFormatSymbols)symbols.clone();
        this.properties = new Properties();
        this.exportedProperties = new Properties();
        boolean ignorePatternRounding = AffixPatternUtils.hasCurrencySymbols(pattern);
        this.setPropertiesFromPattern(pattern, ignorePatternRounding);
        this.refreshFormatter();
    }

    public DecimalFormat(String pattern, DecimalFormatSymbols symbols, CurrencyPluralInfo infoInput, int style) {
        this(pattern, symbols, style);
        this.properties.setCurrencyPluralInfo(infoInput);
        this.refreshFormatter();
    }

    DecimalFormat(String pattern, DecimalFormatSymbols symbols, int choice) {
        this.symbols = (DecimalFormatSymbols)symbols.clone();
        this.properties = new Properties();
        this.exportedProperties = new Properties();
        if (choice == 1 || choice == 5 || choice == 7 || choice == 8 || choice == 9 || choice == 6 || AffixPatternUtils.hasCurrencySymbols(pattern)) {
            this.setPropertiesFromPattern(pattern, true);
        } else {
            this.setPropertiesFromPattern(pattern, false);
        }
        this.refreshFormatter();
    }

    private static DecimalFormatSymbols getDefaultSymbols() {
        return DecimalFormatSymbols.getInstance();
    }

    public synchronized void applyPattern(String pattern) {
        this.setPropertiesFromPattern(pattern, false);
        this.properties.setPositivePrefix(null);
        this.properties.setNegativePrefix(null);
        this.properties.setPositiveSuffix(null);
        this.properties.setNegativeSuffix(null);
        this.properties.setCurrencyPluralInfo(null);
        this.refreshFormatter();
    }

    public synchronized void applyLocalizedPattern(String localizedPattern) {
        String pattern = PatternString.convertLocalized(localizedPattern, this.symbols, false);
        this.applyPattern(pattern);
    }

    @Override
    public Object clone() {
        DecimalFormat other = (DecimalFormat)super.clone();
        other.symbols = (DecimalFormatSymbols)this.symbols.clone();
        other.properties = this.properties.clone();
        other.exportedProperties = new Properties();
        other.refreshFormatter();
        return other;
    }

    private synchronized void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(0);
        oos.writeObject(this.properties);
        oos.writeObject(this.symbols);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fieldGetter = ois.readFields();
        ObjectStreamField[] serializedFields = fieldGetter.getObjectStreamClass().getFields();
        int serialVersion = fieldGetter.get("serialVersionOnStream", -1);
        if (serialVersion > 5) {
            throw new IOException("Cannot deserialize newer com.ibm.icu.text.DecimalFormat (v" + serialVersion + ")");
        }
        if (serialVersion == 5) {
            if (serializedFields.length > 1) {
                throw new IOException("Too many fields when reading serial version 5");
            }
            ois.readInt();
            this.properties = (Properties)ois.readObject();
            this.symbols = (DecimalFormatSymbols)ois.readObject();
            this.exportedProperties = new Properties();
            this.refreshFormatter();
        } else {
            this.properties = new Properties();
            String pp = null;
            String ppp = null;
            String ps = null;
            String psp = null;
            String np = null;
            String npp = null;
            String ns = null;
            String nsp = null;
            for (ObjectStreamField field : serializedFields) {
                String name = field.getName();
                if (name.equals("decimalSeparatorAlwaysShown")) {
                    this.setDecimalSeparatorAlwaysShown(fieldGetter.get("decimalSeparatorAlwaysShown", false));
                    continue;
                }
                if (name.equals("exponentSignAlwaysShown")) {
                    this.setExponentSignAlwaysShown(fieldGetter.get("exponentSignAlwaysShown", false));
                    continue;
                }
                if (name.equals("formatWidth")) {
                    this.setFormatWidth(fieldGetter.get("formatWidth", 0));
                    continue;
                }
                if (name.equals("groupingSize")) {
                    this.setGroupingSize(fieldGetter.get("groupingSize", (byte)3));
                    continue;
                }
                if (name.equals("groupingSize2")) {
                    this.setSecondaryGroupingSize(fieldGetter.get("groupingSize2", (byte)0));
                    continue;
                }
                if (name.equals("maxSignificantDigits")) {
                    this.setMaximumSignificantDigits(fieldGetter.get("maxSignificantDigits", 6));
                    continue;
                }
                if (name.equals("minExponentDigits")) {
                    this.setMinimumExponentDigits(fieldGetter.get("minExponentDigits", (byte)0));
                    continue;
                }
                if (name.equals("minSignificantDigits")) {
                    this.setMinimumSignificantDigits(fieldGetter.get("minSignificantDigits", 1));
                    continue;
                }
                if (name.equals("multiplier")) {
                    this.setMultiplier(fieldGetter.get("multiplier", 1));
                    continue;
                }
                if (name.equals("pad")) {
                    this.setPadCharacter(fieldGetter.get("pad", ' '));
                    continue;
                }
                if (name.equals("padPosition")) {
                    this.setPadPosition(fieldGetter.get("padPosition", 0));
                    continue;
                }
                if (name.equals("parseBigDecimal")) {
                    this.setParseBigDecimal(fieldGetter.get("parseBigDecimal", false));
                    continue;
                }
                if (name.equals("parseRequireDecimalPoint")) {
                    this.setDecimalPatternMatchRequired(fieldGetter.get("parseRequireDecimalPoint", false));
                    continue;
                }
                if (name.equals("roundingMode")) {
                    this.setRoundingMode(fieldGetter.get("roundingMode", 0));
                    continue;
                }
                if (name.equals("useExponentialNotation")) {
                    this.setScientificNotation(fieldGetter.get("useExponentialNotation", false));
                    continue;
                }
                if (name.equals("useSignificantDigits")) {
                    this.setSignificantDigitsUsed(fieldGetter.get("useSignificantDigits", false));
                    continue;
                }
                if (name.equals("currencyPluralInfo")) {
                    this.setCurrencyPluralInfo((CurrencyPluralInfo)fieldGetter.get("currencyPluralInfo", null));
                    continue;
                }
                if (name.equals("mathContext")) {
                    this.setMathContextICU((com.ibm.icu.math.MathContext)fieldGetter.get("mathContext", null));
                    continue;
                }
                if (name.equals("negPrefixPattern")) {
                    npp = (String)fieldGetter.get("negPrefixPattern", null);
                    continue;
                }
                if (name.equals("negSuffixPattern")) {
                    nsp = (String)fieldGetter.get("negSuffixPattern", null);
                    continue;
                }
                if (name.equals("negativePrefix")) {
                    np = (String)fieldGetter.get("negativePrefix", null);
                    continue;
                }
                if (name.equals("negativeSuffix")) {
                    ns = (String)fieldGetter.get("negativeSuffix", null);
                    continue;
                }
                if (name.equals("posPrefixPattern")) {
                    ppp = (String)fieldGetter.get("posPrefixPattern", null);
                    continue;
                }
                if (name.equals("posSuffixPattern")) {
                    psp = (String)fieldGetter.get("posSuffixPattern", null);
                    continue;
                }
                if (name.equals("positivePrefix")) {
                    pp = (String)fieldGetter.get("positivePrefix", null);
                    continue;
                }
                if (name.equals("positiveSuffix")) {
                    ps = (String)fieldGetter.get("positiveSuffix", null);
                    continue;
                }
                if (name.equals("roundingIncrement")) {
                    this.setRoundingIncrement((BigDecimal)fieldGetter.get("roundingIncrement", null));
                    continue;
                }
                if (!name.equals("symbols")) continue;
                this.setDecimalFormatSymbols((DecimalFormatSymbols)fieldGetter.get("symbols", null));
            }
            if (npp == null) {
                this.properties.setNegativePrefix(np);
            } else {
                this.properties.setNegativePrefixPattern(npp);
            }
            if (nsp == null) {
                this.properties.setNegativeSuffix(ns);
            } else {
                this.properties.setNegativeSuffixPattern(nsp);
            }
            if (ppp == null) {
                this.properties.setPositivePrefix(pp);
            } else {
                this.properties.setPositivePrefixPattern(ppp);
            }
            if (psp == null) {
                this.properties.setPositiveSuffix(ps);
            } else {
                this.properties.setPositiveSuffixPattern(psp);
            }
            try {
                Field getter = NumberFormat.class.getDeclaredField("groupingUsed");
                getter.setAccessible(true);
                this.setGroupingUsed((Boolean)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("parseIntegerOnly");
                getter.setAccessible(true);
                this.setParseIntegerOnly((Boolean)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("maximumIntegerDigits");
                getter.setAccessible(true);
                this.setMaximumIntegerDigits((Integer)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("minimumIntegerDigits");
                getter.setAccessible(true);
                this.setMinimumIntegerDigits((Integer)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("maximumFractionDigits");
                getter.setAccessible(true);
                this.setMaximumFractionDigits((Integer)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("minimumFractionDigits");
                getter.setAccessible(true);
                this.setMinimumFractionDigits((Integer)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("currency");
                getter.setAccessible(true);
                this.setCurrency((Currency)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("parseStrict");
                getter.setAccessible(true);
                this.setParseStrict((Boolean)getter.get(this));
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (NoSuchFieldException e) {
                throw new IOException(e);
            }
            catch (SecurityException e) {
                throw new IOException(e);
            }
            if (this.symbols == null) {
                this.symbols = DecimalFormat.getDefaultSymbols();
            }
            this.exportedProperties = new Properties();
            this.refreshFormatter();
        }
    }

    @Override
    public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        FormatQuantity4 fq = new FormatQuantity4(number);
        this.formatter.format((FormatQuantity)fq, result, fieldPosition);
        fq.populateUFieldPosition(fieldPosition);
        return result;
    }

    @Override
    public StringBuffer format(long number, StringBuffer result, FieldPosition fieldPosition) {
        FormatQuantity4 fq = new FormatQuantity4(number);
        this.formatter.format((FormatQuantity)fq, result, fieldPosition);
        fq.populateUFieldPosition(fieldPosition);
        return result;
    }

    @Override
    public StringBuffer format(BigInteger number, StringBuffer result, FieldPosition fieldPosition) {
        FormatQuantity4 fq = new FormatQuantity4(number);
        this.formatter.format((FormatQuantity)fq, result, fieldPosition);
        fq.populateUFieldPosition(fieldPosition);
        return result;
    }

    @Override
    public StringBuffer format(BigDecimal number, StringBuffer result, FieldPosition fieldPosition) {
        FormatQuantity4 fq = new FormatQuantity4(number);
        this.formatter.format((FormatQuantity)fq, result, fieldPosition);
        fq.populateUFieldPosition(fieldPosition);
        return result;
    }

    @Override
    public StringBuffer format(com.ibm.icu.math.BigDecimal number, StringBuffer result, FieldPosition fieldPosition) {
        FormatQuantity4 fq = new FormatQuantity4(number.toBigDecimal());
        this.formatter.format((FormatQuantity)fq, result, fieldPosition);
        fq.populateUFieldPosition(fieldPosition);
        return result;
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        if (!(obj instanceof Number)) {
            throw new IllegalArgumentException();
        }
        Number number = (Number)obj;
        FormatQuantity4 fq = new FormatQuantity4(number);
        AttributedCharacterIterator result = this.formatter.formatToCharacterIterator(fq);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer format(CurrencyAmount currAmt, StringBuffer toAppendTo, FieldPosition pos) {
        Properties cprops = threadLocalProperties.get();
        Format.SingularFormat fmt = null;
        DecimalFormat decimalFormat = this;
        synchronized (decimalFormat) {
            if (currAmt.getCurrency().equals(this.properties.getCurrency())) {
                fmt = this.formatter;
            } else {
                cprops.copyFrom(this.properties);
            }
        }
        if (fmt == null) {
            cprops.setCurrency(currAmt.getCurrency());
            fmt = Endpoint.fromBTA(cprops, this.symbols);
        }
        FormatQuantity4 fq = new FormatQuantity4(currAmt.getNumber());
        fmt.format((FormatQuantity)fq, toAppendTo, pos);
        fq.populateUFieldPosition(pos);
        return toAppendTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Number parse(String text, ParsePosition parsePosition) {
        Properties pprops = threadLocalProperties.get();
        DecimalFormat decimalFormat = this;
        synchronized (decimalFormat) {
            pprops.copyFrom(this.properties);
        }
        Number result = Parse.parse(text, parsePosition, pprops, this.symbols);
        if (result instanceof BigDecimal) {
            result = new com.ibm.icu.math.BigDecimal((BigDecimal)result);
        }
        return result;
    }

    @Override
    public CurrencyAmount parseCurrency(CharSequence text, ParsePosition parsePosition) {
        try {
            CurrencyAmount result = Parse.parseCurrency(text, parsePosition, this.properties, this.symbols);
            if (result == null) {
                return null;
            }
            Number number = result.getNumber();
            if (number instanceof BigDecimal) {
                number = new com.ibm.icu.math.BigDecimal((BigDecimal)number);
                result = new CurrencyAmount(number, result.getCurrency());
            }
            return result;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public synchronized DecimalFormatSymbols getDecimalFormatSymbols() {
        return (DecimalFormatSymbols)this.symbols.clone();
    }

    public synchronized void setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        this.symbols = (DecimalFormatSymbols)newSymbols.clone();
        this.refreshFormatter();
    }

    public synchronized String getPositivePrefix() {
        String result = this.exportedProperties.getPositivePrefix();
        return result == null ? "" : result;
    }

    public synchronized void setPositivePrefix(String prefix) {
        this.properties.setPositivePrefix(prefix);
        this.refreshFormatter();
    }

    public synchronized String getNegativePrefix() {
        String result = this.exportedProperties.getNegativePrefix();
        return result == null ? "" : result;
    }

    public synchronized void setNegativePrefix(String suffix) {
        this.properties.setNegativePrefix(suffix);
        this.refreshFormatter();
    }

    public synchronized String getPositiveSuffix() {
        String result = this.exportedProperties.getPositiveSuffix();
        return result == null ? "" : result;
    }

    public synchronized void setPositiveSuffix(String suffix) {
        this.properties.setPositiveSuffix(suffix);
        this.refreshFormatter();
    }

    public synchronized String getNegativeSuffix() {
        String result = this.exportedProperties.getNegativeSuffix();
        return result == null ? "" : result;
    }

    public synchronized void setNegativeSuffix(String suffix) {
        this.properties.setNegativeSuffix(suffix);
        this.refreshFormatter();
    }

    @Deprecated
    public synchronized boolean getSignAlwaysShown() {
        return this.properties.getSignAlwaysShown();
    }

    @Deprecated
    public synchronized void setSignAlwaysShown(boolean value) {
        this.properties.setSignAlwaysShown(value);
        this.refreshFormatter();
    }

    public synchronized int getMultiplier() {
        if (this.properties.getMultiplier() != null) {
            return this.properties.getMultiplier().intValue();
        }
        return (int)Math.pow(10.0, this.properties.getMagnitudeMultiplier());
    }

    public synchronized void setMultiplier(int multiplier) {
        if (multiplier == 0) {
            throw new IllegalArgumentException("Multiplier must be nonzero.");
        }
        int delta = 0;
        int value = multiplier;
        while (multiplier != 1) {
            ++delta;
            int temp = value / 10;
            if (temp * 10 != value) {
                delta = -1;
                break;
            }
            value = temp;
        }
        if (delta != -1) {
            this.properties.setMagnitudeMultiplier(delta);
        } else {
            this.properties.setMultiplier(BigDecimal.valueOf(multiplier));
        }
        this.refreshFormatter();
    }

    public synchronized BigDecimal getRoundingIncrement() {
        return this.exportedProperties.getRoundingIncrement();
    }

    public synchronized void setRoundingIncrement(BigDecimal increment) {
        if (increment != null && increment.compareTo(BigDecimal.ZERO) == 0) {
            this.properties.setMaximumFractionDigits(Integer.MAX_VALUE);
            return;
        }
        this.properties.setRoundingIncrement(increment);
        this.refreshFormatter();
    }

    public synchronized void setRoundingIncrement(com.ibm.icu.math.BigDecimal increment) {
        BigDecimal javaBigDecimal = increment == null ? null : increment.toBigDecimal();
        this.setRoundingIncrement(javaBigDecimal);
    }

    public synchronized void setRoundingIncrement(double increment) {
        if (increment == 0.0) {
            this.setRoundingIncrement((BigDecimal)null);
        } else {
            BigDecimal javaBigDecimal = BigDecimal.valueOf(increment);
            this.setRoundingIncrement(javaBigDecimal);
        }
    }

    @Override
    public synchronized int getRoundingMode() {
        RoundingMode mode = this.exportedProperties.getRoundingMode();
        return mode == null ? 0 : mode.ordinal();
    }

    @Override
    public synchronized void setRoundingMode(int roundingMode) {
        this.properties.setRoundingMode(RoundingMode.valueOf(roundingMode));
        this.refreshFormatter();
    }

    public synchronized MathContext getMathContext() {
        MathContext mathContext = this.exportedProperties.getMathContext();
        assert (mathContext != null);
        return mathContext;
    }

    public synchronized void setMathContext(MathContext mathContext) {
        this.properties.setMathContext(mathContext);
        this.refreshFormatter();
    }

    public synchronized com.ibm.icu.math.MathContext getMathContextICU() {
        MathContext mathContext = this.getMathContext();
        return new com.ibm.icu.math.MathContext(mathContext.getPrecision(), this.icuMathContextForm, false, mathContext.getRoundingMode().ordinal());
    }

    public synchronized void setMathContextICU(com.ibm.icu.math.MathContext mathContextICU) {
        this.icuMathContextForm = mathContextICU.getForm();
        MathContext mathContext = mathContextICU.getLostDigits() ? new MathContext(mathContextICU.getDigits(), RoundingMode.UNNECESSARY) : new MathContext(mathContextICU.getDigits(), RoundingMode.valueOf(mathContextICU.getRoundingMode()));
        this.setMathContext(mathContext);
    }

    @Override
    public synchronized int getMinimumIntegerDigits() {
        return this.exportedProperties.getMinimumIntegerDigits();
    }

    @Override
    public synchronized void setMinimumIntegerDigits(int value) {
        this.properties.setMinimumIntegerDigits(value);
        this.refreshFormatter();
    }

    @Override
    public synchronized int getMaximumIntegerDigits() {
        return this.exportedProperties.getMaximumIntegerDigits();
    }

    @Override
    public synchronized void setMaximumIntegerDigits(int value) {
        this.properties.setMaximumIntegerDigits(value);
        this.refreshFormatter();
    }

    @Override
    public synchronized int getMinimumFractionDigits() {
        return this.exportedProperties.getMinimumFractionDigits();
    }

    @Override
    public synchronized void setMinimumFractionDigits(int value) {
        this.properties.setMinimumFractionDigits(value);
        this.refreshFormatter();
    }

    @Override
    public synchronized int getMaximumFractionDigits() {
        return this.exportedProperties.getMaximumFractionDigits();
    }

    @Override
    public synchronized void setMaximumFractionDigits(int value) {
        this.properties.setMaximumFractionDigits(value);
        this.refreshFormatter();
    }

    public synchronized boolean areSignificantDigitsUsed() {
        return SignificantDigitsRounder.useSignificantDigits(this.properties);
    }

    public synchronized void setSignificantDigitsUsed(boolean useSignificantDigits) {
        if (useSignificantDigits) {
            this.properties.setMinimumSignificantDigits(1);
            this.properties.setMaximumSignificantDigits(6);
        } else {
            this.properties.setMinimumSignificantDigits(-1);
            this.properties.setMaximumSignificantDigits(-1);
            this.properties.setSignificantDigitsMode(null);
        }
        this.refreshFormatter();
    }

    public synchronized int getMinimumSignificantDigits() {
        return this.exportedProperties.getMinimumSignificantDigits();
    }

    public synchronized void setMinimumSignificantDigits(int value) {
        this.properties.setMinimumSignificantDigits(value);
        this.refreshFormatter();
    }

    public synchronized int getMaximumSignificantDigits() {
        return this.exportedProperties.getMaximumSignificantDigits();
    }

    public synchronized void setMaximumSignificantDigits(int value) {
        this.properties.setMaximumSignificantDigits(value);
        this.refreshFormatter();
    }

    @Deprecated
    public synchronized SignificantDigitsMode getSignificantDigitsMode() {
        return this.exportedProperties.getSignificantDigitsMode();
    }

    @Deprecated
    public synchronized void setSignificantDigitsMode(SignificantDigitsMode mode) {
        this.properties.setSignificantDigitsMode(mode);
        this.refreshFormatter();
    }

    public synchronized int getFormatWidth() {
        return this.exportedProperties.getFormatWidth();
    }

    public synchronized void setFormatWidth(int width) {
        this.properties.setFormatWidth(width);
        this.refreshFormatter();
    }

    public synchronized char getPadCharacter() {
        String paddingString = this.exportedProperties.getPadString();
        if (paddingString == null) {
            return '.';
        }
        return paddingString.charAt(0);
    }

    public synchronized void setPadCharacter(char padChar) {
        this.properties.setPadString(Character.toString(padChar));
        this.refreshFormatter();
    }

    public synchronized int getPadPosition() {
        PaddingFormat.PadPosition loc = this.exportedProperties.getPadPosition();
        return loc == null ? 0 : loc.toOld();
    }

    public synchronized void setPadPosition(int padPos) {
        this.properties.setPadPosition(PaddingFormat.PadPosition.fromOld(padPos));
        this.refreshFormatter();
    }

    public synchronized boolean isScientificNotation() {
        return ScientificFormat.useScientificNotation(this.properties);
    }

    public synchronized void setScientificNotation(boolean useScientific) {
        if (useScientific) {
            this.properties.setMinimumExponentDigits(1);
        } else {
            this.properties.setMinimumExponentDigits(-1);
        }
        this.refreshFormatter();
    }

    public synchronized byte getMinimumExponentDigits() {
        return (byte)this.exportedProperties.getMinimumExponentDigits();
    }

    public synchronized void setMinimumExponentDigits(byte minExpDig) {
        this.properties.setMinimumExponentDigits(minExpDig);
        this.refreshFormatter();
    }

    public synchronized boolean isExponentSignAlwaysShown() {
        return this.exportedProperties.getExponentSignAlwaysShown();
    }

    public synchronized void setExponentSignAlwaysShown(boolean expSignAlways) {
        this.properties.setExponentSignAlwaysShown(expSignAlways);
        this.refreshFormatter();
    }

    @Override
    public synchronized boolean isGroupingUsed() {
        return PositiveDecimalFormat.useGrouping(this.properties);
    }

    @Override
    public synchronized void setGroupingUsed(boolean enabled) {
        if (enabled) {
            this.properties.setGroupingSize(3);
        } else {
            this.properties.setGroupingSize(-1);
            this.properties.setSecondaryGroupingSize(-1);
        }
        this.refreshFormatter();
    }

    public synchronized int getGroupingSize() {
        return this.exportedProperties.getGroupingSize();
    }

    public synchronized void setGroupingSize(int width) {
        this.properties.setGroupingSize(width);
        this.refreshFormatter();
    }

    public synchronized int getSecondaryGroupingSize() {
        return this.exportedProperties.getSecondaryGroupingSize();
    }

    public synchronized void setSecondaryGroupingSize(int width) {
        this.properties.setSecondaryGroupingSize(width);
        this.refreshFormatter();
    }

    @Deprecated
    public synchronized int getMinimumGroupingDigits() {
        return this.properties.getMinimumGroupingDigits();
    }

    @Deprecated
    public synchronized void setMinimumGroupingDigits(int number) {
        this.properties.setMinimumGroupingDigits(number);
        this.refreshFormatter();
    }

    public synchronized boolean isDecimalSeparatorAlwaysShown() {
        return this.exportedProperties.getDecimalSeparatorAlwaysShown();
    }

    public synchronized void setDecimalSeparatorAlwaysShown(boolean value) {
        this.properties.setDecimalSeparatorAlwaysShown(value);
        this.refreshFormatter();
    }

    @Override
    public synchronized Currency getCurrency() {
        return this.properties.getCurrency();
    }

    @Override
    public synchronized void setCurrency(Currency currency) {
        this.properties.setCurrency(currency);
        if (currency != null) {
            this.symbols.setCurrency(currency);
            String symbol = currency.getName(this.symbols.getULocale(), 0, null);
            this.symbols.setCurrencySymbol(symbol);
        }
        this.refreshFormatter();
    }

    public synchronized Currency.CurrencyUsage getCurrencyUsage() {
        Currency.CurrencyUsage usage = this.properties.getCurrencyUsage();
        if (usage == null) {
            usage = Currency.CurrencyUsage.STANDARD;
        }
        return usage;
    }

    public synchronized void setCurrencyUsage(Currency.CurrencyUsage usage) {
        this.properties.setCurrencyUsage(usage);
        this.refreshFormatter();
    }

    public synchronized CurrencyPluralInfo getCurrencyPluralInfo() {
        return this.properties.getCurrencyPluralInfo();
    }

    public synchronized void setCurrencyPluralInfo(CurrencyPluralInfo newInfo) {
        this.properties.setCurrencyPluralInfo(newInfo);
        this.refreshFormatter();
    }

    public synchronized boolean isParseBigDecimal() {
        return this.properties.getParseToBigDecimal();
    }

    public synchronized void setParseBigDecimal(boolean value) {
        this.properties.setParseToBigDecimal(value);
    }

    @Deprecated
    public int getParseMaxDigits() {
        return 1000;
    }

    @Deprecated
    public void setParseMaxDigits(int maxDigits) {
    }

    @Override
    public synchronized boolean isParseStrict() {
        return this.properties.getParseMode() == Parse.ParseMode.STRICT;
    }

    @Override
    public synchronized void setParseStrict(boolean parseStrict) {
        Parse.ParseMode mode = parseStrict ? Parse.ParseMode.STRICT : Parse.ParseMode.LENIENT;
        this.properties.setParseMode(mode);
    }

    @Override
    public synchronized boolean isParseIntegerOnly() {
        return this.properties.getParseIntegerOnly();
    }

    @Override
    public synchronized void setParseIntegerOnly(boolean parseIntegerOnly) {
        this.properties.setParseIntegerOnly(parseIntegerOnly);
    }

    public synchronized boolean isDecimalPatternMatchRequired() {
        return this.properties.getDecimalPatternMatchRequired();
    }

    public synchronized void setDecimalPatternMatchRequired(boolean value) {
        this.properties.setDecimalPatternMatchRequired(value);
        this.refreshFormatter();
    }

    @Deprecated
    public synchronized boolean getParseNoExponent() {
        return this.properties.getParseNoExponent();
    }

    @Deprecated
    public synchronized void setParseNoExponent(boolean value) {
        this.properties.setParseNoExponent(value);
        this.refreshFormatter();
    }

    @Deprecated
    public synchronized boolean getParseCaseSensitive() {
        return this.properties.getParseCaseSensitive();
    }

    @Deprecated
    public synchronized void setParseCaseSensitive(boolean value) {
        this.properties.setParseCaseSensitive(value);
        this.refreshFormatter();
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DecimalFormat)) {
            return false;
        }
        DecimalFormat other = (DecimalFormat)obj;
        return this.properties.equals(other.properties) && this.symbols.equals(other.symbols);
    }

    @Override
    public synchronized int hashCode() {
        return this.properties.hashCode() ^ this.symbols.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName());
        result.append("@");
        result.append(Integer.toHexString(this.hashCode()));
        result.append(" { symbols@");
        result.append(Integer.toHexString(this.symbols.hashCode()));
        DecimalFormat decimalFormat = this;
        synchronized (decimalFormat) {
            this.properties.toStringBare(result);
        }
        result.append(" }");
        return result.toString();
    }

    public synchronized String toPattern() {
        Properties tprops = threadLocalProperties.get().copyFrom(this.properties);
        if (CurrencyFormat.useCurrency(this.properties)) {
            tprops.setMinimumFractionDigits(this.exportedProperties.getMinimumFractionDigits());
            tprops.setMaximumFractionDigits(this.exportedProperties.getMaximumFractionDigits());
            tprops.setRoundingIncrement(this.exportedProperties.getRoundingIncrement());
        }
        return PatternString.propertiesToString(tprops);
    }

    public synchronized String toLocalizedPattern() {
        String pattern = this.toPattern();
        return PatternString.convertLocalized(pattern, this.symbols, true);
    }

    @Deprecated
    public PluralRules.IFixedDecimal getFixedDecimal(double number) {
        FormatQuantity4 fq = new FormatQuantity4(number);
        this.formatter.format((FormatQuantity)fq);
        return fq;
    }

    void refreshFormatter() {
        if (this.exportedProperties == null) {
            return;
        }
        this.formatter = Endpoint.fromBTA(this.properties, this.symbols);
        this.exportedProperties.clear();
        this.formatter.export(this.exportedProperties);
    }

    void setPropertiesFromPattern(String pattern, boolean ignoreRounding) {
        PatternString.parseToExistingProperties(pattern, this.properties, ignoreRounding);
    }

    @Deprecated
    public synchronized void setProperties(PropertySetter func) {
        func.set(this.properties);
        this.refreshFormatter();
    }

    @Deprecated
    public static enum SignificantDigitsMode {
        OVERRIDE_MAXIMUM_FRACTION,
        RESPECT_MAXIMUM_FRACTION,
        ENSURE_MINIMUM_SIGNIFICANT;

    }

    @Deprecated
    public static interface PropertySetter {
        @Deprecated
        public void set(Properties var1);
    }
}

