/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.api.client.util.Base64;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.services.compute.model.CustomerEncryptionKey;
import com.google.api.services.compute.model.DeprecationStatus;
import com.google.api.services.compute.model.GuestOsFeature;
import com.google.api.services.compute.model.InitialStateConfig;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public final class Image
extends GenericJson {
    @Key
    private String architecture;
    @Key
    @JsonString
    private Long archiveSizeBytes;
    @Key
    private String creationTimestamp;
    @Key
    private DeprecationStatus deprecated;
    @Key
    private String description;
    @Key
    @JsonString
    private Long diskSizeGb;
    @Key
    private String family;
    @Key
    private List<GuestOsFeature> guestOsFeatures;
    @Key
    @JsonString
    private BigInteger id;
    @Key
    private CustomerEncryptionKey imageEncryptionKey;
    @Key
    private String kind;
    @Key
    private String labelFingerprint;
    @Key
    private Map<String, String> labels;
    @Key
    @JsonString
    private List<Long> licenseCodes;
    @Key
    private List<String> licenses;
    @Key
    private String name;
    @Key
    private RawDisk rawDisk;
    @Key
    private Boolean satisfiesPzs;
    @Key
    private String selfLink;
    @Key
    private InitialStateConfig shieldedInstanceInitialState;
    @Key
    private String sourceDisk;
    @Key
    private CustomerEncryptionKey sourceDiskEncryptionKey;
    @Key
    private String sourceDiskId;
    @Key
    private String sourceImage;
    @Key
    private CustomerEncryptionKey sourceImageEncryptionKey;
    @Key
    private String sourceImageId;
    @Key
    private String sourceSnapshot;
    @Key
    private CustomerEncryptionKey sourceSnapshotEncryptionKey;
    @Key
    private String sourceSnapshotId;
    @Key
    private String sourceType;
    @Key
    private String status;
    @Key
    private List<String> storageLocations;

    public String getArchitecture() {
        return this.architecture;
    }

    public Image setArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public Long getArchiveSizeBytes() {
        return this.archiveSizeBytes;
    }

    public Image setArchiveSizeBytes(Long archiveSizeBytes) {
        this.archiveSizeBytes = archiveSizeBytes;
        return this;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public Image setCreationTimestamp(String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
        return this;
    }

    public DeprecationStatus getDeprecated() {
        return this.deprecated;
    }

    public Image setDeprecated(DeprecationStatus deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Image setDescription(String description) {
        this.description = description;
        return this;
    }

    public Long getDiskSizeGb() {
        return this.diskSizeGb;
    }

    public Image setDiskSizeGb(Long diskSizeGb) {
        this.diskSizeGb = diskSizeGb;
        return this;
    }

    public String getFamily() {
        return this.family;
    }

    public Image setFamily(String family) {
        this.family = family;
        return this;
    }

    public List<GuestOsFeature> getGuestOsFeatures() {
        return this.guestOsFeatures;
    }

    public Image setGuestOsFeatures(List<GuestOsFeature> guestOsFeatures) {
        this.guestOsFeatures = guestOsFeatures;
        return this;
    }

    public BigInteger getId() {
        return this.id;
    }

    public Image setId(BigInteger id) {
        this.id = id;
        return this;
    }

    public CustomerEncryptionKey getImageEncryptionKey() {
        return this.imageEncryptionKey;
    }

    public Image setImageEncryptionKey(CustomerEncryptionKey imageEncryptionKey) {
        this.imageEncryptionKey = imageEncryptionKey;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public Image setKind(String kind) {
        this.kind = kind;
        return this;
    }

    public String getLabelFingerprint() {
        return this.labelFingerprint;
    }

    public byte[] decodeLabelFingerprint() {
        return Base64.decodeBase64((String)this.labelFingerprint);
    }

    public Image setLabelFingerprint(String labelFingerprint) {
        this.labelFingerprint = labelFingerprint;
        return this;
    }

    public Image encodeLabelFingerprint(byte[] labelFingerprint) {
        this.labelFingerprint = Base64.encodeBase64URLSafeString((byte[])labelFingerprint);
        return this;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Image setLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public List<Long> getLicenseCodes() {
        return this.licenseCodes;
    }

    public Image setLicenseCodes(List<Long> licenseCodes) {
        this.licenseCodes = licenseCodes;
        return this;
    }

    public List<String> getLicenses() {
        return this.licenses;
    }

    public Image setLicenses(List<String> licenses) {
        this.licenses = licenses;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Image setName(String name) {
        this.name = name;
        return this;
    }

    public RawDisk getRawDisk() {
        return this.rawDisk;
    }

    public Image setRawDisk(RawDisk rawDisk) {
        this.rawDisk = rawDisk;
        return this;
    }

    public Boolean getSatisfiesPzs() {
        return this.satisfiesPzs;
    }

    public Image setSatisfiesPzs(Boolean satisfiesPzs) {
        this.satisfiesPzs = satisfiesPzs;
        return this;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Image setSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
    }

    public InitialStateConfig getShieldedInstanceInitialState() {
        return this.shieldedInstanceInitialState;
    }

    public Image setShieldedInstanceInitialState(InitialStateConfig shieldedInstanceInitialState) {
        this.shieldedInstanceInitialState = shieldedInstanceInitialState;
        return this;
    }

    public String getSourceDisk() {
        return this.sourceDisk;
    }

    public Image setSourceDisk(String sourceDisk) {
        this.sourceDisk = sourceDisk;
        return this;
    }

    public CustomerEncryptionKey getSourceDiskEncryptionKey() {
        return this.sourceDiskEncryptionKey;
    }

    public Image setSourceDiskEncryptionKey(CustomerEncryptionKey sourceDiskEncryptionKey) {
        this.sourceDiskEncryptionKey = sourceDiskEncryptionKey;
        return this;
    }

    public String getSourceDiskId() {
        return this.sourceDiskId;
    }

    public Image setSourceDiskId(String sourceDiskId) {
        this.sourceDiskId = sourceDiskId;
        return this;
    }

    public String getSourceImage() {
        return this.sourceImage;
    }

    public Image setSourceImage(String sourceImage) {
        this.sourceImage = sourceImage;
        return this;
    }

    public CustomerEncryptionKey getSourceImageEncryptionKey() {
        return this.sourceImageEncryptionKey;
    }

    public Image setSourceImageEncryptionKey(CustomerEncryptionKey sourceImageEncryptionKey) {
        this.sourceImageEncryptionKey = sourceImageEncryptionKey;
        return this;
    }

    public String getSourceImageId() {
        return this.sourceImageId;
    }

    public Image setSourceImageId(String sourceImageId) {
        this.sourceImageId = sourceImageId;
        return this;
    }

    public String getSourceSnapshot() {
        return this.sourceSnapshot;
    }

    public Image setSourceSnapshot(String sourceSnapshot) {
        this.sourceSnapshot = sourceSnapshot;
        return this;
    }

    public CustomerEncryptionKey getSourceSnapshotEncryptionKey() {
        return this.sourceSnapshotEncryptionKey;
    }

    public Image setSourceSnapshotEncryptionKey(CustomerEncryptionKey sourceSnapshotEncryptionKey) {
        this.sourceSnapshotEncryptionKey = sourceSnapshotEncryptionKey;
        return this;
    }

    public String getSourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    public Image setSourceSnapshotId(String sourceSnapshotId) {
        this.sourceSnapshotId = sourceSnapshotId;
        return this;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public Image setSourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public Image setStatus(String status) {
        this.status = status;
        return this;
    }

    public List<String> getStorageLocations() {
        return this.storageLocations;
    }

    public Image setStorageLocations(List<String> storageLocations) {
        this.storageLocations = storageLocations;
        return this;
    }

    public Image set(String fieldName, Object value) {
        return (Image)super.set(fieldName, value);
    }

    public Image clone() {
        return (Image)super.clone();
    }

    static {
        Data.nullOf(GuestOsFeature.class);
    }

    public static final class RawDisk
    extends GenericJson {
        @Key
        private String containerType;
        @Key
        private String sha1Checksum;
        @Key
        private String source;

        public String getContainerType() {
            return this.containerType;
        }

        public RawDisk setContainerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        public String getSha1Checksum() {
            return this.sha1Checksum;
        }

        public RawDisk setSha1Checksum(String sha1Checksum) {
            this.sha1Checksum = sha1Checksum;
            return this;
        }

        public String getSource() {
            return this.source;
        }

        public RawDisk setSource(String source) {
            this.source = source;
            return this;
        }

        public RawDisk set(String fieldName, Object value) {
            return (RawDisk)super.set(fieldName, value);
        }

        public RawDisk clone() {
            return (RawDisk)super.clone();
        }
    }
}

